/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashSet;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.OrcsTokenService;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.executor.ExecutorAdmin;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.KeyValueOps;
import org.eclipse.osee.orcs.OrcsAdmin;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsApplicability;
import org.eclipse.osee.orcs.OrcsBranch;
import org.eclipse.osee.orcs.OrcsPerformance;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.OrcsTypes;
import org.eclipse.osee.orcs.SystemPreferences;
import org.eclipse.osee.orcs.core.ds.DataModule;
import org.eclipse.osee.orcs.core.ds.OrcsDataStore;
import org.eclipse.osee.orcs.core.internal.KeyValueOpsImpl;
import org.eclipse.osee.orcs.core.internal.OrcsAdminImpl;
import org.eclipse.osee.orcs.core.internal.OrcsBranchImpl;
import org.eclipse.osee.orcs.core.internal.OrcsPerformanceImpl;
import org.eclipse.osee.orcs.core.internal.access.UserGroupService;
import org.eclipse.osee.orcs.core.internal.applicability.OrcsApplicabilityOps;
import org.eclipse.osee.orcs.core.internal.artifact.ArtifactFactory;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeFactory;
import org.eclipse.osee.orcs.core.internal.graph.GraphBuilderFactory;
import org.eclipse.osee.orcs.core.internal.graph.GraphData;
import org.eclipse.osee.orcs.core.internal.graph.GraphProvider;
import org.eclipse.osee.orcs.core.internal.graph.impl.GraphFactoryImpl;
import org.eclipse.osee.orcs.core.internal.indexer.IndexerModule;
import org.eclipse.osee.orcs.core.internal.proxy.ExternalArtifactManager;
import org.eclipse.osee.orcs.core.internal.proxy.impl.ExternalArtifactManagerImpl;
import org.eclipse.osee.orcs.core.internal.relation.RelationFactory;
import org.eclipse.osee.orcs.core.internal.relation.RelationManager;
import org.eclipse.osee.orcs.core.internal.relation.RelationManagerFactory;
import org.eclipse.osee.orcs.core.internal.relation.impl.RelationNodeLoaderImpl;
import org.eclipse.osee.orcs.core.internal.script.ScriptEngines;
import org.eclipse.osee.orcs.core.internal.script.impl.OrcsScriptCompilerImpl;
import org.eclipse.osee.orcs.core.internal.search.QueryModule;
import org.eclipse.osee.orcs.core.internal.session.OrcsSessionImpl;
import org.eclipse.osee.orcs.core.internal.transaction.TransactionFactoryImpl;
import org.eclipse.osee.orcs.core.internal.transaction.TxCallableFactory;
import org.eclipse.osee.orcs.core.internal.transaction.TxDataLoaderImpl;
import org.eclipse.osee.orcs.core.internal.transaction.TxDataManager;
import org.eclipse.osee.orcs.core.internal.types.BranchHierarchyProvider;
import org.eclipse.osee.orcs.core.internal.types.OrcsTypesModule;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.QueryIndexer;
import org.eclipse.osee.orcs.search.TransactionQuery;
import org.eclipse.osee.orcs.transaction.TransactionFactory;
import org.osgi.service.event.EventAdmin;

public class OrcsApiImpl
implements OrcsApi {
    private Log logger;
    private OrcsDataStore dataStore;
    private ExecutorAdmin executorAdmin;
    private SystemPreferences preferences;
    private EventAdmin eventAdmin;
    private OrcsTokenService tokenService;
    private QueryModule queryModule;
    private IndexerModule indexerModule;
    private OrcsTypesModule typesModule;
    private OrcsSession systemSession;
    private DataModule module;
    private TxDataManager txDataManager;
    private TxCallableFactory txCallableFactory;
    private ScriptEngineManager manager;
    private OrcsApplicabilityOps applicability;
    private UserGroupService userGroupService;
    ExternalArtifactManager proxyManager;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setOrcsDataStore(OrcsDataStore dataStore) {
        this.dataStore = dataStore;
    }

    public void setExecutorAdmin(ExecutorAdmin executorAdmin) {
        this.executorAdmin = executorAdmin;
    }

    public void setSystemPreferences(SystemPreferences preferences) {
        this.preferences = preferences;
    }

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void setOrcsTokenService(OrcsTokenService tokenService) {
        this.tokenService = tokenService;
    }

    public void start() {
        this.systemSession = this.createSession();
        BranchHierarchyProvider hierarchyProvider = new BranchHierarchyProvider(){
            private final ThreadLocal<Iterable<? extends BranchId>> cache = new ThreadLocal();

            @Override
            public Iterable<? extends BranchId> getParentHierarchy(BranchId branch) {
                LinkedHashSet toReturn = this.cache.get();
                if (toReturn == null) {
                    LinkedHashSet branches = Sets.newLinkedHashSet();
                    BranchQuery branchQuery = OrcsApiImpl.this.getQueryFactory().branchQuery();
                    branchQuery.andIsAncestorOf(branch);
                    branches.add(branch);
                    for (BranchId parent : branchQuery.getResults()) {
                        if (branches.add(parent)) continue;
                        OrcsApiImpl.this.logger.error("Cycle detected with branch: [%s]", new Object[]{parent});
                        return Collections.emptyList();
                    }
                    this.cache.set(branches);
                    toReturn = branches;
                }
                return toReturn;
            }
        };
        this.typesModule = new OrcsTypesModule(this.logger, this.dataStore.getTypesDataStore(), hierarchyProvider);
        this.typesModule.start(this.getSystemSession());
        OrcsTypes orcsTypes = this.typesModule.createOrcsTypes(this.getSystemSession());
        this.module = this.dataStore.createDataModule(orcsTypes, this.tokenService);
        AttributeFactory attributeFactory = new AttributeFactory(this.module.getDataFactory(), orcsTypes.getAttributeTypes());
        ArtifactFactory artifactFactory = new ArtifactFactory(this.module.getDataFactory(), attributeFactory, orcsTypes.getArtifactTypes());
        RelationFactory relationFactory = new RelationFactory(this.module.getDataFactory());
        final GraphFactoryImpl graphFactory = new GraphFactoryImpl();
        GraphBuilderFactory graphBuilderFactory = new GraphBuilderFactory(this.logger, artifactFactory, attributeFactory, relationFactory);
        QueryModule.QueryModuleProvider queryModuleProvider = new QueryModule.QueryModuleProvider(){

            @Override
            public QueryFactory getQueryFactory(OrcsSession session) {
                return OrcsApiImpl.this.queryModule.createQueryFactory(session);
            }
        };
        RelationNodeLoaderImpl nodeLoader = new RelationNodeLoaderImpl(this.module.getDataLoaderFactory(), graphBuilderFactory);
        RelationManager relationManager = RelationManagerFactory.createRelationManager(this.logger, orcsTypes.getRelationTypes(), relationFactory, nodeLoader, queryModuleProvider);
        GraphProvider graphProvider = new GraphProvider(){

            @Override
            public GraphData getGraph(OrcsSession session, BranchId branch, TransactionId transactionId) {
                return graphFactory.createGraph(session, branch, transactionId);
            }
        };
        this.proxyManager = new ExternalArtifactManagerImpl(relationManager, orcsTypes.getArtifactTypes());
        TxDataLoaderImpl.TransactionProvider txProvider = new TxDataLoaderImpl.TransactionProvider(){

            @Override
            public TransactionId getHeadTransaction(OrcsSession session, BranchId branch) {
                QueryFactory queryFactory = OrcsApiImpl.this.queryModule.createQueryFactory(session);
                return (TransactionId)((TransactionQuery)queryFactory.transactionQuery().andIsHead(branch)).getResults().getExactlyOne();
            }
        };
        TxDataLoaderImpl txDataLoader = new TxDataLoaderImpl(this.module.getDataLoaderFactory(), graphFactory, graphBuilderFactory, graphProvider, txProvider);
        this.txDataManager = new TxDataManager(this.proxyManager, artifactFactory, relationManager, this.module.getDataFactory(), txDataLoader);
        this.txCallableFactory = new TxCallableFactory(this.logger, this.module.getTxDataStore(), this.txDataManager);
        this.queryModule = new QueryModule(this.logger, this.module.getQueryEngine(), graphBuilderFactory, graphProvider, orcsTypes, this.proxyManager);
        this.indexerModule = new IndexerModule(this.logger, this.preferences, this.executorAdmin, this.dataStore.getQueryEngineIndexer());
        this.indexerModule.start(this.getSystemSession(), orcsTypes.getAttributeTypes());
        OrcsScriptCompilerImpl compiler = new OrcsScriptCompilerImpl(this.getSystemSession(), this.module, orcsTypes, this.queryModule);
        this.manager = ScriptEngines.newScriptEngineManager(compiler);
        this.applicability = new OrcsApplicabilityOps(this);
    }

    public void stop() {
        if (this.indexerModule != null) {
            this.indexerModule.stop();
        }
        this.queryModule = null;
        this.txDataManager = null;
        this.txCallableFactory = null;
        this.module = null;
        if (this.typesModule != null) {
            this.typesModule.stop();
        }
        this.systemSession = null;
    }

    public boolean isTypesValid() {
        return this.dataStore.getTypesDataStore().isTypesResourcesValid();
    }

    public QueryFactory getQueryFactory() {
        OrcsSession session = this.getSession();
        return this.queryModule.createQueryFactory(session);
    }

    public OrcsBranch getBranchOps() {
        OrcsSession session = this.getSession();
        QueryFactory queryFactory = this.getQueryFactory();
        return new OrcsBranchImpl(this, this.logger, session, this.module.getBranchDataStore(), queryFactory, this.getOrcsTypes());
    }

    public KeyValueOps getKeyValueOps() {
        return new KeyValueOpsImpl(this.module.getKeyValueStore());
    }

    public TransactionFactory getTransactionFactory() {
        OrcsSession session = this.getSession();
        return new TransactionFactoryImpl(session, this.txDataManager, this.txCallableFactory, this, this.getBranchOps(), this.getKeyValueOps(), this.module.getTxDataStore());
    }

    public OrcsAdmin getAdminOps() {
        OrcsSession session = this.getSession();
        return new OrcsAdminImpl(this, this.logger, session, this.module.getDataStoreAdmin(), this.eventAdmin);
    }

    public OrcsPerformance getOrcsPerformance() {
        OrcsSession session = this.getSession();
        return new OrcsPerformanceImpl(this.logger, session, this.queryModule, this.indexerModule);
    }

    public QueryIndexer getQueryIndexer() {
        OrcsSession session = this.getSession();
        return this.indexerModule.createQueryIndexer(session, this.getOrcsTypes().getAttributeTypes());
    }

    private OrcsSession getSystemSession() {
        return this.systemSession;
    }

    private OrcsSession getSession() {
        String sessionId = GUID.create();
        return new OrcsSessionImpl(sessionId);
    }

    public OrcsTypes getOrcsTypes() {
        OrcsSession session = this.getSession();
        return this.typesModule.createOrcsTypes(session);
    }

    private OrcsSession createSession() {
        String sessionId = GUID.create();
        return new OrcsSessionImpl(sessionId);
    }

    public ScriptEngine getScriptEngine() {
        return this.manager.getEngineByName("orcs");
    }

    public SystemPreferences getSystemPreferences() {
        return this.preferences;
    }

    public OrcsApplicability getApplicabilityOps() {
        return this.applicability;
    }

    public UserGroupService getUserGroupService() {
        if (this.userGroupService == null) {
            this.userGroupService = new UserGroupService();
        }
        return this.userGroupService;
    }
}

