/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.config.admin.internal;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osee.config.admin.internal.ConfigWriter;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class ConfigParser {
    public void process(ConfigWriter writer, String source) {
        if (Strings.isValid((String)source)) {
            JsonNode services = JsonUtil.readTree((String)source).get("config");
            for (JsonNode serviceNode : services) {
                Hashtable<String, Object> properties = new Hashtable<String, Object>();
                Iterator kvPairs = serviceNode.fields();
                while (kvPairs.hasNext()) {
                    Map.Entry entry = (Map.Entry)kvPairs.next();
                    String key = (String)entry.getKey();
                    JsonNode value = (JsonNode)entry.getValue();
                    if (value.isValueNode()) {
                        properties.put(key, value.asText());
                        if (!key.equalsIgnoreCase("service.pid")) continue;
                        writer.write(value.asText(), properties);
                        continue;
                    }
                    properties.put(key, value.toString());
                }
            }
        }
    }
}

