/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import java.net.URI;
import java.util.concurrent.Callable;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserTokens;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsMetaData;
import org.eclipse.osee.orcs.rest.internal.OrcsRestUtil;
import org.eclipse.osee.orcs.rest.model.DatastoreEndpoint;
import org.eclipse.osee.orcs.rest.model.DatastoreInfo;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class DatastoreEndpointImpl
implements DatastoreEndpoint {
    @Context
    private UriInfo uriInfo;
    private final ActivityLog activityLog;
    private final OrcsApi orcsApi;

    public DatastoreEndpointImpl(OrcsApi orcsApi, ActivityLog activityLog) {
        this.orcsApi = orcsApi;
        this.activityLog = activityLog;
    }

    protected void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public DatastoreInfo getInfo() {
        Callable callable = this.orcsApi.getAdminOps().createFetchOrcsMetaData();
        OrcsMetaData metaData = (OrcsMetaData)OrcsRestUtil.executeCallable(callable);
        return this.asDatastoreInfo(metaData);
    }

    public void initialize(String typeModel) {
        this.activityLog.setEnabled(false);
        this.orcsApi.getAdminOps().createDatastoreAndSystemBranches(typeModel);
        this.activityLog.setEnabled(true);
    }

    public void synonyms() {
        this.activityLog.setEnabled(false);
        this.orcsApi.getAdminOps().createSynonymsAndGrants();
        this.activityLog.setEnabled(true);
    }

    public Response migrate() {
        this.activityLog.setEnabled(false);
        Callable callable = this.orcsApi.getAdminOps().migrateDatastore();
        OrcsMetaData metaData = (OrcsMetaData)OrcsRestUtil.executeCallable(callable);
        URI location = this.getDatastoreLocation(this.uriInfo);
        return Response.created((URI)location).entity((Object)this.asDatastoreInfo(metaData)).build();
    }

    private URI getDatastoreLocation(UriInfo uriInfo) {
        return uriInfo.getRequestUriBuilder().path("../").path("info").build(new Object[0]);
    }

    private DatastoreInfo asDatastoreInfo(OrcsMetaData metaData) {
        DatastoreInfo info = new DatastoreInfo();
        info.setProperties(metaData.getProperties());
        return info;
    }

    public void createDemoBranches() {
        this.orcsApi.getAdminOps().createDemoBranches();
    }

    public TransactionId createUsers(UserTokens users) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, (UserId)users.getAccount(), "DatastoreEndpointImpl.createUsers()");
        this.orcsApi.getAdminOps().createUsers(tx, (Iterable)users.getUsers());
        return tx.commit();
    }
}

