/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.framework.core.data.AttributeTypeArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeBoolean;
import org.eclipse.osee.framework.core.data.AttributeTypeBranchId;
import org.eclipse.osee.framework.core.data.AttributeTypeDate;
import org.eclipse.osee.framework.core.data.AttributeTypeDouble;
import org.eclipse.osee.framework.core.data.AttributeTypeEnum;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeInputStream;
import org.eclipse.osee.framework.core.data.AttributeTypeInteger;
import org.eclipse.osee.framework.core.data.AttributeTypeLong;
import org.eclipse.osee.framework.core.data.AttributeTypeObject;
import org.eclipse.osee.framework.core.data.AttributeTypeString;
import org.eclipse.osee.framework.core.data.NamespaceToken;
import org.eclipse.osee.framework.core.data.TaggerTypeToken;
import org.eclipse.osee.framework.jdk.core.type.FullyNamed;
import org.eclipse.osee.framework.jdk.core.type.HasDescription;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.NamedId;

public interface AttributeTypeToken
extends AttributeTypeId,
FullyNamed,
HasDescription,
NamedId {
    public static final AttributeTypeToken SENTINEL = AttributeTypeToken.valueOf(Id.SENTINEL, "Sentinel");
    public static final String APPLICATION_ZIP = "application/zip";
    public static final String TEXT_CALENDAR = "text/calendar";
    public static final String TEXT_URI_LIST = "text/uri-list";
    public static final String APPLICATION_MSWORD = "application/msword";
    public static final String MODEL_OSEE = "model/osee";
    public static final String IMAGE = "image/*";

    public String getMediaType();

    default public NamespaceToken getNamespace() {
        return NamespaceToken.SENTINEL;
    }

    default public TaggerTypeToken getTaggerType() {
        return TaggerTypeToken.SENTINEL;
    }

    public static AttributeTypeToken valueOf(String id) {
        return AttributeTypeToken.valueOf(Long.valueOf(id), "Sentinel");
    }

    public static AttributeTypeToken valueOf(int id, String name) {
        return AttributeTypeToken.valueOf(Long.valueOf(id), name, "");
    }

    public static AttributeTypeToken valueOf(Long id, String name) {
        return AttributeTypeToken.valueOf(id, name, "");
    }

    public static @NonNull AttributeTypeToken valueOf(Long id, String name, String description) {
        return new AttributeTypeObject(id, NamespaceToken.SENTINEL, name, "mediaType", description, TaggerTypeToken.SENTINEL);
    }

    public static @NonNull AttributeTypeArtifactId createArtifactId(Long id, NamespaceToken namespace, String name, String mediaType, String description, TaggerTypeToken taggerType) {
        return new AttributeTypeArtifactId(id, namespace, name, mediaType, description, taggerType);
    }

    public static @NonNull AttributeTypeArtifactId createArtifactId(Long id, NamespaceToken namespace, String name, String mediaType, String description) {
        return AttributeTypeToken.createArtifactId(id, namespace, name, mediaType, description, AttributeTypeToken.determineTaggerType(mediaType));
    }

    public static @NonNull AttributeTypeArtifactId createArtifactIdNoTag(Long id, NamespaceToken namespace, String name, String mediaType, String description) {
        return AttributeTypeToken.createArtifactId(id, namespace, name, mediaType, description, TaggerTypeToken.SENTINEL);
    }

    public static @NonNull AttributeTypeBoolean createBoolean(Long id, NamespaceToken namespace, String name, String mediaType, String description, TaggerTypeToken taggerType) {
        return new AttributeTypeBoolean(id, namespace, name, mediaType, description, taggerType);
    }

    public static @NonNull AttributeTypeBoolean createBoolean(Long id, NamespaceToken namespace, String name, String mediaType, String description) {
        return AttributeTypeToken.createBoolean(id, namespace, name, mediaType, description, AttributeTypeToken.determineTaggerType(mediaType));
    }

    public static @NonNull AttributeTypeBoolean createBooleanNoTag(Long id, NamespaceToken namespace, String name, String mediaType, String description) {
        return AttributeTypeToken.createBoolean(id, namespace, name, mediaType, description, TaggerTypeToken.SENTINEL);
    }

    public static @NonNull AttributeTypeBranchId createBranchId(Long id, NamespaceToken namespace, String name, String mediaType, String description, TaggerTypeToken taggerType) {
        return new AttributeTypeBranchId(id, namespace, name, mediaType, description, taggerType);
    }

    public static @NonNull AttributeTypeBranchId createBranchId(Long id, NamespaceToken namespace, String name, String mediaType, String description) {
        return AttributeTypeToken.createBranchId(id, namespace, name, mediaType, description, AttributeTypeToken.determineTaggerType(mediaType));
    }

    public static @NonNull AttributeTypeBranchId createBranchIdNoTag(Long id, NamespaceToken namespace, String name, String mediaType, String description) {
        return AttributeTypeToken.createBranchId(id, namespace, name, mediaType, description, TaggerTypeToken.SENTINEL);
    }

    public static @NonNull AttributeTypeDate createDate(Long id, NamespaceToken namespace, String name, String mediaType, String description, TaggerTypeToken taggerType) {
        return new AttributeTypeDate(id, namespace, name, mediaType, description, taggerType);
    }

    public static @NonNull AttributeTypeDate createDate(Long id, NamespaceToken namespace, String name, String mediaType, String description) {
        return AttributeTypeToken.createDate(id, namespace, name, mediaType, description, AttributeTypeToken.determineTaggerType(mediaType));
    }

    public static @NonNull AttributeTypeDate createDateNoTag(Long id, NamespaceToken namespace, String name, String mediaType, String description) {
        return AttributeTypeToken.createDate(id, namespace, name, mediaType, description, TaggerTypeToken.SENTINEL);
    }

    public static @NonNull AttributeTypeDouble createDouble(Long id, NamespaceToken namespace, String name, String mediaType, String description, TaggerTypeToken taggerType) {
        return new AttributeTypeDouble(id, namespace, name, mediaType, description, taggerType);
    }

    public static @NonNull AttributeTypeDouble createDouble(Long id, NamespaceToken namespace, String name, String mediaType, String description) {
        return AttributeTypeToken.createDouble(id, namespace, name, mediaType, description, AttributeTypeToken.determineTaggerType(mediaType));
    }

    public static @NonNull AttributeTypeDouble createDoubleNoTag(Long id, NamespaceToken namespace, String name, String mediaType, String description) {
        return AttributeTypeToken.createDouble(id, namespace, name, mediaType, description, TaggerTypeToken.SENTINEL);
    }

    public static @NonNull AttributeTypeEnum createEnum(Long id, NamespaceToken namespace, String name, String mediaType, String description, TaggerTypeToken taggerType) {
        return new AttributeTypeEnum(id, namespace, name, mediaType, description, taggerType);
    }

    public static @NonNull AttributeTypeEnum createEnum(Long id, NamespaceToken namespace, String name, String mediaType, String description) {
        return AttributeTypeToken.createEnum(id, namespace, name, mediaType, description, AttributeTypeToken.determineTaggerType(mediaType));
    }

    public static @NonNull AttributeTypeEnum createEnumNoTag(Long id, NamespaceToken namespace, String name, String mediaType, String description) {
        return AttributeTypeToken.createEnum(id, namespace, name, mediaType, description, TaggerTypeToken.SENTINEL);
    }

    public static @NonNull AttributeTypeInputStream createInputStream(Long id, NamespaceToken namespace, String name, String mediaType, String description, TaggerTypeToken taggerType) {
        return new AttributeTypeInputStream(id, namespace, name, mediaType, description, taggerType);
    }

    public static @NonNull AttributeTypeInputStream createInputStream(Long id, NamespaceToken namespace, String name, String mediaType, String description) {
        return AttributeTypeToken.createInputStream(id, namespace, name, mediaType, description, AttributeTypeToken.determineTaggerType(mediaType));
    }

    public static @NonNull AttributeTypeInputStream createInputStreamNoTag(Long id, NamespaceToken namespace, String name, String mediaType, String description) {
        return AttributeTypeToken.createInputStream(id, namespace, name, mediaType, description, TaggerTypeToken.SENTINEL);
    }

    public static @NonNull AttributeTypeInteger createInteger(Long id, NamespaceToken namespace, String name, String mediaType, String description, TaggerTypeToken taggerType) {
        return new AttributeTypeInteger(id, namespace, name, mediaType, description, taggerType);
    }

    public static @NonNull AttributeTypeInteger createInteger(Long id, NamespaceToken namespace, String name, String mediaType, String description) {
        return AttributeTypeToken.createInteger(id, namespace, name, mediaType, description, AttributeTypeToken.determineTaggerType(mediaType));
    }

    public static @NonNull AttributeTypeInteger createIntegerNoTag(Long id, NamespaceToken namespace, String name, String mediaType, String description) {
        return AttributeTypeToken.createInteger(id, namespace, name, mediaType, description, TaggerTypeToken.SENTINEL);
    }

    public static @NonNull AttributeTypeLong createLong(Long id, NamespaceToken namespace, String name, String mediaType, String description, TaggerTypeToken taggerType) {
        return new AttributeTypeLong(id, namespace, name, mediaType, description, taggerType);
    }

    public static @NonNull AttributeTypeLong createLong(Long id, NamespaceToken namespace, String name, String mediaType, String description) {
        return AttributeTypeToken.createLong(id, namespace, name, mediaType, description, AttributeTypeToken.determineTaggerType(mediaType));
    }

    public static @NonNull AttributeTypeLong createLongNoTag(Long id, NamespaceToken namespace, String name, String mediaType, String description) {
        return AttributeTypeToken.createLong(id, namespace, name, mediaType, description, TaggerTypeToken.SENTINEL);
    }

    public static @NonNull AttributeTypeString createString(Long id, NamespaceToken namespace, String name, String mediaType, String description, TaggerTypeToken taggerType) {
        return new AttributeTypeString(id, namespace, name, mediaType, description, taggerType);
    }

    public static @NonNull AttributeTypeString createString(Long id, NamespaceToken namespace, String name, String mediaType, String description) {
        return AttributeTypeToken.createString(id, namespace, name, mediaType, description, AttributeTypeToken.determineTaggerType(mediaType));
    }

    public static @NonNull AttributeTypeString createStringNoTag(Long id, NamespaceToken namespace, String name, String mediaType, String description) {
        return AttributeTypeToken.createString(id, namespace, name, mediaType, description, TaggerTypeToken.SENTINEL);
    }

    public static TaggerTypeToken determineTaggerType(String mediaType) {
        switch (mediaType) {
            case "text/html": 
            case "application/msword": {
                return TaggerTypeToken.XmlTagger;
            }
        }
        return TaggerTypeToken.PlainTextTagger;
    }
}

