/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

public class STPMetadataSingleton {
    private static STPMetadataSingleton instance = null;
    private static HashMap<String, ArrayList<String>> builtMetadata = new HashMap();
    private static boolean barLookups = false;

    protected STPMetadataSingleton() {
    }

    public static STPMetadataSingleton getInstance() {
        if (instance == null) {
            instance = new STPMetadataSingleton();
        }
        return instance;
    }

    public static String[] getCompletionResults(String match) {
        ArrayList<Object> data = new ArrayList();
        if (barLookups) {
            return new String[]{"No completion data found."};
        }
        boolean tapsetAndProbeIncluded = STPMetadataSingleton.isTapsetAndProbe(match);
        if (tapsetAndProbeIncluded) {
            ArrayList<String> temp = builtMetadata.get(STPMetadataSingleton.getTapset(match));
            String probe = STPMetadataSingleton.getTapsetProbe(match);
            int i = 0;
            while (i < temp.size()) {
                if (temp.get(i).startsWith(probe)) {
                    data.add(temp.get(i));
                }
                ++i;
            }
        } else {
            data = builtMetadata.get(match);
        }
        if (data == null) {
            return new String[0];
        }
        return data.toArray(new String[0]);
    }

    private void readCompletionMetadata(URL fileURL) throws IOException {
        BufferedReader input = new BufferedReader(new FileReader(new File(fileURL.getFile())));
        try {
            String line = null;
            while ((line = input.readLine()) != null) {
                String tapset = "";
                String probe = "";
                try {
                    tapset = STPMetadataSingleton.getTapset(line);
                    probe = STPMetadataSingleton.getTapsetProbe(line);
                }
                catch (Exception exception) {
                    continue;
                }
                ArrayList<String> data = builtMetadata.get(tapset);
                if (data == null) {
                    data = new ArrayList();
                }
                data.add(probe);
                builtMetadata.put(tapset, data);
            }
        }
        finally {
            input.close();
        }
    }

    private static boolean isTapsetAndProbe(String data) {
        return data.indexOf(46) >= 0;
    }

    private static String getTapset(String data) {
        int i = data.indexOf(46);
        if (i < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        return data.substring(0, data.indexOf(46));
    }

    private static String getTapsetProbe(String data) {
        int i = data.indexOf(46);
        if (i < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        return data.substring(data.indexOf(46) + 1, data.length());
    }

    public void build(URL fileURL) {
        try {
            this.readCompletionMetadata(fileURL);
        }
        catch (IOException iOException) {
            barLookups = true;
        }
    }
}

