/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.Messages;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.resources.ResourcesEntry;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.resources.ResourcesEvent;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.resources.ResourcesPresentationProvider;
import org.eclipse.linuxtools.lttng2.kernel.core.trace.CtfKernelTrace;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfRangeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfStateSystemBuildCompleted;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimeSynchSignal;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateSystemQuerier;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphRangeListener;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphTimeListener;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphRangeUpdateEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphTimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;

public class ResourcesView
extends TmfView {
    public static final String ID = "org.eclipse.linuxtools.lttng2.kernel.ui.views.resources";
    private static final long INITIAL_WINDOW_OFFSET = 100000000L;
    TimeGraphViewer fTimeGraphViewer;
    private TmfExperiment<ITmfEvent> fSelectedExperiment;
    private ArrayList<TraceEntry> fEntryList;
    private long fStartTime;
    private long fEndTime;
    private int fDisplayWidth;
    private Action fNextResourceAction;
    private Action fPreviousResourceAction;
    private ZoomThread fZoomThread;

    public ResourcesView() {
        super(ID);
        this.fDisplayWidth = Display.getDefault().getBounds().width;
    }

    public void createPartControl(Composite parent) {
        this.fTimeGraphViewer = new TimeGraphViewer(parent, 0);
        this.fTimeGraphViewer.setTimeGraphProvider((ITimeGraphPresentationProvider)new ResourcesPresentationProvider());
        this.fTimeGraphViewer.setTimeCalendarFormat(true);
        this.fTimeGraphViewer.addRangeListener(new ITimeGraphRangeListener(){

            public void timeRangeUpdated(TimeGraphRangeUpdateEvent event) {
                long startTime = event.getStartTime();
                long endTime = event.getEndTime();
                TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)new CtfTmfTimestamp(startTime), (ITmfTimestamp)new CtfTmfTimestamp(endTime));
                CtfTmfTimestamp time = new CtfTmfTimestamp(ResourcesView.this.fTimeGraphViewer.getSelectedTime());
                ResourcesView.this.broadcast((TmfSignal)new TmfRangeSynchSignal((Object)ResourcesView.this, range, (ITmfTimestamp)time));
                ResourcesView.this.startZoomThread(startTime, endTime);
            }
        });
        this.fTimeGraphViewer.addTimeListener(new ITimeGraphTimeListener(){

            public void timeSelected(TimeGraphTimeEvent event) {
                long time = event.getTime();
                ResourcesView.this.broadcast((TmfSignal)new TmfTimeSynchSignal((Object)ResourcesView.this, (ITmfTimestamp)new CtfTmfTimestamp(time)));
            }
        });
        Thread thread = new Thread("ResourcesView build"){

            @Override
            public void run() {
                if (TmfExperiment.getCurrentExperiment() != null) {
                    ResourcesView.this.selectExperiment(TmfExperiment.getCurrentExperiment());
                }
            }
        };
        thread.start();
        this.makeActions();
        this.contributeToActionBars();
    }

    public void setFocus() {
        this.fTimeGraphViewer.setFocus();
    }

    @TmfSignalHandler
    public void experimentSelected(final TmfExperimentSelectedSignal<? extends TmfEvent> signal) {
        if (signal.getExperiment().equals(this.fSelectedExperiment)) {
            return;
        }
        Thread thread = new Thread("ResourcesView build"){

            @Override
            public void run() {
                ResourcesView.this.selectExperiment(signal.getExperiment());
            }
        };
        thread.start();
    }

    @TmfSignalHandler
    public void synchToTime(TmfTimeSynchSignal signal) {
        if (signal.getSource() == this) {
            return;
        }
        final long time = signal.getCurrentTime().normalize(0L, -9).getValue();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ResourcesView.this.fTimeGraphViewer.getControl().isDisposed()) {
                    return;
                }
                ResourcesView.this.fTimeGraphViewer.setSelectedTime(time, true);
                ResourcesView.this.startZoomThread(ResourcesView.this.fTimeGraphViewer.getTime0(), ResourcesView.this.fTimeGraphViewer.getTime1());
            }
        });
    }

    @TmfSignalHandler
    public void synchToRange(TmfRangeSynchSignal signal) {
        if (signal.getSource() == this) {
            return;
        }
        final long startTime = signal.getCurrentRange().getStartTime().normalize(0L, -9).getValue();
        final long endTime = signal.getCurrentRange().getEndTime().normalize(0L, -9).getValue();
        final long time = signal.getCurrentTime().normalize(0L, -9).getValue();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ResourcesView.this.fTimeGraphViewer.getControl().isDisposed()) {
                    return;
                }
                ResourcesView.this.fTimeGraphViewer.setStartFinishTime(startTime, endTime);
                ResourcesView.this.fTimeGraphViewer.setSelectedTime(time, false);
                ResourcesView.this.startZoomThread(startTime, endTime);
            }
        });
    }

    @TmfSignalHandler
    public void stateSystemBuildCompleted(TmfStateSystemBuildCompleted signal) {
        final TmfExperiment<ITmfEvent> selectedExperiment = this.fSelectedExperiment;
        if (selectedExperiment == null) {
            return;
        }
        ITmfTrace[] iTmfTraceArray = selectedExperiment.getTraces();
        int n = iTmfTraceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfTrace trace = iTmfTraceArray[n2];
            if (trace == signal.getTrace() && trace instanceof CtfKernelTrace) {
                Thread thread = new Thread("ResourcesView build"){

                    @Override
                    public void run() {
                        ResourcesView.this.selectExperiment(selectedExperiment);
                    }
                };
                thread.start();
            }
            ++n2;
        }
    }

    private void selectExperiment(TmfExperiment<?> experiment) {
        this.fStartTime = Long.MAX_VALUE;
        this.fEndTime = Long.MIN_VALUE;
        this.fSelectedExperiment = experiment;
        ArrayList<TraceEntry> entryList = new ArrayList<TraceEntry>();
        ITmfTrace[] iTmfTraceArray = experiment.getTraces();
        int n = iTmfTraceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfTrace trace = iTmfTraceArray[n2];
            if (trace instanceof CtfKernelTrace) {
                CtfKernelTrace ctfKernelTrace = (CtfKernelTrace)trace;
                IStateSystemQuerier ssq = ctfKernelTrace.getStateSystem();
                long startTime = ssq.getStartTime();
                long endTime = ssq.getCurrentEndTime() + 1L;
                TraceEntry groupEntry = new TraceEntry(ctfKernelTrace, trace.getName(), startTime, endTime);
                entryList.add(groupEntry);
                this.fStartTime = Math.min(this.fStartTime, startTime);
                this.fEndTime = Math.max(this.fEndTime, endTime);
                List cpuQuarks = ssq.getQuarks(new String[]{"CPUs", "*"});
                ResourcesEntry[] cpuEntries = new ResourcesEntry[cpuQuarks.size()];
                int i = 0;
                while (i < cpuQuarks.size()) {
                    int cpuQuark = (Integer)cpuQuarks.get(i);
                    int cpu = Integer.parseInt(ssq.getAttributeName(cpuQuark));
                    ResourcesEntry entry = new ResourcesEntry(cpuQuark, ctfKernelTrace, ResourcesEntry.Type.CPU, cpu);
                    groupEntry.addChild(entry);
                    cpuEntries[i] = entry;
                    ++i;
                }
                List irqQuarks = ssq.getQuarks(new String[]{"Resources", "IRQs", "*"});
                ResourcesEntry[] irqEntries = new ResourcesEntry[irqQuarks.size()];
                int i2 = 0;
                while (i2 < irqQuarks.size()) {
                    int irqQuark = (Integer)irqQuarks.get(i2);
                    int irq = Integer.parseInt(ssq.getAttributeName(irqQuark));
                    ResourcesEntry entry = new ResourcesEntry(irqQuark, ctfKernelTrace, ResourcesEntry.Type.IRQ, irq);
                    groupEntry.addChild(entry);
                    irqEntries[i2] = entry;
                    ++i2;
                }
                List softIrqQuarks = ssq.getQuarks(new String[]{"Resources", "Soft_IRQs", "*"});
                ResourcesEntry[] softIrqEntries = new ResourcesEntry[softIrqQuarks.size()];
                int i3 = 0;
                while (i3 < softIrqQuarks.size()) {
                    int softIrqQuark = (Integer)softIrqQuarks.get(i3);
                    int softIrq = Integer.parseInt(ssq.getAttributeName(softIrqQuark));
                    ResourcesEntry entry = new ResourcesEntry(softIrqQuark, ctfKernelTrace, ResourcesEntry.Type.SOFT_IRQ, softIrq);
                    groupEntry.addChild(entry);
                    softIrqEntries[i3] = entry;
                    ++i3;
                }
            }
            ++n2;
        }
        this.fEntryList = entryList;
        this.refresh(100000000L);
        for (TraceEntry traceEntry : this.fEntryList) {
            CtfKernelTrace ctfKernelTrace = traceEntry.getTrace();
            IStateSystemQuerier ssq = ctfKernelTrace.getStateSystem();
            long startTime = ssq.getStartTime();
            long endTime = ssq.getCurrentEndTime() + 1L;
            long resolution = (endTime - startTime) / (long)this.fDisplayWidth;
            ResourcesEntry[] resourcesEntryArray = traceEntry.getChildren();
            int n3 = resourcesEntryArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ResourcesEntry entry = resourcesEntryArray[n4];
                List<ITimeEvent> eventList = this.getEventList(entry, startTime, endTime, resolution, false, (IProgressMonitor)new NullProgressMonitor());
                entry.setEventList(eventList);
                this.redraw();
                ++n4;
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<ITimeEvent> getEventList(ResourcesEntry entry, long startTime, long endTime, long resolution, boolean includeNull, IProgressMonitor monitor) {
        IStateSystemQuerier ssq = entry.getTrace().getStateSystem();
        startTime = Math.max(startTime, ssq.getStartTime());
        if ((endTime = Math.min(endTime, ssq.getCurrentEndTime() + 1L)) <= startTime) {
            return null;
        }
        ArrayList<TimeEvent> eventList = null;
        int quark = entry.getQuark();
        try {
            if (entry.getType().equals((Object)ResourcesEntry.Type.CPU)) {
                int statusQuark = ssq.getQuarkRelative(quark, new String[]{"Status"});
                List statusIntervals = ssq.queryHistoryRange(statusQuark, startTime, endTime - 1L, resolution);
                eventList = new ArrayList(statusIntervals.size());
                long lastEndTime = -1L;
                for (ITmfStateInterval statusInterval : statusIntervals) {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    int status = statusInterval.getStateValue().unboxInt();
                    long time = statusInterval.getStartTime();
                    long duration = statusInterval.getEndTime() - time + 1L;
                    if (!statusInterval.getStateValue().isNull()) {
                        if (lastEndTime != time && lastEndTime != -1L) {
                            eventList.add(new TimeEvent((ITimeGraphEntry)entry, lastEndTime, time - lastEndTime));
                        }
                        eventList.add(new ResourcesEvent(entry, time, duration, status));
                        lastEndTime = time + duration;
                        continue;
                    }
                    if (!includeNull) continue;
                    eventList.add(new ResourcesEvent(entry, time, duration));
                }
            } else if (entry.getType().equals((Object)ResourcesEntry.Type.IRQ)) {
                List irqIntervals = ssq.queryHistoryRange(quark, startTime, endTime - 1L, resolution);
                eventList = new ArrayList<TimeEvent>(irqIntervals.size());
                long lastEndTime = -1L;
                boolean lastIsNull = true;
                for (ITmfStateInterval irqInterval : irqIntervals) {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    long time = irqInterval.getStartTime();
                    long duration = irqInterval.getEndTime() - time + 1L;
                    if (!irqInterval.getStateValue().isNull()) {
                        int cpu = irqInterval.getStateValue().unboxInt();
                        eventList.add(new ResourcesEvent(entry, time, duration, cpu));
                        lastIsNull = false;
                    } else {
                        if (lastEndTime != time && lastEndTime != -1L && lastIsNull) {
                            eventList.add(new ResourcesEvent(entry, lastEndTime, time - lastEndTime, -1));
                        }
                        if (includeNull) {
                            eventList.add(new ResourcesEvent(entry, time, duration));
                        }
                        lastIsNull = true;
                    }
                    lastEndTime = time + duration;
                }
            } else if (entry.getType().equals((Object)ResourcesEntry.Type.SOFT_IRQ)) {
                List softIrqIntervals = ssq.queryHistoryRange(quark, startTime, endTime - 1L, resolution);
                eventList = new ArrayList(softIrqIntervals.size());
                long lastEndTime = -1L;
                boolean lastIsNull = true;
                for (ITmfStateInterval softIrqInterval : softIrqIntervals) {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    long time = softIrqInterval.getStartTime();
                    long duration = softIrqInterval.getEndTime() - time + 1L;
                    if (!softIrqInterval.getStateValue().isNull()) {
                        int cpu = softIrqInterval.getStateValue().unboxInt();
                        eventList.add(new ResourcesEvent(entry, time, duration, cpu));
                    } else {
                        if (lastEndTime != time && lastEndTime != -1L && lastIsNull) {
                            eventList.add(new ResourcesEvent(entry, lastEndTime, time - lastEndTime, -1));
                        }
                        if (includeNull) {
                            eventList.add(new ResourcesEvent(entry, time, duration));
                        }
                        lastIsNull = true;
                    }
                    lastEndTime = time + duration;
                }
            }
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
        }
        catch (TimeRangeException e) {
            e.printStackTrace();
        }
        catch (StateValueTypeException e) {
            e.printStackTrace();
        }
        return eventList;
    }

    private void refresh(final long windowRange) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ResourcesView.this.fTimeGraphViewer.getControl().isDisposed()) {
                    return;
                }
                ITimeGraphEntry[] entries = ResourcesView.this.fEntryList.toArray(new ITimeGraphEntry[0]);
                Arrays.sort(entries, new TraceEntryComparator());
                ResourcesView.this.fTimeGraphViewer.setInput(entries);
                ResourcesView.this.fTimeGraphViewer.setTimeBounds(ResourcesView.this.fStartTime, ResourcesView.this.fEndTime);
                long endTime = ResourcesView.this.fStartTime + windowRange;
                if (ResourcesView.this.fEndTime < endTime) {
                    endTime = ResourcesView.this.fEndTime;
                }
                ResourcesView.this.fTimeGraphViewer.setStartFinishTime(ResourcesView.this.fStartTime, endTime);
                ResourcesView.this.startZoomThread(ResourcesView.this.fStartTime, endTime);
            }
        });
    }

    private void redraw() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ResourcesView.this.fTimeGraphViewer.getControl().isDisposed()) {
                    return;
                }
                ResourcesView.this.fTimeGraphViewer.getControl().redraw();
                ResourcesView.this.fTimeGraphViewer.getControl().update();
            }
        });
    }

    private void startZoomThread(long startTime, long endTime) {
        if (this.fZoomThread != null) {
            this.fZoomThread.cancel();
        }
        this.fZoomThread = new ZoomThread(startTime, endTime);
        this.fZoomThread.start();
    }

    private void makeActions() {
        this.fPreviousResourceAction = this.fTimeGraphViewer.getPreviousItemAction();
        this.fPreviousResourceAction.setText(Messages.ResourcesView_previousResourceActionNameText);
        this.fPreviousResourceAction.setToolTipText(Messages.ResourcesView_previousResourceActionToolTipText);
        this.fNextResourceAction = this.fTimeGraphViewer.getNextItemAction();
        this.fNextResourceAction.setText(Messages.ResourcesView_nextResourceActionNameText);
        this.fNextResourceAction.setToolTipText(Messages.ResourcesView_previousResourceActionToolTipText);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.fTimeGraphViewer.getShowLegendAction());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fTimeGraphViewer.getResetScaleAction());
        manager.add((IAction)this.fTimeGraphViewer.getPreviousEventAction());
        manager.add((IAction)this.fTimeGraphViewer.getNextEventAction());
        manager.add((IAction)this.fPreviousResourceAction);
        manager.add((IAction)this.fNextResourceAction);
        manager.add((IAction)this.fTimeGraphViewer.getZoomInAction());
        manager.add((IAction)this.fTimeGraphViewer.getZoomOutAction());
        manager.add((IContributionItem)new Separator());
    }

    private class TraceEntry
    implements ITimeGraphEntry {
        private CtfKernelTrace fTrace;
        private long fTraceStartTime;
        private long fTraceEndTime;
        private ArrayList<ResourcesEntry> fChildren;
        private String fName;

        public TraceEntry(CtfKernelTrace trace, String name, long startTime, long endTime) {
            this.fTrace = trace;
            this.fChildren = new ArrayList();
            this.fName = name;
            this.fTraceStartTime = startTime;
            this.fTraceEndTime = endTime;
        }

        public ITimeGraphEntry getParent() {
            return null;
        }

        public boolean hasChildren() {
            return this.fChildren != null && this.fChildren.size() > 0;
        }

        public ResourcesEntry[] getChildren() {
            return this.fChildren.toArray(new ResourcesEntry[0]);
        }

        public String getName() {
            return this.fName;
        }

        public long getStartTime() {
            return this.fTraceStartTime;
        }

        public long getEndTime() {
            return this.fTraceEndTime;
        }

        public boolean hasTimeEvents() {
            return false;
        }

        public Iterator<ITimeEvent> getTimeEventsIterator() {
            return null;
        }

        public <T extends ITimeEvent> Iterator<T> getTimeEventsIterator(long startTime, long stopTime, long visibleDuration) {
            return null;
        }

        public CtfKernelTrace getTrace() {
            return this.fTrace;
        }

        public void addChild(ResourcesEntry entry) {
            int index = 0;
            while (index < this.fChildren.size()) {
                ResourcesEntry other = this.fChildren.get(index);
                if (entry.getType().compareTo(other.getType()) < 0 || entry.getType().equals((Object)other.getType()) && entry.getId() < other.getId()) break;
                ++index;
            }
            entry.setParent(this);
            this.fChildren.add(index, entry);
        }
    }

    private static class TraceEntryComparator
    implements Comparator<ITimeGraphEntry> {
        private TraceEntryComparator() {
        }

        @Override
        public int compare(ITimeGraphEntry o1, ITimeGraphEntry o2) {
            int result;
            int n = o1.getStartTime() < o2.getStartTime() ? -1 : (result = o1.getStartTime() > o2.getStartTime() ? 1 : 0);
            if (result == 0) {
                result = o1.getName().compareTo(o2.getName());
            }
            return result;
        }
    }

    private class ZoomThread
    extends Thread {
        private long fZoomStartTime;
        private long fZoomEndTime;
        private IProgressMonitor fMonitor;

        public ZoomThread(long startTime, long endTime) {
            super("ResourcesView zoom");
            this.fZoomStartTime = startTime;
            this.fZoomEndTime = endTime;
            this.fMonitor = new NullProgressMonitor();
        }

        @Override
        public void run() {
            ArrayList entryList = ResourcesView.this.fEntryList;
            if (entryList == null) {
                return;
            }
            long resolution = Math.max(1L, (this.fZoomEndTime - this.fZoomStartTime) / (long)ResourcesView.this.fDisplayWidth);
            block0: for (TraceEntry traceEntry : entryList) {
                ResourcesEntry[] resourcesEntryArray = traceEntry.getChildren();
                int n = resourcesEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ResourcesEntry child = resourcesEntryArray[n2];
                    if (this.fMonitor.isCanceled()) continue block0;
                    ResourcesEntry entry = child;
                    if (this.fZoomStartTime <= ResourcesView.this.fStartTime && this.fZoomEndTime >= ResourcesView.this.fEndTime) {
                        entry.setZoomedEventList(null);
                    } else {
                        List zoomedEventList = ResourcesView.this.getEventList(entry, this.fZoomStartTime, this.fZoomEndTime, resolution, true, this.fMonitor);
                        if (zoomedEventList != null) {
                            entry.setZoomedEventList(zoomedEventList);
                        }
                    }
                    ++n2;
                }
            }
            ResourcesView.this.redraw();
        }

        public void cancel() {
            this.fMonitor.setCanceled(true);
        }
    }
}

