/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.model.TargetResource;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.service.ILttControllerService;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.service.LttControllerServiceProxy;
import org.eclipse.linuxtools.internal.lttng.ui.Activator;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.Messages;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.dialogs.ConfigureMarkersDialog;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.subsystems.TraceSubSystem;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.util.TCFTask;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class ConfigureMarkers
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate,
IViewActionDelegate {
    private List<TargetResource> fSelectedTargets = new ArrayList<TargetResource>();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    protected TargetResource getFirstSelectedTarget() {
        if (this.fSelectedTargets.size() > 0) {
            return this.fSelectedTargets.get(0);
        }
        return null;
    }

    protected ISubSystem getSubSystem() {
        return this.getFirstSelectedTarget().getSubSystem();
    }

    public void run(IAction arg0) {
        TargetResource tr;
        TraceSubSystem subSystem;
        Shell shell = this.getShell();
        ConfigureMarkersDialog dialog = new ConfigureMarkersDialog(shell, subSystem = (TraceSubSystem)(tr = this.fSelectedTargets.get(0)).getSubSystem());
        Map<String, Boolean> map = dialog.open(tr);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, Boolean> entry : map.entrySet()) {
            String key = entry.getKey();
            Boolean value = entry.getValue();
            try {
                LttControllerServiceProxy service = subSystem.getControllerService();
                Boolean cfr_ignored_0 = (Boolean)new TCFTask<Boolean>((ILttControllerService)service, tr, key, value){
                    private final /* synthetic */ ILttControllerService val$service;
                    private final /* synthetic */ TargetResource val$tr;
                    private final /* synthetic */ String val$key;
                    private final /* synthetic */ Boolean val$value;
                    {
                        this.val$service = iLttControllerService;
                        this.val$tr = targetResource;
                        this.val$key = string;
                        this.val$value = bl;
                    }

                    public void run() {
                        this.val$service.setMarkerEnable(this.val$tr.getParent().getName(), this.val$tr.getName(), this.val$key, Boolean.valueOf(this.val$value), new ILttControllerService.DoneSetMarkerEnable(){

                            public void doneSetMarkerEnable(IToken token, Exception error, Object str) {
                                if (error != null) {
                                    this.error(error);
                                    return;
                                }
                                this.done(true);
                            }
                        });
                    }
                }.get(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                SystemMessageException sysExp = e instanceof SystemMessageException ? (SystemMessageException)((Object)e) : new SystemMessageException(Activator.getDefault().getMessage(e));
                SystemBasePlugin.logError((String)(String.valueOf(Messages.Lttng_Control_ErrorConfigureMarkers) + " (" + Messages.Lttng_Resource_Target + ": " + tr.getName() + ")"), (Throwable)sysExp);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelectedTargets.clear();
            for (Object obj : (IStructuredSelection)selection) {
                if (!(obj instanceof TargetResource)) continue;
                this.fSelectedTargets.add((TargetResource)obj);
            }
        }
    }

    protected Shell getShell() {
        return SystemBasePlugin.getActiveWorkbenchShell();
    }

    public void init(IWorkbenchWindow window) {
    }

    public void dispose() {
    }

    public void init(IViewPart view) {
    }
}

