/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.ui.editor;

import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.linuxtools.internal.valgrind.ui.editor.ColorManager;
import org.eclipse.linuxtools.internal.valgrind.ui.editor.SuppressionsContentAssistProcessor;
import org.eclipse.linuxtools.internal.valgrind.ui.editor.SuppressionsEditor;
import org.eclipse.linuxtools.internal.valgrind.ui.editor.SuppressionsElementScanner;
import org.eclipse.linuxtools.internal.valgrind.ui.editor.SuppressionsPartitionScanner;
import org.eclipse.linuxtools.internal.valgrind.ui.editor.SuppressionsReconcilingStrategy;

public class SuppressionsConfiguration
extends SourceViewerConfiguration {
    private SuppressionsEditor editor;
    private SuppressionsElementScanner elementScanner;

    public SuppressionsConfiguration(ColorManager colorManager, SuppressionsEditor editor) {
        this.editor = editor;
        this.elementScanner = new SuppressionsElementScanner(colorManager);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return SuppressionsPartitionScanner.SUPP_CONTENT_TYPES;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.elementScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.elementScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__supp_tool");
        reconciler.setRepairer((IPresentationRepairer)dr, "__supp_tool");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.elementScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__supp_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__supp_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.elementScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__supp_context");
        reconciler.setRepairer((IPresentationRepairer)dr, "__supp_context");
        return reconciler;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        SuppressionsReconcilingStrategy strategy = new SuppressionsReconcilingStrategy(this.editor);
        MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setContentAssistProcessor((IContentAssistProcessor)new SuppressionsContentAssistProcessor(), "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)new SuppressionsContentAssistProcessor(), "__supp_tool");
        assistant.setContentAssistProcessor((IContentAssistProcessor)new SuppressionsContentAssistProcessor(), "__supp_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)new SuppressionsContentAssistProcessor(), "__supp_context");
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        assistant.enableAutoInsert(true);
        return assistant;
    }
}

