/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.model.TraceResource;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.Messages;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.dialogs.ImportTraceDialog;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class ImportToProject
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate,
IViewActionDelegate {
    public static final String TRACE_FOLDER_NAME = "Traces";
    private List<TraceResource> fSelectedTraces = new ArrayList<TraceResource>();

    public void setActivePart(IAction arg0, IWorkbenchPart arg1) {
    }

    protected TraceResource getFirstSelectedTrace() {
        if (this.fSelectedTraces.size() > 0) {
            return this.fSelectedTraces.get(0);
        }
        return null;
    }

    protected ISubSystem getSubSystem() {
        return this.getFirstSelectedTrace().getSubSystem();
    }

    public void run(IAction arg0) {
        int i = 0;
        while (i < this.fSelectedTraces.size()) {
            TraceResource trace = this.fSelectedTraces.get(i);
            ImportTraceDialog dialog = new ImportTraceDialog(this.getShell(), trace);
            int result = dialog.open();
            if (result == 0) {
                IProject project = dialog.getProject();
                String traceName = dialog.getTraceName();
                if (trace.getTraceConfig().isNetworkTrace()) {
                    if (dialog.getLinkOnly()) {
                        ImportToProject.linkTrace(this.getShell(), trace, project, traceName);
                    } else {
                        this.copyTrace(trace, project, traceName);
                    }
                } else {
                    this.downloadTrace(trace, project, traceName);
                }
            }
            ++i;
        }
    }

    private void downloadTrace(TraceResource trace, IProject project, String traceName) {
        try {
            IHost host = trace.getSubSystem().getHost();
            ISubSystem[] sss = RSECorePlugin.getTheSystemRegistry().getSubsystems(host, IFileServiceSubSystem.class);
            if (sss.length == 0 || !(sss[0] instanceof FileServiceSubSystem)) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.ImportToProject_ImportFailed, (String)Messages.ImportToProject_NoFileServiceSubsystem);
                return;
            }
            FileServiceSubSystem fsss = (FileServiceSubSystem)sss[0];
            IFolder traceFolder = project.getFolder(TRACE_FOLDER_NAME);
            if (!traceFolder.exists()) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.ImportToProject_ImportFailed, (String)Messages.ImportToProject_NoProjectTraceFolder);
                return;
            }
            IRemoteFile remoteFolder = fsss.getRemoteFileObject(trace.getTraceConfig().getTracePath(), (IProgressMonitor)new NullProgressMonitor());
            if (remoteFolder == null || !remoteFolder.exists()) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.ImportToProject_ImportFailed, (String)Messages.ImportToProject_NoRemoteTraceFolder);
                return;
            }
            IFolder folder = traceFolder.getFolder(traceName);
            if (folder.exists()) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.ImportToProject_ImportFailed, (String)Messages.ImportToProject_AlreadyExists);
                return;
            }
            folder.create(true, true, null);
            IRemoteFile[] sources = fsss.list(remoteFolder, 1, (IProgressMonitor)new NullProgressMonitor());
            String[] destinations = new String[sources.length];
            String[] encodings = new String[sources.length];
            int i = 0;
            while (i < sources.length) {
                destinations[i] = folder.getLocation().addTrailingSeparator().append(sources[i].getName()).toString();
                encodings[i] = null;
                ++i;
            }
            fsss.downloadMultiple(sources, destinations, encodings, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (SystemMessageException e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.ImportToProject_ImportFailed, (String)e.getMessage());
        }
        catch (CoreException e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.ImportToProject_ImportFailed, (String)e.getMessage());
        }
    }

    private void copyTrace(TraceResource trace, IProject project, String traceName) {
        IFolder traceFolder = project.getFolder(TRACE_FOLDER_NAME);
        if (!traceFolder.exists()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.ImportToProject_ImportFailed, (String)Messages.ImportToProject_NoProjectTraceFolder);
            return;
        }
        IPath containerPath = traceFolder.getFullPath().addTrailingSeparator().append(traceName);
        File sourceFolder = new File(trace.getTraceConfig().getTracePath());
        IOverwriteQuery overriteImplementor = new IOverwriteQuery(){

            public String queryOverwrite(String pathString) {
                MessageDialog.openWarning((Shell)ImportToProject.this.getShell(), (String)Messages.ImportToProject_ImportFailed, (String)Messages.ImportToProject_AlreadyExists);
                return "NOALL";
            }
        };
        ImportOperation operation = new ImportOperation(containerPath, (Object)sourceFolder, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, overriteImplementor);
        operation.setCreateContainerStructure(false);
        try {
            operation.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.ImportToProject_ImportFailed, (String)e.getMessage());
        }
        catch (InterruptedException e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.ImportToProject_ImportFailed, (String)e.getMessage());
        }
    }

    public static void linkTrace(Shell shell, TraceResource trace, IProject project, String traceName) {
        IFolder traceFolder = project.getFolder(TRACE_FOLDER_NAME);
        if (!traceFolder.exists()) {
            MessageDialog.openWarning((Shell)shell, (String)Messages.ImportToProject_ImportFailed, (String)Messages.ImportToProject_NoProjectTraceFolder);
            return;
        }
        IFolder folder = traceFolder.getFolder(traceName);
        if (folder.exists()) {
            MessageDialog.openWarning((Shell)shell, (String)Messages.ImportToProject_ImportFailed, (String)Messages.ImportToProject_AlreadyExists);
            return;
        }
        File sourceFolder = new File(trace.getTraceConfig().getTracePath());
        try {
            folder.createLink(sourceFolder.toURI(), 256, null);
            folder.setPersistentProperty(TmfCommonConstants.TRACEBUNDLE, "org.eclipse.linuxtools.lttng.ui");
            folder.setPersistentProperty(TmfCommonConstants.TRACETYPE, "org.eclipse.linuxtools.lttng.tracetype.kernel");
            folder.setPersistentProperty(TmfCommonConstants.TRACEICON, "icons/obj16/tux2.png");
        }
        catch (CoreException e) {
            MessageDialog.openWarning((Shell)shell, (String)Messages.ImportToProject_ImportFailed, (String)e.getMessage());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelectedTraces.clear();
            for (Object obj : (IStructuredSelection)selection) {
                if (!(obj instanceof TraceResource)) continue;
                this.fSelectedTraces.add((TraceResource)obj);
            }
        }
    }

    public void setSelectedTraces(List<TraceResource> traces) {
        this.fSelectedTraces = traces;
    }

    protected Shell getShell() {
        return SystemBasePlugin.getActiveWorkbenchShell();
    }

    public void init(IWorkbenchWindow window) {
    }

    public void dispose() {
    }

    public void init(IViewPart view) {
    }
}

