/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.project.dialogs;

import java.io.File;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.internal.lttng.ui.project.dialogs.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TraceLibraryPathWizardPage
extends WizardPage {
    private static final String LTTVTRACEREAD_LOADER_LIBNAME = "lttvtraceread_loader";
    private Button browsePathButton;
    private Text traceLibraryPath;

    protected TraceLibraryPathWizardPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite client = new Composite(parent, 0);
        client.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        client.setLayout((Layout)layout);
        Label label = new Label(client, 0);
        label.setText(Messages.TraceLibraryPath_label);
        this.traceLibraryPath = new Text(client, 2048);
        this.traceLibraryPath.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.traceLibraryPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean valid = TraceLibraryPathWizardPage.this.validatePage();
                TraceLibraryPathWizardPage.this.setPageComplete(valid);
            }
        });
        this.browsePathButton = new Button(client, 8);
        this.browsePathButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.browsePathButton.setText(Messages.TraceLibraryPath_browseBtn);
        this.browsePathButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String dir = new DirectoryDialog(Display.getDefault().getActiveShell()).open();
                if (dir != null) {
                    TraceLibraryPathWizardPage.this.traceLibraryPath.setText(dir);
                }
            }
        });
        Label noLabel = new Label(client, 0);
        noLabel.setLayoutData((Object)new GridData(131072, 128, false, false));
        Label descTextLabel = new Label(client, 64);
        descTextLabel.setText(Messages.TraceLibraryPathWizard_Message);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 400;
        gd.horizontalSpan = 2;
        descTextLabel.setLayoutData((Object)gd);
        Label noteBoldLabel = new Label(client, 1);
        noteBoldLabel.setText(Messages.TraceLibraryPath_Note);
        noteBoldLabel.setLayoutData((Object)new GridData(131072, 128, false, false));
        Font font = noteBoldLabel.getFont();
        if (font.getFontData().length > 0) {
            noteBoldLabel.setFont(new Font((Device)client.getDisplay(), font.getFontData()[0].getName(), font.getFontData()[0].getHeight(), 1));
        }
        Label noteTextLabel = new Label(client, 64);
        noteTextLabel.setText(Messages.TraceLibraryPath_Message);
        gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 400;
        gd.horizontalSpan = 2;
        noteTextLabel.setLayoutData((Object)gd);
        this.setControl((Control)client);
    }

    public String getPath() {
        String path;
        if (this.traceLibraryPath != null && !this.traceLibraryPath.isDisposed() && (path = this.traceLibraryPath.getText()) != null && !path.trim().isEmpty()) {
            return path;
        }
        return null;
    }

    private boolean validatePage() {
        String path = this.getPath();
        if (path != null) {
            File file = new File(path);
            if (file.exists() && file.isDirectory()) {
                File loaderLib = new File(path, System.mapLibraryName(LTTVTRACEREAD_LOADER_LIBNAME));
                if (!loaderLib.exists()) {
                    this.setErrorMessage(Messages.TraceLibraryPathWizardPage_TraceLoaderLibrary_notExists);
                    return false;
                }
            } else {
                this.setErrorMessage(Messages.TraceLibraryPathWizardPage_SpecifiedTraceLibraryLocation_notExists);
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }
}

