/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.core.state.trace;

import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.linuxtools.internal.lttng.core.Activator;
import org.eclipse.linuxtools.internal.lttng.core.TraceDebug;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngEvent;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngSyntheticEvent;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngTimestamp;
import org.eclipse.linuxtools.internal.lttng.core.model.LTTngTreeNode;
import org.eclipse.linuxtools.internal.lttng.core.request.ILttngSyntEventRequest;
import org.eclipse.linuxtools.internal.lttng.core.request.IRequestStatusListener;
import org.eclipse.linuxtools.internal.lttng.core.request.LttngSyntEventRequest;
import org.eclipse.linuxtools.internal.lttng.core.state.LttngStateException;
import org.eclipse.linuxtools.internal.lttng.core.state.evProcessor.ITransEventProcessor;
import org.eclipse.linuxtools.internal.lttng.core.state.evProcessor.state.StateEventToHandlerFactory;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngTraceState;
import org.eclipse.linuxtools.internal.lttng.core.state.model.StateModelFactory;
import org.eclipse.linuxtools.internal.lttng.core.state.resource.ILttngStateContext;
import org.eclipse.linuxtools.internal.lttng.core.state.trace.IStateTraceManager;
import org.eclipse.linuxtools.internal.lttng.core.trace.LTTngTextTrace;
import org.eclipse.linuxtools.internal.lttng.core.trace.LTTngTrace;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfCheckpoint;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.core.trace.TmfLocation;

public class StateTraceManager
extends LTTngTreeNode
implements IStateTraceManager,
ILttngStateContext {
    private static final long DEFAULT_OFFSET = 0L;
    private static final int DEFAULT_CHUNK = 1;
    private static final long LTTNG_CHECK_POINT_INTERVAL = 50000L;
    private long fcheckPointInterval = 50000L;
    private TmfExperiment<LttngEvent> fExperiment = null;
    private final ITmfTrace<?> fTrace;
    private int fcpuNumber = -1;
    private final ITransEventProcessor fStateUpdateProcessor;
    private final HashMap<Long, LttngTraceState> stateCheckpointsList = new HashMap();
    private final Vector<TmfCheckpoint> timestampCheckpointsList = new Vector();
    private LttngTraceState fStateModel;
    private LttngTraceState fCheckPointStateModel;
    private Object fCheckPointsLock = new Object();
    private Object fStateModelLock = new Object();

    public StateTraceManager(Long id, LTTngTreeNode parent, String name, ITmfTrace<?> trace) throws LttngStateException {
        super(id, parent, name, (Object)trace);
        if (trace == null) {
            throw new LttngStateException("No TmfTrace object available!");
        }
        this.fTrace = trace;
        this.fStateUpdateProcessor = StateEventToHandlerFactory.getInstance();
        this.init();
        this.fStateModel = StateModelFactory.getStateEntryInstance(this);
        this.fStateModel.init(this);
        this.fCheckPointStateModel = StateModelFactory.getStateEntryInstance(this);
        this.fCheckPointStateModel.init(this);
    }

    private void init() {
        Object obj = ((LTTngTreeNode)this.getParent()).getValue();
        if (obj != null && obj instanceof TmfExperiment) {
            this.fExperiment = (TmfExperiment)obj;
        }
        if (this.fTrace instanceof LTTngTrace) {
            this.fcpuNumber = ((LTTngTrace)this.fTrace).getCpuNumber();
        } else if (this.fTrace instanceof LTTngTextTrace) {
            this.fcpuNumber = ((LTTngTextTrace)this.fTrace).getCpuNumber();
        }
    }

    @Override
    public ITmfTrace<?> getStateTrace() {
        return this.fTrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCheckPointIfNeeded(Long eventCounter, ITmfTimestamp eventTime) {
        if (eventCounter % this.fcheckPointInterval == 0L) {
            LttngTraceState stateCheckPoint;
            Object object = this.fCheckPointsLock;
            synchronized (object) {
                stateCheckPoint = this.fCheckPointStateModel.clone();
            }
            TraceDebug.debug("Check point created here: " + eventCounter + " -> " + eventTime.toString() + "************" + this.getStateTrace().getName() + "   >>>>> Thread: " + Thread.currentThread().getId());
            object = this.fCheckPointsLock;
            synchronized (object) {
                this.stateCheckpointsList.put(eventCounter, stateCheckPoint);
                this.timestampCheckpointsList.add(new TmfCheckpoint((ITmfTimestamp)new TmfTimestamp(eventTime), (ITmfLocation)new TmfLocation((Comparable)eventCounter)));
            }
        }
    }

    public long getCheckPointInterval() {
        return this.fcheckPointInterval;
    }

    public void setCheckPointInterval(long check_point_interval) {
        this.fcheckPointInterval = check_point_interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TmfCheckpoint restoreCheckPointByTimestamp(ITmfTimestamp eventTime) {
        LttngTraceState traceState;
        TmfTimeRange experimentRange = this.fExperiment.getTimeRange();
        TmfCheckpoint checkpoint = new TmfCheckpoint(this.fTrace.getStartTime(), (ITmfLocation)new TmfLocation((Comparable)Long.valueOf(0L)));
        if (eventTime.getValue() < 0L || !experimentRange.equals((Object)TmfTimeRange.NULL_RANGE) && eventTime.getValue() > experimentRange.getEndTime().getValue()) {
            return null;
        }
        if (eventTime.getValue() < this.fTrace.getStartTime().getValue()) {
            eventTime = this.fTrace.getStartTime();
        }
        Object object = this.fCheckPointsLock;
        synchronized (object) {
            Collections.sort(this.timestampCheckpointsList);
            int index = Collections.binarySearch(this.timestampCheckpointsList, new TmfCheckpoint(eventTime, (ITmfLocation)new TmfLocation((Comparable)Long.valueOf(0L))));
            index = this.getPrevIndex(index);
            if (index == 0) {
                traceState = StateModelFactory.getStateEntryInstance(this);
            } else {
                checkpoint = this.timestampCheckpointsList.get(index);
                TmfLocation location = (TmfLocation)checkpoint.getLocation();
                traceState = this.stateCheckpointsList.get(location.getLocation()).clone();
            }
        }
        object = this.fStateModelLock;
        synchronized (object) {
            this.fStateModel = traceState;
        }
        return checkpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TmfCheckpoint restoreCheckPointByIndex(long eventIndex) {
        LttngTraceState traceState;
        TmfCheckpoint checkpoint = new TmfCheckpoint(this.fTrace.getStartTime(), (ITmfLocation)new TmfLocation((Comparable)Long.valueOf(0L)));
        Object object = this.fCheckPointsLock;
        synchronized (object) {
            Collections.sort(this.timestampCheckpointsList);
            int index = Collections.binarySearch(this.timestampCheckpointsList, new TmfCheckpoint(null, (ITmfLocation)new TmfLocation((Comparable)Long.valueOf(eventIndex))));
            index = this.getPrevIndex(index);
            if (index == 0) {
                traceState = StateModelFactory.getStateEntryInstance(this);
            } else {
                checkpoint = this.timestampCheckpointsList.get(index);
                TmfLocation location = (TmfLocation)checkpoint.getLocation();
                traceState = this.stateCheckpointsList.get(location.getLocation()).clone();
            }
        }
        object = this.fStateModelLock;
        synchronized (object) {
            this.fStateModel = traceState;
        }
        return checkpoint;
    }

    private int getPrevIndex(int position) {
        int roundDownPosition = position;
        if (position < 0) {
            roundDownPosition = -(position + 2);
        }
        roundDownPosition = roundDownPosition < 0 ? 0 : roundDownPosition;
        return roundDownPosition;
    }

    ILttngSyntEventRequest getDataRequestByTimeRange(TmfTimeRange timeWindow, IRequestStatusListener listener, ITransEventProcessor processor) {
        StateTraceManagerRequest request = new StateTraceManagerRequest(timeWindow, 0L, Integer.MAX_VALUE, 1, listener, this.getExperimentTimeWindow(), processor){};
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LttngTraceState getStateModel() {
        LttngTraceState stateModel = null;
        Object object = this.fStateModelLock;
        synchronized (object) {
            stateModel = this.fStateModel;
        }
        return stateModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LttngTraceState getCheckPointStateModel() {
        LttngTraceState checkPointStateModel = null;
        Object object = this.fCheckPointsLock;
        synchronized (object) {
            checkPointStateModel = this.fCheckPointStateModel;
        }
        return checkPointStateModel;
    }

    HashMap<Long, LttngTraceState> getStateCheckpointsList() {
        return this.stateCheckpointsList;
    }

    Vector<TmfCheckpoint> getTimestampCheckpointsList() {
        return this.timestampCheckpointsList;
    }

    @Override
    public int getNumberOfCpus() {
        return this.fcpuNumber;
    }

    @Override
    public TmfTimeRange getTraceTimeWindow() {
        if (this.fTrace != null) {
            return this.fTrace.getTimeRange();
        }
        return null;
    }

    @Override
    public String getTraceId() {
        if (this.fTrace != null) {
            return this.fTrace.getName();
        }
        return null;
    }

    @Override
    public TmfTimeRange getExperimentTimeWindow() {
        if (this.fExperiment != null) {
            return this.fExperiment.getTimeRange();
        }
        return null;
    }

    @Override
    public String getExperimentName() {
        return this.fExperiment.getName();
    }

    @Override
    public ITmfTrace<?> getTraceIdRef() {
        return this.fTrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCheckPoints() {
        Object object = this.fCheckPointsLock;
        synchronized (object) {
            this.stateCheckpointsList.clear();
            this.timestampCheckpointsList.clear();
            this.fCheckPointStateModel = StateModelFactory.getStateEntryInstance(this);
            try {
                this.fCheckPointStateModel.init(this);
            }
            catch (LttngStateException e) {
                Activator.getDefault().logError("Unexpected Error", e);
            }
        }
    }

    @Override
    public void handleEvent(LttngSyntheticEvent synEvent, Long eventCount) {
        this.fStateUpdateProcessor.process(synEvent, this.fCheckPointStateModel);
        this.saveCheckPointIfNeeded(eventCount - 1L, synEvent.getTimestamp());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\n\tTotal number of processes in the Shared State model: " + this.fStateModel.getProcesses().length + "\n\t" + "Total number of processes in the Check point State model: " + this.fCheckPointStateModel.getProcesses().length);
        TmfTimeRange traceTRange = this.fTrace.getTimeRange();
        sb.append("\n\tTrace time interval for trace " + this.fTrace.getName() + "\n\t" + (Object)((Object)new LttngTimestamp(traceTRange.getStartTime())));
        sb.append(" - " + (Object)((Object)new LttngTimestamp(traceTRange.getEndTime())));
        sb.append("\n\tCheckPoints available at: ");
        for (TmfCheckpoint cpoint : this.timestampCheckpointsList) {
            sb.append("\n\tLocation: " + cpoint.getLocation() + " - " + cpoint.getTimestamp());
        }
        return sb.toString();
    }

    @Override
    public long getIdentifier() {
        return this.getId();
    }

    class StateTraceManagerRequest
    extends LttngSyntEventRequest {
        final TmfEvent[] evt;
        final ITransEventProcessor fprocessor;
        LttngSyntheticEvent synEvent;
        Long fCount;

        public StateTraceManagerRequest(TmfTimeRange range, long offset, int nbEvents, int maxBlockSize, IRequestStatusListener listener, TmfTimeRange experimentTimeRange, ITransEventProcessor processor) {
            super(range, offset, nbEvents, maxBlockSize, listener, experimentTimeRange, processor);
            this.evt = new TmfEvent[1];
            this.fCount = this.getSynEventCount();
            this.fprocessor = processor;
            TraceDebug.debug("Instance created for range: " + range.toString());
            this.fCount = 0L;
        }

        @Override
        public void handleData(LttngSyntheticEvent event) {
            super.handleData(event);
            if (event != null) {
                this.synEvent = event;
                if (this.synEvent.getSynType() == LttngSyntheticEvent.SequenceInd.AFTER) {
                    this.saveCheckPoint(this.fCount, this.synEvent.getTimestamp());
                    this.fCount = this.fCount + 1L;
                    if (TraceDebug.isDEBUG() && this.fCount % 1000L == 0L) {
                        TraceDebug.debug("handled: " + this.fCount + " sequence: " + (Object)((Object)this.synEvent.getSynType()));
                    }
                }
            }
        }

        public void saveCheckPoint(Long count, ITmfTimestamp time) {
        }
    }
}

