/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.statesystem.backend.historytree;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.linuxtools.tmf.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.core.statesystem.backend.historytree.HTNode;
import org.eclipse.linuxtools.tmf.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.tmf.core.statevalue.TmfStateValue;

final class HTInterval
implements ITmfStateInterval,
Comparable<HTInterval> {
    private final long start;
    private final long end;
    private final int attribute;
    private final TmfStateValue sv;
    private final int stringsEntrySize;

    HTInterval(long intervalStart, long intervalEnd, int attribute, TmfStateValue value) throws TimeRangeException {
        if (intervalStart > intervalEnd) {
            throw new TimeRangeException();
        }
        this.start = intervalStart;
        this.end = intervalEnd;
        this.attribute = attribute;
        this.sv = value;
        this.stringsEntrySize = this.computeStringsEntrySize();
    }

    static final HTInterval readFrom(ByteBuffer buffer) throws IOException {
        HTInterval interval;
        TmfStateValue value;
        long intervalStart = buffer.getLong();
        long intervalEnd = buffer.getLong();
        int attribute = buffer.getInt();
        byte valueType = buffer.get();
        if (valueType <= 0) {
            int valueOrOffset = buffer.getInt();
            value = valueOrOffset == -1 ? TmfStateValue.nullValue() : TmfStateValue.newValueInt(valueOrOffset);
        } else {
            int valueOrOffset = buffer.getInt();
            buffer.mark();
            buffer.position(valueOrOffset);
            byte valueSize = buffer.get();
            byte[] array = new byte[valueSize - 2];
            buffer.get(array);
            value = TmfStateValue.newValueString(new String(array));
            byte res = buffer.get();
            if (res != 0) {
                throw new IOException("Invalid interval data. Maybe your file is corrupt?");
            }
            buffer.reset();
        }
        try {
            interval = new HTInterval(intervalStart, intervalEnd, attribute, value);
        }
        catch (TimeRangeException timeRangeException) {
            throw new IOException("Invalid interval data. Maybe your file is corrupt?");
        }
        return interval;
    }

    int writeInterval(ByteBuffer buffer, int endPosOfStringEntry) {
        buffer.putLong(this.start);
        buffer.putLong(this.end);
        buffer.putInt(this.attribute);
        buffer.put(this.sv.getType());
        byte[] byteArrayToWrite = this.sv.toByteArray();
        if (byteArrayToWrite == null) {
            if (this.sv.isNull()) {
                buffer.putInt(0);
            } else {
                try {
                    buffer.putInt(this.sv.unboxInt());
                }
                catch (StateValueTypeException e) {
                    e.printStackTrace();
                }
            }
            return 0;
        }
        int sizeOfStringEntry = byteArrayToWrite.length + 2;
        buffer.putInt(endPosOfStringEntry - sizeOfStringEntry);
        buffer.mark();
        buffer.position(endPosOfStringEntry - sizeOfStringEntry);
        buffer.put((byte)sizeOfStringEntry);
        buffer.put(byteArrayToWrite);
        buffer.put((byte)0);
        assert (buffer.position() == endPosOfStringEntry);
        buffer.reset();
        return sizeOfStringEntry;
    }

    @Override
    public long getStartTime() {
        return this.start;
    }

    @Override
    public long getEndTime() {
        return this.end;
    }

    @Override
    public long getViewerEndTime() {
        return this.end + 1L;
    }

    @Override
    public int getAttribute() {
        return this.attribute;
    }

    @Override
    public ITmfStateValue getStateValue() {
        return this.sv;
    }

    @Override
    public boolean intersects(long timestamp) {
        return this.start <= timestamp && this.end >= timestamp;
    }

    int getStringsEntrySize() {
        return this.stringsEntrySize;
    }

    int getIntervalSize() {
        return this.stringsEntrySize + HTNode.getDataEntrySize();
    }

    private int computeStringsEntrySize() {
        if (this.sv.toByteArray() == null) {
            return 0;
        }
        return this.sv.toByteArray().length + 2;
    }

    @Override
    public int compareTo(HTInterval other) {
        if (this.end < other.end) {
            return -1;
        }
        if (this.end > other.end) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object other) {
        return other instanceof HTInterval && this.compareTo((HTInterval)other) == 0;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return String.valueOf(91L + this.start) + ", " + this.end + ']' + ", attribute = " + this.attribute + ", value = " + this.sv.toString();
    }
}

