/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.statesystem.backend.historytree;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.eclipse.linuxtools.tmf.core.statesystem.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.statesystem.backend.historytree.HTInterval;
import org.eclipse.linuxtools.tmf.core.statesystem.backend.historytree.HistoryTreeBackend;
import org.eclipse.linuxtools.tmf.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.tmf.core.statevalue.TmfStateValue;

public class ThreadedHistoryTreeBackend
extends HistoryTreeBackend
implements Runnable {
    private BlockingQueue<HTInterval> intervalQueue;
    private final Thread shtThread;

    public ThreadedHistoryTreeBackend(File newStateFile, int blockSize, int maxChildren, long startTime, int queueSize) throws IOException {
        super(newStateFile, blockSize, maxChildren, startTime);
        this.intervalQueue = new ArrayBlockingQueue<HTInterval>(queueSize);
        this.shtThread = new Thread((Runnable)this, "History Tree Thread");
        this.shtThread.start();
    }

    public ThreadedHistoryTreeBackend(File newStateFile, long startTime, int queueSize) throws IOException {
        super(newStateFile, startTime);
        this.intervalQueue = new ArrayBlockingQueue<HTInterval>(queueSize);
        this.shtThread = new Thread((Runnable)this, "History Tree Thread");
        this.shtThread.start();
    }

    @Override
    public void insertPastState(long stateStartTime, long stateEndTime, int quark, ITmfStateValue value) throws TimeRangeException {
        HTInterval interval = new HTInterval(stateStartTime, stateEndTime, quark, (TmfStateValue)value);
        try {
            this.intervalQueue.put(interval);
        }
        catch (InterruptedException e) {
            System.out.println("State system got interrupted!");
            e.printStackTrace();
        }
    }

    @Override
    public void finishedBuilding(long endTime) throws TimeRangeException {
        try {
            this.intervalQueue.put(new HTInterval(-1L, endTime, -1, TmfStateValue.nullValue()));
            this.shtThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        if (this.intervalQueue == null) {
            System.err.println("Cannot start the storage backend without its interval queue.");
            return;
        }
        try {
            HTInterval currentInterval = this.intervalQueue.take();
            while (currentInterval.getStartTime() != -1L) {
                this.sht.insertInterval(currentInterval);
                currentInterval = this.intervalQueue.take();
            }
            assert (currentInterval.getAttribute() == -1);
            this.sht.closeTree();
            return;
        }
        catch (InterruptedException e) {
            System.out.println("State History Tree interrupted!");
            e.printStackTrace();
        }
        catch (TimeRangeException e) {
            e.printStackTrace();
        }
    }
}

