/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.wizards;

import java.util.concurrent.TimeUnit;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.model.TraceResource;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.model.config.TraceChannel;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.model.config.TraceChannels;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.model.config.TraceConfig;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.service.ILttControllerService;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.service.LttControllerServiceProxy;
import org.eclipse.linuxtools.internal.lttng.ui.Activator;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.subsystems.TraceSubSystem;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.wizards.ITraceChannelConfigurationPage;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.wizards.KernelTraceChannelConfigurationPage;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.wizards.TraceConfigurationPage;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.wizards.UstTraceChannelConfigurationPage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.util.TCFTask;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ConfigureTraceWizard
extends Wizard
implements INewWizard {
    ITraceChannelConfigurationPage channelConfigPage;
    TraceConfigurationPage traceConfigPage;
    private TraceResource fSelectedTrace = null;

    public boolean performFinish() {
        return true;
    }

    public void addPages() {
        this.traceConfigPage = new TraceConfigurationPage(this);
        this.addPage((IWizardPage)this.traceConfigPage);
        if (this.fSelectedTrace.isUst()) {
            TraceChannels channels = null;
            if (this.fSelectedTrace.getTraceConfig() != null && this.fSelectedTrace.getTraceConfig().getTraceChannels() != null) {
                channels = this.fSelectedTrace.getTraceConfig().getTraceChannels().clone();
            } else {
                channels = new TraceChannels();
                channels.put("AUTO", new TraceChannel("AUTO"));
            }
            this.channelConfigPage = new UstTraceChannelConfigurationPage(channels);
            this.addPage(this.channelConfigPage);
        } else {
            TraceChannels channels = null;
            if (this.fSelectedTrace.getTraceConfig() != null && this.fSelectedTrace.getTraceConfig().getTraceChannels() != null) {
                channels = this.fSelectedTrace.getTraceConfig().getTraceChannels().clone();
            } else {
                String[] channelNames = new String[]{};
                try {
                    LttControllerServiceProxy service = ((TraceSubSystem)this.fSelectedTrace.getSubSystem()).getControllerService();
                    channelNames = (String[])new TCFTask<String[]>((ILttControllerService)service){
                        private final /* synthetic */ ILttControllerService val$service;
                        {
                            this.val$service = iLttControllerService;
                        }

                        public void run() {
                            this.val$service.getChannels(ConfigureTraceWizard.this.fSelectedTrace.getParent().getParent().getName(), ConfigureTraceWizard.this.fSelectedTrace.getParent().getName(), ConfigureTraceWizard.this.fSelectedTrace.getName(), new ILttControllerService.DoneGetChannels(){

                                public void doneGetChannels(IToken token, Exception error, String[] str) {
                                    if (error != null) {
                                        this.error(error);
                                        return;
                                    }
                                    this.done(str);
                                }
                            });
                        }
                    }.get(10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    if (e instanceof SystemMessageException) {
                        SystemBasePlugin.logError((String)"Trace Configuration", (Throwable)e);
                    }
                    SystemBasePlugin.logError((String)"TraceSubSystem", (Throwable)new SystemMessageException(Activator.getDefault().getMessage(e)));
                }
                channels = new TraceChannels();
                channels.putAll(channelNames);
            }
            this.channelConfigPage = new KernelTraceChannelConfigurationPage(channels, this.fSelectedTrace.getTraceState());
            this.addPage(this.channelConfigPage);
        }
        this.getShell().setImage(Activator.getDefault().getImage("ICON_ID_CONFIG_TRACE"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fSelectedTrace = null;
        for (Object obj : selection) {
            if (!(obj instanceof TraceResource)) continue;
            this.fSelectedTrace = (TraceResource)obj;
            break;
        }
    }

    public TraceResource getSelectedTrace() {
        return this.fSelectedTrace;
    }

    public TraceConfig getTraceConfig() {
        TraceConfig config = this.traceConfigPage.getTraceConfig();
        config.setTraceChannels(this.channelConfigPage.getTraceChannels());
        return config;
    }
}

