/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.core.trace;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngEvent;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngEventField;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngEventType;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngTimestamp;
import org.eclipse.linuxtools.internal.lttng.core.trace.TextLttngEvent;
import org.eclipse.linuxtools.internal.lttng.core.trace.TextLttngEventContent;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.TmfCheckpoint;
import org.eclipse.linuxtools.tmf.core.trace.TmfContext;
import org.eclipse.linuxtools.tmf.core.trace.TmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.TmfTrace;

public class LTTngTextTrace
extends TmfTrace<LttngEvent> {
    private LttngTimestamp eventTimestamp = null;
    private String eventSource = null;
    private LttngEventType eventType = null;
    private TextLttngEventContent eventContent = null;
    private String eventReference = null;
    private TextLttngEvent currentLttngEvent = null;
    private HashMap<String, LttngEventType> traceTypes = null;
    private String tracepath = "";
    private FileReader fr = null;
    private BufferedReader br = null;
    private Long nbCharRead = 0L;
    private int cpuNumber = -1;
    private boolean showDebug = false;

    public LTTngTextTrace(String name, String path) throws Exception {
        this(name, path, true);
    }

    public LTTngTextTrace(String name, String path, boolean skipIndexing) throws Exception {
        super(name, LttngEvent.class, path, 1, !skipIndexing);
        this.tracepath = path;
        this.traceTypes = new HashMap();
        this.eventTimestamp = new LttngTimestamp();
        this.eventSource = "Kernel Core";
        this.eventType = new LttngEventType();
        this.eventContent = new TextLttngEventContent(this.currentLttngEvent);
        this.eventReference = this.getName();
        this.currentLttngEvent = new TextLttngEvent(this, this.eventTimestamp, this.eventSource, this.eventType, this.eventContent, this.eventReference);
        this.eventContent.setEvent(this.currentLttngEvent);
        if (!this.positionToFirstEvent()) {
            throw new IOException("Fail to position to the beginning of the trace");
        }
        this.fIndexPageSize = 1000;
        this.fCheckpoints.add(new TmfCheckpoint((ITmfTimestamp)new LttngTimestamp(0L), (ITmfLocation)new TmfLocation((Comparable)Long.valueOf(0L))));
        Long endTime = this.currentLttngEvent.getTimestamp().getValue();
        this.positionToFirstEvent();
        this.getNextEvent((ITmfContext)new TmfContext(null, 0L));
        Long starTime = this.currentLttngEvent.getTimestamp().getValue();
        this.positionToFirstEvent();
        this.setTimeRange(new TmfTimeRange((ITmfTimestamp)new LttngTimestamp(starTime), (ITmfTimestamp)new LttngTimestamp(endTime)));
    }

    public LTTngTextTrace(LTTngTextTrace oldTrace) throws Exception {
        this(oldTrace.getName(), oldTrace.getPath(), true);
        this.fCheckpoints = oldTrace.fCheckpoints;
    }

    public LTTngTextTrace copy() {
        LTTngTextTrace returnedTrace = null;
        try {
            returnedTrace = new LTTngTextTrace(this);
        }
        catch (Exception e) {
            System.out.println("ERROR : Could not create LTTngTextTrace copy (createTraceCopy)");
            e.printStackTrace();
        }
        return returnedTrace;
    }

    private boolean positionToFirstEvent() {
        boolean isSuccessful = true;
        try {
            if (this.br != null) {
                this.br.close();
                this.fr.close();
            }
            this.fr = new FileReader(this.tracepath);
            this.br = new BufferedReader(this.fr);
            this.br.readLine();
            this.br.readLine();
            this.eventTimestamp.setValue(0L);
        }
        catch (IOException iOException) {
            isSuccessful = false;
        }
        return isSuccessful;
    }

    private void skipToPosition(TmfLocation<Long> skip) {
        try {
            long skipPosition = (Long)skip.getLocation();
            if (skipPosition < 0L) {
                skipPosition = 0L;
            }
            if (this.showDebug) {
                System.out.println("skipToPosition(Long skipPosition)");
                System.out.println("\tSkipping to : " + skipPosition);
                System.out.println();
            }
            this.positionToFirstEvent();
            long nbSkipped = this.br.skip(skipPosition);
            if (nbSkipped != skipPosition) {
                throw new IOException("Too few characters skipped, positionning failed! (skipToPosition)");
            }
            this.nbCharRead = skipPosition;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TmfContext seekLocation(ITmfLocation<?> location) {
        if (location == null) {
            location = new TmfLocation((Comparable)Long.valueOf(0L));
        }
        if (!((Long)((TmfLocation)location).getLocation()).equals(this.nbCharRead)) {
            this.skipToPosition((TmfLocation<Long>)location);
        }
        TmfContext tmpTraceContext = new TmfContext((ITmfLocation)location, 0L);
        return tmpTraceContext;
    }

    public TmfContext seekLocation(double ratio) {
        return null;
    }

    public double getLocationRatio(ITmfLocation<?> location) {
        return 0.0;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private LttngEvent parseMyNextEvent(ITmfContext context) {
        TextLttngEvent returnedEvent;
        block16: {
            String tmpContent = null;
            int tmpCurIndex = 0;
            int tmpPrevIndex = 0;
            String tracefile = "";
            long tmpCpu = 0L;
            String marker = "";
            long tmpSecond = 0L;
            long tmpNanosecond = 0L;
            String parsedPayload = "";
            String markerName = "";
            Object payload = "";
            HashMap<String, LttngEventField> fieldsMap = null;
            returnedEvent = null;
            try {
                tmpContent = this.br.readLine();
                if (tmpContent != null) {
                    int tmpIndex;
                    String traceName;
                    this.nbCharRead = this.nbCharRead + (long)(tmpContent.length() + 1);
                    if (this.currentLttngEvent != null && this.currentLttngEvent.getContent().getMapContent() != null) {
                        this.currentLttngEvent.getContent().emptyContent();
                    }
                    if ((tmpCurIndex = tmpContent.indexOf(".", tmpPrevIndex)) < 0) {
                        if (this.showDebug) {
                            System.out.println("END OF FILE.");
                            System.out.println();
                        }
                        return null;
                    }
                    tracefile = tmpContent.substring(tmpPrevIndex, tmpCurIndex).trim();
                    tmpPrevIndex = tmpCurIndex;
                    tmpCurIndex = tmpContent.indexOf(":", tmpPrevIndex);
                    marker = tmpContent.substring(tmpPrevIndex + 1, tmpCurIndex).trim();
                    tmpPrevIndex = tmpCurIndex + 1;
                    tmpCurIndex = tmpContent.indexOf(".", tmpPrevIndex);
                    tmpSecond = Long.parseLong(tmpContent.substring(tmpPrevIndex, tmpCurIndex).trim());
                    tmpPrevIndex = tmpCurIndex + 1;
                    tmpCurIndex = tmpContent.indexOf(" ", tmpPrevIndex);
                    tmpNanosecond = Long.parseLong(tmpContent.substring(tmpPrevIndex, tmpCurIndex).trim());
                    this.eventTimestamp.setValue(tmpSecond * 1000000000L + tmpNanosecond);
                    tmpPrevIndex = tmpCurIndex + 1;
                    tmpCurIndex = tmpContent.indexOf("(", tmpPrevIndex);
                    tmpPrevIndex = tmpCurIndex + 1;
                    tmpCurIndex = tmpContent.indexOf("),", tmpPrevIndex);
                    String fullTracePath = tmpContent.substring(tmpPrevIndex, tmpCurIndex).trim();
                    this.eventReference = traceName = fullTracePath.substring(fullTracePath.lastIndexOf("/") + 1).trim();
                    this.currentLttngEvent.setReference(traceName);
                    tmpPrevIndex = tmpCurIndex + 1;
                    tmpCurIndex = tmpContent.indexOf(",", tmpPrevIndex);
                    tmpPrevIndex = tmpCurIndex + 1;
                    tmpCurIndex = tmpContent.indexOf(",", tmpPrevIndex);
                    tmpPrevIndex = tmpCurIndex + 1;
                    tmpCurIndex = tmpContent.indexOf(",", tmpPrevIndex);
                    tmpPrevIndex = tmpCurIndex + 1;
                    tmpCurIndex = tmpContent.indexOf(",", tmpPrevIndex);
                    tmpPrevIndex = tmpCurIndex + 1;
                    tmpCurIndex = tmpContent.indexOf(",", tmpPrevIndex);
                    tmpPrevIndex = tmpCurIndex + 1;
                    tmpCurIndex = tmpContent.indexOf(",", tmpPrevIndex);
                    tmpPrevIndex = tmpCurIndex + 1;
                    tmpCurIndex = tmpContent.indexOf("0x", tmpPrevIndex);
                    tmpPrevIndex = tmpCurIndex + 2;
                    tmpCurIndex = tmpContent.indexOf(",", tmpPrevIndex);
                    tmpCpu = Long.parseLong(tmpContent.substring(tmpPrevIndex, tmpCurIndex).trim());
                    if ((long)this.cpuNumber < tmpCpu + 1L) {
                        this.cpuNumber = (int)(tmpCpu + 1L);
                    }
                    if ((tmpIndex = tmpContent.indexOf("{", tmpPrevIndex)) != -1) {
                        tmpPrevIndex = tmpCurIndex + 1;
                        tmpCurIndex = tmpIndex;
                        tmpPrevIndex = tmpCurIndex + 1;
                        tmpCurIndex = tmpContent.indexOf("}", tmpPrevIndex);
                        parsedPayload = tmpContent.substring(tmpPrevIndex, tmpCurIndex).trim();
                        boolean isDone = false;
                        int tmpIndexBegin = 0;
                        int tmpIndexEqual = 0;
                        int tmpIndexEnd = 0;
                        fieldsMap = new HashMap();
                        while (!isDone) {
                            tmpIndexEqual = parsedPayload.indexOf("=", tmpIndexBegin);
                            tmpIndexEnd = parsedPayload.indexOf(", ", tmpIndexEqual);
                            if (tmpIndexEnd == -1) {
                                tmpIndexEnd = parsedPayload.length();
                                isDone = true;
                            }
                            markerName = parsedPayload.substring(tmpIndexBegin, tmpIndexEqual - 1).trim();
                            payload = parsedPayload.substring(tmpIndexEqual + 1, tmpIndexEnd).replace("\"", " ").trim();
                            try {
                                payload = Long.parseLong((String)payload);
                            }
                            catch (NumberFormatException numberFormatException) {}
                            LttngEventField tmpField = new LttngEventField(markerName, payload);
                            fieldsMap.put(markerName, tmpField);
                            tmpIndexBegin = tmpIndexEnd + 1;
                        }
                    } else {
                        fieldsMap = new HashMap<String, LttngEventField>();
                        markerName = "";
                        payload = "";
                        LttngEventField tmpField = new LttngEventField(markerName, payload);
                        fieldsMap.put(markerName, tmpField);
                    }
                    this.eventContent = new TextLttngEventContent(this.currentLttngEvent, fieldsMap);
                    String tmpTypeKey = String.valueOf(tracefile) + "/" + tmpCpu + "/" + marker;
                    if (this.traceTypes.get(tmpTypeKey) == null) {
                        this.traceTypes.put(tmpTypeKey, new LttngEventType(tracefile, tmpCpu, marker, 0, fieldsMap.keySet().toArray(new String[fieldsMap.size()])));
                    }
                    this.currentLttngEvent.setContent(this.eventContent);
                    this.currentLttngEvent.setType(this.traceTypes.get(tmpTypeKey));
                    returnedEvent = this.currentLttngEvent;
                    break block16;
                }
                if (this.showDebug) {
                    System.out.println("NULL READING");
                    System.out.println();
                    returnedEvent = null;
                }
            }
            catch (Exception e) {
                System.out.println("Pos is :" + this.nbCharRead);
                if (tmpContent != null) {
                    System.out.println("Erroneous content is :" + tmpContent);
                }
                tmpContent = null;
                e.printStackTrace();
                returnedEvent = null;
            }
        }
        return returnedEvent;
    }

    public ITmfLocation<?> getCurrentLocation() {
        return new TmfLocation((Comparable)this.nbCharRead);
    }

    public LttngEvent parseEvent(ITmfContext context) {
        context = this.seekLocation((ITmfLocation<?>)context.getLocation());
        return this.parseMyNextEvent(context);
    }

    public int getCpuNumber() {
        return this.cpuNumber;
    }
}

