/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.core.state.experiment;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.linuxtools.internal.lttng.core.TraceDebug;
import org.eclipse.linuxtools.internal.lttng.core.control.LttngCoreProviderFactory;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngEvent;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngSyntheticEvent;
import org.eclipse.linuxtools.internal.lttng.core.model.LTTngTreeNode;
import org.eclipse.linuxtools.internal.lttng.core.signal.ILttExperimentSelectedListener;
import org.eclipse.linuxtools.internal.lttng.core.signal.StateExperimentListener;
import org.eclipse.linuxtools.internal.lttng.core.state.experiment.IStateExperimentManager;
import org.eclipse.linuxtools.internal.lttng.core.state.experiment.StateManagerFactory;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngTraceState;
import org.eclipse.linuxtools.internal.lttng.core.state.trace.IStateTraceManager;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.experiment.TmfExperiment;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentRangeUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public class StateExperimentManager
extends LTTngTreeNode
implements ILttExperimentSelectedListener,
IStateExperimentManager {
    private LTTngTreeNode fSelectedExperiment = null;
    private final StateExperimentListener fexperimentListener;
    private boolean fwaitForCompletion = false;
    private final Map<ITmfTrace<?>, StateTraceHelper> ftraceToManagerMap = new HashMap();
    private LttngSyntheticEvent syntheticEvent = null;
    private ITmfDataRequest<LttngEvent> fStateCheckPointRequest = null;
    private boolean fCheckPointUpdateBusy = false;
    private boolean fCheckPointUpdatePending = false;
    private int fCheckPointUpdateIndex = 0;
    private TmfTimeRange fCheckPointUpdateRange = null;
    private long fCheckPointNbEventsHandled = 0L;
    private final Object fCheckPointUpdateSyncObj = new Object();
    private boolean fInitial = false;

    public StateExperimentManager(Long id, String name) {
        super(id, null, name, null);
        this.fexperimentListener = new StateExperimentListener("Experiment Manager", this);
        TmfSignalManager.registerVIP((Object)this);
    }

    @TmfSignalHandler
    public void experimentSelected(TmfExperimentSelectedSignal signal) {
        this.experimentSelected_prep((TmfExperiment<LttngEvent>)signal.getExperiment());
    }

    @Override
    public void experimentSelected_prep(TmfExperiment<LttngEvent> experiment) {
        if (this.fSelectedExperiment != null) {
            this.clearExperimentNode(this.fSelectedExperiment);
            this.fSelectedExperiment = null;
        }
        LTTngTreeNode experimentNode = null;
        if (experiment != null) {
            ITmfTrace[] rtraces;
            experimentNode = (LTTngTreeNode)this.getChildByName(experiment.getName());
            if (experimentNode != null && experimentNode.getValue() != experiment) {
                this.clearExperimentNode(experimentNode);
                experimentNode = null;
            }
            if (experimentNode == null) {
                experimentNode = new LTTngTreeNode(this.getNextUniqueId(), this, experiment.getName(), (Object)experiment);
                this.addChild(experimentNode);
            }
            ITmfTrace[] iTmfTraceArray = rtraces = experiment.getTraces();
            int n = rtraces.length;
            int n2 = 0;
            while (n2 < n) {
                ITmfTrace rtrace = iTmfTraceArray[n2];
                String traceName = rtrace.getName();
                LTTngTreeNode traceStateManagerNode = (LTTngTreeNode)experimentNode.getChildByName(traceName);
                if (traceStateManagerNode == null) {
                    traceStateManagerNode = StateManagerFactory.getManager(rtrace, experimentNode);
                    experimentNode.addChild(traceStateManagerNode);
                }
                ++n2;
            }
            LttngCoreProviderFactory.reset(experimentNode);
            this.fSelectedExperiment = experimentNode;
        }
    }

    private void clearExperimentNode(LTTngTreeNode experimentNode) {
        LTTngTreeNode[] traceNodes;
        LTTngTreeNode[] lTTngTreeNodeArray = traceNodes = experimentNode.getChildren();
        int n = traceNodes.length;
        int n2 = 0;
        while (n2 < n) {
            LTTngTreeNode traceStateManagerNode = lTTngTreeNodeArray[n2];
            IStateTraceManager traceManager = null;
            try {
                traceManager = (IStateTraceManager)((Object)traceStateManagerNode);
                traceManager.clearCheckPoints();
                experimentNode.removeChild(traceStateManagerNode);
            }
            catch (ClassCastException classCastException) {}
            this.removeChild(experimentNode);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void experimentSelected(Object source, TmfExperiment<LttngEvent> experiment) {
        if (experiment == null) {
            TraceDebug.debug("Received experiment is null");
            return;
        }
        if (this.fStateCheckPointRequest != null && !this.fStateCheckPointRequest.isCompleted()) {
            this.fStateCheckPointRequest.cancel();
        }
        Object object = this.fCheckPointUpdateSyncObj;
        synchronized (object) {
            this.fCheckPointUpdateBusy = false;
            this.fCheckPointUpdatePending = false;
            this.fCheckPointUpdateIndex = 0;
        }
        this.fInitial = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void experimentRangeUpdated(TmfExperimentRangeUpdatedSignal signal) {
        TmfExperiment experiment = signal.getExperiment();
        if (this.fSelectedExperiment == null || experiment != this.fSelectedExperiment.getValue()) {
            return;
        }
        Object object = this.fCheckPointUpdateSyncObj;
        synchronized (object) {
            if (this.fCheckPointUpdateBusy) {
                this.fCheckPointUpdatePending = true;
                this.fCheckPointUpdateRange = signal.getRange();
                return;
            }
            this.fCheckPointUpdateBusy = true;
        }
        if (this.fStateCheckPointRequest != null && !this.fStateCheckPointRequest.isCompleted()) {
            this.fStateCheckPointRequest.cancel();
        }
        this.fStateCheckPointRequest = this.buildCheckPoints((TmfExperiment<LttngEvent>)experiment, signal.getRange(), this.fInitial);
        this.fInitial = false;
        if (this.fStateCheckPointRequest == null) {
            object = this.fCheckPointUpdateSyncObj;
            synchronized (object) {
                this.fCheckPointUpdateBusy = false;
            }
        }
    }

    @Override
    public LTTngTreeNode getSelectedExperiment() {
        return this.fSelectedExperiment;
    }

    @Override
    public TmfTimeRange getExperimentTimeRange() {
        TmfTimeRange timeRangeResult = null;
        if (this.fSelectedExperiment != null) {
            timeRangeResult = ((TmfExperiment)this.fSelectedExperiment.getValue()).getTimeRange();
        }
        return timeRangeResult;
    }

    protected void finalize() {
        this.fexperimentListener.dispose();
    }

    @Override
    public void waitForCompletion(boolean wait) {
        this.fwaitForCompletion = wait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITmfDataRequest<LttngEvent> buildCheckPoints(final TmfExperiment<LttngEvent> experiment, TmfTimeRange range, boolean initial) {
        Object traceStateManagerNode;
        if (experiment == null) {
            TraceDebug.debug("Received experiment is null");
            return null;
        }
        LTTngTreeNode experimentNode = (LTTngTreeNode)this.getChildByName(experiment.getName());
        if (experimentNode == null) {
            TraceDebug.debug("Experiment Node " + experiment.getName() + " does not exist");
            return null;
        }
        final boolean waitForCompletion = this.fwaitForCompletion;
        LTTngTreeNode[] traceNodes = experimentNode.getChildren();
        if (initial) {
            StateExperimentManager stateExperimentManager = this;
            synchronized (stateExperimentManager) {
                this.ftraceToManagerMap.clear();
            }
            LTTngTreeNode[] lTTngTreeNodeArray = traceNodes;
            int n = traceNodes.length;
            int n2 = 0;
            while (n2 < n) {
                IStateTraceManager traceManager;
                traceStateManagerNode = lTTngTreeNodeArray[n2];
                try {
                    traceManager = (IStateTraceManager)traceStateManagerNode;
                }
                catch (ClassCastException e) {
                    e.printStackTrace();
                    return null;
                }
                traceManager.clearCheckPoints();
                ITmfTrace<?> trace = traceManager.getStateTrace();
                StateExperimentManager stateExperimentManager2 = this;
                synchronized (stateExperimentManager2) {
                    this.ftraceToManagerMap.put(trace, new StateTraceHelper(traceManager));
                }
                ++n2;
            }
        }
        if (this.ftraceToManagerMap.size() < 1) {
            TraceDebug.debug("No traces associated to experiment " + experiment.getName());
            return null;
        }
        this.fCheckPointNbEventsHandled = 0L;
        TmfEventRequest<LttngEvent> request = new TmfEventRequest<LttngEvent>(LttngEvent.class, range, this.fCheckPointUpdateIndex, Integer.MAX_VALUE, 50000, ITmfDataRequest.ExecutionType.BACKGROUND){

            public void handleData(LttngEvent event) {
                super.handleData((ITmfEvent)event);
                if (event != null) {
                    StateExperimentManager stateExperimentManager = StateExperimentManager.this;
                    stateExperimentManager.fCheckPointNbEventsHandled = stateExperimentManager.fCheckPointNbEventsHandled + 1L;
                    ITmfTrace trace = event.getTrace();
                    StateTraceHelper helper = (StateTraceHelper)StateExperimentManager.this.ftraceToManagerMap.get(trace);
                    if (helper != null) {
                        helper.incrementNumberRead();
                        LttngSyntheticEvent synEvent = StateExperimentManager.this.updateSynEvent(event, helper.getTraceModel());
                        helper.getStateManager().handleEvent(synEvent, helper.getNumberRead());
                    } else {
                        TraceDebug.debug("StateTraceManager not found for trace" + trace.getName());
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleCompleted() {
                super.handleCompleted();
                this.printCompletedMessage();
                if (!waitForCompletion) {
                    Object object = StateExperimentManager.this.fCheckPointUpdateSyncObj;
                    synchronized (object) {
                        StateExperimentManager.this.fCheckPointUpdateBusy = false;
                        StateExperimentManager stateExperimentManager = StateExperimentManager.this;
                        stateExperimentManager.fCheckPointUpdateIndex = (int)((long)stateExperimentManager.fCheckPointUpdateIndex + StateExperimentManager.this.fCheckPointNbEventsHandled);
                        if (StateExperimentManager.this.fCheckPointUpdatePending) {
                            StateExperimentManager.this.fCheckPointUpdatePending = false;
                            StateExperimentManager.this.fCheckPointUpdateBusy = true;
                            StateExperimentManager.this.buildCheckPoints((TmfExperiment<LttngEvent>)experiment, StateExperimentManager.this.fCheckPointUpdateRange, false);
                        }
                    }
                }
            }

            private void printCompletedMessage() {
                if (TraceDebug.isDEBUG()) {
                    TraceDebug.debug("Trace check point building completed, number of events handled: " + StateExperimentManager.this.fCheckPointNbEventsHandled + "\n\t\t");
                    for (StateTraceHelper helper : StateExperimentManager.this.ftraceToManagerMap.values()) {
                        TraceDebug.debug(String.valueOf(helper.getStateManager().toString()) + "\n\t\t");
                    }
                }
            }
        };
        experiment.sendRequest((ITmfDataRequest)request);
        if (waitForCompletion) {
            try {
                request.waitForCompletion();
                traceStateManagerNode = this.fCheckPointUpdateSyncObj;
                synchronized (traceStateManagerNode) {
                    this.fCheckPointUpdateBusy = false;
                    this.fCheckPointUpdateIndex = (int)((long)this.fCheckPointUpdateIndex + this.fCheckPointNbEventsHandled);
                    if (this.fCheckPointUpdatePending) {
                        this.fCheckPointUpdatePending = false;
                        this.fCheckPointUpdateBusy = true;
                        this.buildCheckPoints(experiment, this.fCheckPointUpdateRange, false);
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return request;
    }

    private LttngSyntheticEvent updateSynEvent(LttngEvent e, LttngTraceState stateModel) {
        if (this.syntheticEvent == null || this.syntheticEvent.getBaseEvent() != e) {
            this.syntheticEvent = new LttngSyntheticEvent(e);
        }
        this.syntheticEvent.setTraceModel(stateModel);
        this.syntheticEvent.setSequenceInd(LttngSyntheticEvent.SequenceInd.UPDATE);
        return this.syntheticEvent;
    }

    private static class StateTraceHelper {
        IStateTraceManager stateTraceManager = null;
        long numberEventsRead = 0L;
        LttngTraceState stateTraceModel = null;

        public StateTraceHelper(IStateTraceManager stateManager) {
            this.stateTraceManager = stateManager;
            this.stateTraceManager.restoreCheckPointByTimestamp(stateManager.getStateTrace().getStartTime());
            this.stateTraceModel = this.stateTraceManager.getStateModel();
        }

        public IStateTraceManager getStateManager() {
            return this.stateTraceManager;
        }

        public long getNumberRead() {
            return this.numberEventsRead;
        }

        public void incrementNumberRead() {
            ++this.numberEventsRead;
        }

        public LttngTraceState getTraceModel() {
            return this.stateTraceModel;
        }
    }
}

