/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.trace;

import java.util.Collection;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.Vector;
import org.eclipse.linuxtools.ctf.core.CtfCorePlugin;
import org.eclipse.linuxtools.ctf.core.event.EventDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.CTFTrace;
import org.eclipse.linuxtools.ctf.core.trace.Stream;
import org.eclipse.linuxtools.ctf.core.trace.StreamInput;
import org.eclipse.linuxtools.ctf.core.trace.StreamInputReader;
import org.eclipse.linuxtools.ctf.core.trace.StreamInputReaderTimestampComparator;

public class CTFTraceReader {
    private final CTFTrace trace;
    private final Vector<StreamInputReader> streamInputReaders = new Vector();
    protected PriorityQueue<StreamInputReader> prio;
    private int[] eventCountPerTraceFile;
    private long startTime;
    private long endTime;

    public CTFTraceReader(CTFTrace trace) {
        this.trace = trace;
        this.createStreamInputReaders();
        this.populateStreamInputReaderHeap();
        this.endTime = this.startTime = this.prio.peek().getCurrentEvent().timestamp;
    }

    public CTFTraceReader copyFrom() {
        CTFTraceReader newReader = null;
        newReader = new CTFTraceReader(this.trace);
        newReader.startTime = this.startTime;
        newReader.endTime = this.endTime;
        return newReader;
    }

    public long getStartTime() {
        return this.startTime;
    }

    private void createStreamInputReaders() {
        Collection<Stream> streams = this.trace.getStreams().values();
        for (Stream stream : streams) {
            Set<StreamInput> streamInputs = stream.getStreamInputs();
            for (StreamInput streamInput : streamInputs) {
                StreamInputReader streamInputReader = new StreamInputReader(streamInput);
                this.streamInputReaders.add(streamInputReader);
            }
        }
        this.eventCountPerTraceFile = new int[this.streamInputReaders.size()];
    }

    private void populateStreamInputReaderHeap() {
        this.prio = new PriorityQueue<StreamInputReader>(this.streamInputReaders.size() * 2, new StreamInputReaderTimestampComparator());
        int pos = 0;
        for (StreamInputReader reader : this.streamInputReaders) {
            if (!reader.readNextEvent()) continue;
            this.prio.add(reader);
            this.eventCountPerTraceFile[pos] = 0;
            reader.setName(pos);
            ++pos;
        }
    }

    public EventDefinition getCurrentEventDef() {
        StreamInputReader top = this.prio.peek();
        return top != null ? top.getCurrentEvent() : null;
    }

    public boolean advance() {
        StreamInputReader top = this.prio.poll();
        if (top == null) {
            return false;
        }
        if (top.readNextEvent()) {
            this.prio.add(top);
            long topEnd = top.getCurrentEvent().timestamp;
            this.endTime = Math.max(topEnd, this.endTime);
            int n = top.getName();
            this.eventCountPerTraceFile[n] = this.eventCountPerTraceFile[n] + 1;
        }
        return this.hasMoreEvents();
    }

    public void goToLastEvent() throws CTFReaderException {
        this.seek(0L);
        for (StreamInputReader streamInputReader : this.streamInputReaders) {
            streamInputReader.goToLastEvent();
        }
        int count = this.prio.size();
        int i = 0;
        while (i < count) {
            this.advance();
            ++i;
        }
    }

    public boolean seek(long timestamp) {
        this.prio.clear();
        for (StreamInputReader streamInputReader : this.streamInputReaders) {
            streamInputReader.seek(timestamp);
            if (streamInputReader.getCurrentEvent() == null) continue;
            this.prio.add(streamInputReader);
        }
        return this.hasMoreEvents();
    }

    public boolean hasMoreEvents() {
        return this.prio.size() > 0;
    }

    public void printStats() {
        this.printStats(60);
    }

    public void printStats(int width) {
        int numEvents = 0;
        if (width == 0) {
            return;
        }
        int[] nArray = this.eventCountPerTraceFile;
        int n = this.eventCountPerTraceFile.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            numEvents += i;
            ++n2;
        }
        int j = 0;
        while (j < this.eventCountPerTraceFile.length) {
            StreamInputReader se = this.streamInputReaders.get(j);
            int len = width * this.eventCountPerTraceFile[se.getName()] / numEvents;
            StringBuilder sb = new StringBuilder(String.valueOf(se.getStreamInput().getFilename()) + "\t[");
            int i = 0;
            while (i < len) {
                sb.append('+');
                ++i;
            }
            i = len;
            while (i < width) {
                sb.append(' ');
                ++i;
            }
            sb.append("]\t" + this.eventCountPerTraceFile[se.getName()] + " Events");
            CtfCorePlugin.getDefault().log(sb.toString());
            ++j;
        }
    }

    public long getEndTime() {
        return this.endTime;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.endTime ^ this.endTime >>> 32);
        result = 31 * result + (int)(this.startTime ^ this.startTime >>> 32);
        result = 31 * result + (this.streamInputReaders == null ? 0 : this.streamInputReaders.hashCode());
        result = 31 * result + (this.trace == null ? 0 : this.trace.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CTFTraceReader other = (CTFTraceReader)obj;
        if (this.endTime != other.endTime) {
            return false;
        }
        if (this.startTime != other.startTime) {
            return false;
        }
        if (this.streamInputReaders == null ? other.streamInputReaders != null : !this.streamInputReaders.equals(other.streamInputReaders)) {
            return false;
        }
        return !(this.trace == null ? other.trace != null : !this.trace.equals(other.trace));
    }

    public String toString() {
        return "CTFTraceReader [trace=" + this.trace + ']';
    }

    public CTFTrace getTrace() {
        return this.trace;
    }
}

