/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.statistics.model;

import java.util.Collection;
import org.eclipse.linuxtools.tmf.ui.views.statistics.model.AbsTmfStatisticsTree;
import org.eclipse.linuxtools.tmf.ui.views.statistics.model.TmfStatistics;
import org.eclipse.linuxtools.tmf.util.TmfFixedArray;

public class TmfStatisticsTreeNode {
    protected TmfStatistics fValue;
    protected TmfFixedArray<String> fPath;
    protected AbsTmfStatisticsTree fNodes;

    public TmfStatisticsTreeNode(TmfFixedArray<String> path, AbsTmfStatisticsTree nodes) {
        this.fPath = path;
        this.fNodes = nodes;
        this.fValue = new TmfStatistics();
    }

    public boolean containsChild(String key) {
        if (AbsTmfStatisticsTree.ROOT.equals(this.fPath)) {
            return this.fNodes.get((TmfFixedArray<String>)new TmfFixedArray((Object[])new String[]{key})) != null;
        }
        return this.fNodes.get((TmfFixedArray<String>)this.fPath.append((Object)key)) != null;
    }

    public Collection<TmfStatisticsTreeNode> getChildren() {
        return this.fNodes.getChildren(this.fPath);
    }

    public Collection<TmfStatisticsTreeNode> getAllChildren() {
        return this.fNodes.getAllChildren(this.fPath);
    }

    public String getKey() {
        return (String)this.fPath.get(this.fPath.size() - 1);
    }

    public int getNbChildren() {
        return this.fNodes.getChildren(this.fPath).size();
    }

    public TmfStatisticsTreeNode getParent() {
        return this.fNodes.getParent(this.fPath);
    }

    public TmfFixedArray<String> getPath() {
        return this.fPath;
    }

    public TmfStatistics getValue() {
        return this.fValue;
    }

    public boolean hasChildren() {
        return !this.fNodes.getChildren(this.fPath).isEmpty();
    }

    public void reset() {
        this.fValue = new TmfStatistics();
        this.fNodes.reset(this.fPath);
    }
}

