/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.util;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.RandomAccess;

public final class TmfFixedArray<T>
extends AbstractList<T>
implements RandomAccess {
    private final T[] fArray;

    private static <E> E[] copyOf(E[] array, int newLength) {
        Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), newLength);
        System.arraycopy(array, 0, result, 0, Math.min(array.length, newLength));
        return result;
    }

    private static <E, U> E[] copyOf(U[] array, int newLength, Class<? extends E[]> newType) {
        Object[] result = (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(array, 0, result, 0, Math.min(array.length, newLength));
        return result;
    }

    private static <E> E[] copyOfRange(E[] array, int start, int end) {
        Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), end - start);
        System.arraycopy(array, start, result, 0, end - start);
        return result;
    }

    public TmfFixedArray(T ... array) {
        this.fArray = array;
    }

    public TmfFixedArray<T> append(TmfFixedArray<T> value) {
        TmfFixedArray<T> result = new TmfFixedArray<T>(TmfFixedArray.copyOf(this.fArray, this.fArray.length + value.size()));
        System.arraycopy(value.fArray, 0, result.fArray, this.fArray.length, value.fArray.length);
        return result;
    }

    public TmfFixedArray<T> append(TmfFixedArray<T> ... values) {
        int newLength = 0;
        TmfFixedArray<T>[] tmfFixedArrayArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            TmfFixedArray<T> value = tmfFixedArrayArray[n2];
            newLength += value.size();
            ++n2;
        }
        TmfFixedArray<T> result = new TmfFixedArray<T>(TmfFixedArray.copyOf(this.fArray, this.fArray.length + newLength));
        newLength = this.fArray.length;
        TmfFixedArray<T>[] tmfFixedArrayArray2 = values;
        int n3 = values.length;
        n = 0;
        while (n < n3) {
            TmfFixedArray<T> value = tmfFixedArrayArray2[n];
            System.arraycopy(value.fArray, 0, result.fArray, newLength, value.fArray.length);
            newLength += value.fArray.length;
            ++n;
        }
        return result;
    }

    public TmfFixedArray<T> append(T value) {
        TmfFixedArray<T> result = new TmfFixedArray<T>(TmfFixedArray.copyOf(this.fArray, this.fArray.length + 1));
        result.set(this.fArray.length, value);
        return result;
    }

    public TmfFixedArray<T> append(T ... values) {
        TmfFixedArray<T> result = new TmfFixedArray<T>(TmfFixedArray.copyOf(this.fArray, this.fArray.length + values.length));
        int i = 0;
        while (i < values.length) {
            result.set(this.fArray.length + i, values[i]);
            ++i;
        }
        return result;
    }

    public Object clone() {
        return new TmfFixedArray<T>(TmfFixedArray.copyOf(this.fArray, this.fArray.length));
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof TmfFixedArray) {
            return Arrays.equals(this.fArray, ((TmfFixedArray)o).fArray);
        }
        if (!(o instanceof List)) {
            return false;
        }
        int i = 0;
        while (i < this.fArray.length) {
            if (!this.fArray[i].equals((List)o)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public T get(int index) {
        return this.fArray[index];
    }

    public T[] getArray() {
        return this.fArray;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.fArray);
    }

    @Override
    public T set(int index, T element) {
        T temp = this.fArray[index];
        this.fArray[index] = element;
        return temp;
    }

    @Override
    public int size() {
        return this.fArray.length;
    }

    public TmfFixedArray<T> subArray(int start) {
        return new TmfFixedArray<T>(TmfFixedArray.copyOfRange(this.fArray, start, this.fArray.length));
    }

    public TmfFixedArray<T> subArray(int start, int length) {
        return new TmfFixedArray<T>(TmfFixedArray.copyOfRange(this.fArray, start, length + start));
    }

    @Override
    public T[] toArray() {
        return TmfFixedArray.copyOf(this.fArray, this.fArray.length);
    }

    @Override
    public <E> E[] toArray(E[] array) {
        if (array.length < this.fArray.length) {
            return TmfFixedArray.copyOf(this.fArray, this.fArray.length, array.getClass());
        }
        System.arraycopy(this.fArray, 0, array, 0, this.fArray.length);
        if (array.length > this.fArray.length) {
            array[this.fArray.length] = null;
        }
        return array;
    }

    @Override
    public String toString() {
        return Arrays.toString(this.fArray);
    }
}

