/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.event;

import org.eclipse.linuxtools.tmf.event.TmfEventContent;

public class TmfEventField
implements Cloneable {
    protected TmfEventContent fParent;
    protected String fFieldId;
    protected Object fValue;

    private TmfEventField() {
        throw new AssertionError();
    }

    public TmfEventField(TmfEventContent parent, String id, Object value) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.fParent = parent;
        this.fFieldId = id;
        this.fValue = value;
    }

    public TmfEventField(TmfEventField other) {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        this.fParent = other.fParent;
        this.fFieldId = other.fFieldId;
        this.fValue = other.fValue;
    }

    public TmfEventContent getParent() {
        return this.fParent;
    }

    public String getId() {
        return this.fFieldId;
    }

    public Object getValue() {
        return this.fValue;
    }

    protected void setValue(Object value) {
        this.fValue = value;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.fFieldId.hashCode();
        result = 37 * result + this.fValue.hashCode();
        return result;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TmfEventField)) {
            return false;
        }
        TmfEventField o = (TmfEventField)other;
        return this.fParent.equals(o.fParent) && this.fFieldId.equals(o.fFieldId) && this.fValue.equals(o.fValue);
    }

    public String toString() {
        return "[TmfEventField(" + this.fFieldId + ":" + this.fValue.toString() + ")]";
    }

    public TmfEventField clone() {
        TmfEventField clone = null;
        try {
            clone = (TmfEventField)super.clone();
            clone.fParent = this.fParent;
            clone.fFieldId = new String(this.fFieldId);
            clone.fValue = null;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }
}

