/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.rpmlint.resolutions;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.linuxtools.rpm.rpmlint.RpmlintLog;
import org.eclipse.linuxtools.rpm.rpmlint.resolutions.ARpmlintResolution;
import org.eclipse.linuxtools.rpm.ui.editor.SpecfileEditor;

public abstract class AReplaceTextResolution
extends ARpmlintResolution {
    public abstract String getOriginalString();

    public abstract String getReplaceString();

    public void run(IMarker marker) {
        SpecfileEditor editor = this.getEditor(marker);
        if (editor == null) {
            return;
        }
        IDocument doc = editor.getSpecfileSourceViewer().getDocument();
        try {
            int lineNumber = marker.getAttribute("lineNumber", 0);
            int index = doc.getLineOffset(lineNumber);
            String line = editor.getSpecfile().getLine(lineNumber);
            int rowIndex = line.indexOf(this.getOriginalString());
            if (rowIndex > -1) {
                doc.replace(index + rowIndex, this.getOriginalString().length(), this.getReplaceString());
            }
        }
        catch (BadLocationException e) {
            RpmlintLog.logError(e);
        }
    }
}

