/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.histogram;

import org.eclipse.linuxtools.lttng.event.LttngEvent;
import org.eclipse.linuxtools.lttng.ui.views.histogram.Histogram;
import org.eclipse.linuxtools.tmf.event.TmfData;
import org.eclipse.linuxtools.tmf.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.request.TmfEventRequest;

public class HistogramRequest
extends TmfEventRequest<LttngEvent> {
    private final Histogram fHistogram;

    public HistogramRequest(Histogram histogram, TmfTimeRange range, int rank, int nbEvents, ITmfDataRequest.ExecutionType execType) {
        super(LttngEvent.class, range, rank, nbEvents, 50000, execType);
        this.fHistogram = histogram;
    }

    public HistogramRequest(Histogram histogram, TmfTimeRange range, ITmfDataRequest.ExecutionType execType) {
        this(histogram, range, 0, Integer.MAX_VALUE, execType);
    }

    public HistogramRequest(Histogram histogram, TmfTimeRange range, int rank, ITmfDataRequest.ExecutionType execType) {
        this(histogram, range, rank, Integer.MAX_VALUE, execType);
    }

    public void handleData(LttngEvent event) {
        super.handleData((TmfData)event);
        if (event != null) {
            long timestamp = event.getTimestamp().getValue();
            this.fHistogram.countEvent(timestamp);
        }
    }

    public void handleCompleted() {
        this.fHistogram.refresh();
        super.handleCompleted();
    }

    public void handleCancel() {
        this.fHistogram.refresh();
        super.handleCancel();
    }
}

