/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class TraceHelper {
    private static String TRACE_LIB_PATH = "traceLibraryPath";
    private static String QUALIFIER = "org.eclipse.linuxtools.lttng.jni";

    public static String getTraceLibDirFromProject(IProject project) {
        if (project != null && project.exists()) {
            return TraceHelper.getProjectPreference(project, TRACE_LIB_PATH);
        }
        return null;
    }

    public static String getProjectPreference(IProject project, String preferenceName) {
        if (project.exists()) {
            IEclipsePreferences prefs = new ProjectScope(project).getNode(QUALIFIER);
            return prefs.get(preferenceName, null);
        }
        return null;
    }

    public static boolean setProjectPreference(IProject project, String preferenceName, String preferenceValue) {
        if (project.exists()) {
            IEclipsePreferences prefs = new ProjectScope(project).getNode(QUALIFIER);
            prefs.put(preferenceName, preferenceValue);
            try {
                prefs.flush();
                return true;
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean removeProjectPreference(IProject project, String preferenceName) {
        if (project.exists()) {
            IEclipsePreferences prefs = new ProjectScope(project).getNode(QUALIFIER);
            prefs.remove(preferenceName);
            try {
                prefs.flush();
                return true;
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

