/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.histogram;

import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramConstant;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramElement;

public class HistogramContent {
    private long startTime = 0L;
    private long endTime = 0L;
    private long elementsTimeInterval = 1L;
    private double heightFactor = 100.0;
    private long heighestEventCount = 0L;
    private int maxHeight = 0;
    private int canvasWindowSize = 0;
    private int barsWidth = 0;
    private double maxDifferenceToAverage = 1000.0;
    private double maxDifferenceFactor = 1.0;
    private int readyUpToPosition = 0;
    private int averageNumberOfEvents = 0;
    private long selectedEventTimeInWindow = -1L;
    private HistogramElement[] elementTable;

    public HistogramContent(int tableSize, int newCanvasSize, int newBarWidth, int newMaxHeight) {
        this(tableSize, newCanvasSize, newBarWidth, newMaxHeight, 1000.0);
    }

    public HistogramContent(int tableSize, int newCanvasSize, int newBarWidth, int newMaxHeight, double newDiffToAverage) {
        this.canvasWindowSize = newCanvasSize;
        this.barsWidth = newBarWidth;
        this.maxHeight = newMaxHeight;
        this.maxDifferenceToAverage = newDiffToAverage;
        this.createNewTable(tableSize);
    }

    public void createNewTable(int newTableSize) {
        this.elementTable = new HistogramElement[newTableSize];
        int x = 0;
        while (x < this.elementTable.length) {
            this.elementTable[x] = new HistogramElement();
            this.elementTable[x].index = x;
            ++x;
        }
    }

    public void clearContentData() {
        this.startTime = 0L;
        this.endTime = 0L;
        this.elementsTimeInterval = 1L;
        this.heightFactor = 100.0;
        this.heighestEventCount = 0L;
        this.readyUpToPosition = 0;
    }

    public void resetTable() {
        int x = 0;
        while (x < this.elementTable.length) {
            this.elementTable[x].index = x;
            this.elementTable[x].firstIntervalTimestamp = this.startTime + (long)x * this.elementsTimeInterval;
            this.elementTable[x].intervalNbEvents = 0L;
            this.elementTable[x].intervalHeight = 0;
            ++x;
        }
    }

    public void resetTable(long newStartTime, long newEndTime) {
        this.resetTable(newStartTime, newEndTime, this.elementsTimeInterval);
    }

    public void resetTable(long newStartTime, long newEndTime, long newTimeInterval) {
        this.startTime = newStartTime;
        this.endTime = newEndTime;
        this.recalculateElementsTimeInterval(newStartTime, newEndTime);
        int x = 0;
        while (x < this.elementTable.length) {
            this.elementTable[x].index = x;
            this.elementTable[x].firstIntervalTimestamp = this.startTime + (long)x * this.elementsTimeInterval;
            this.elementTable[x].intervalNbEvents = 0L;
            this.elementTable[x].intervalHeight = 0;
            ++x;
        }
    }

    public void clearTable() {
        int x = 0;
        while (x < this.elementTable.length) {
            this.elementTable[x].index = x;
            this.elementTable[x].firstIntervalTimestamp = 0L;
            this.elementTable[x].intervalNbEvents = 0L;
            this.elementTable[x].intervalHeight = 0;
            ++x;
        }
    }

    public void printContentInfo() {
        System.out.println("startTime          : " + this.startTime);
        System.out.println("endTime            : " + this.endTime);
        System.out.println();
        System.out.println("intervalTime       : " + this.elementsTimeInterval);
        System.out.println("heightFactor       : " + this.heightFactor);
        System.out.println("heighestEventCount : " + this.heighestEventCount);
        System.out.println();
        System.out.println("readyUpToPosition  : " + this.readyUpToPosition);
    }

    public void printTable() {
        int x = 0;
        while (x < this.elementTable.length) {
            System.out.println("X:" + x + " -> " + this.elementTable[x].intervalNbEvents + ":" + this.elementTable[x].intervalHeight + " (" + this.elementTable[x].firstIntervalTimestamp + ")");
            ++x;
        }
    }

    public long getSelectedEventTimeInWindow() {
        return this.selectedEventTimeInWindow;
    }

    public void setSelectedEventTimeInWindow(long newTime) {
        this.selectedEventTimeInWindow = newTime;
    }

    public HistogramElement getElementByIndex(int index) {
        HistogramElement returnedElement = null;
        if (index >= 0 && index < this.elementTable.length) {
            returnedElement = this.elementTable[index];
        }
        return returnedElement;
    }

    public HistogramElement getClosestElementFromXPosition(int position) {
        int index = (int)Math.round((double)this.elementTable.length * ((double)position / (double)this.canvasWindowSize));
        if (index < 0) {
            index = 0;
        } else if (index >= this.elementTable.length) {
            index = this.elementTable.length - 1;
        }
        return this.elementTable[index];
    }

    public long getClosestTimestampFromXPosition(int position) {
        return this.getClosestElementFromXPosition((int)position).firstIntervalTimestamp;
    }

    public int getXPositionFromElement(HistogramElement targetElement) {
        return (int)Math.round((double)targetElement.index / (double)this.elementTable.length * (double)this.canvasWindowSize);
    }

    public HistogramElement getClosestElementFromTimestamp(long timestamp) {
        int index = (int)Math.round((double)(timestamp - this.startTime) / (double)this.elementsTimeInterval);
        if (index < 0) {
            index = 0;
        } else if (index >= this.elementTable.length) {
            index = this.elementTable.length - 1;
        }
        return this.elementTable[index];
    }

    public int getClosestXPositionFromTimestamp(long timestamp) {
        return this.getXPositionFromElement(this.getClosestElementFromTimestamp(timestamp));
    }

    public HistogramElement getClosestElementByElementAndTimeInterval(HistogramElement targetElement, long intervalToElement) {
        long elementTime = targetElement.firstIntervalTimestamp;
        return this.getClosestElementFromTimestamp(elementTime += intervalToElement);
    }

    public int getClosestElementByTimestampAndTimeInterval(long timestamp, long intervalToElement) {
        HistogramElement targetElement = this.getClosestElementFromTimestamp(timestamp);
        HistogramElement newElement = this.getClosestElementByElementAndTimeInterval(targetElement, intervalToElement);
        return this.getXPositionFromElement(newElement);
    }

    public int getXPositionByPositionAndTimeInterval(int targetPosition, long intervalToElement) {
        HistogramElement targetElement = this.getClosestElementFromXPosition(targetPosition);
        HistogramElement newElement = this.getClosestElementByElementAndTimeInterval(targetElement, intervalToElement);
        return this.getXPositionFromElement(newElement);
    }

    public int getNbElement() {
        return this.elementTable.length;
    }

    public int getAverageNumberOfEvents() {
        return this.averageNumberOfEvents;
    }

    public void setAverageNumberOfEvents(int newAverageNumberOfEvents) {
        this.averageNumberOfEvents = newAverageNumberOfEvents;
    }

    public void recalculateAverageNumberOfEvents() {
        int nbInterval = 0;
        int totalNbEvents = 0;
        int x = 0;
        while (x < this.readyUpToPosition) {
            if (HistogramConstant.SKIP_EMPTY_INTERVALS_WHEN_CALCULATING_AVERAGE.booleanValue()) {
                if (this.elementTable[x].intervalNbEvents > 0L) {
                    ++nbInterval;
                }
            } else {
                ++nbInterval;
            }
            totalNbEvents = (int)((long)totalNbEvents + this.elementTable[x].intervalNbEvents);
            ++x;
        }
        this.averageNumberOfEvents = (int)Math.round((double)totalNbEvents / (double)nbInterval);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long newStartTime) {
        this.startTime = newStartTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long newEndTime) {
        this.endTime = newEndTime;
    }

    public long getCompleteTimeInterval() {
        return this.endTime - this.startTime;
    }

    public long getReadyTimeInterval() {
        return this.elementTable[this.readyUpToPosition].firstIntervalTimestamp - this.elementTable[0].firstIntervalTimestamp;
    }

    public double getHeightFactor() {
        return this.heightFactor;
    }

    public void recalculateHeightFactor() {
        double diffToConsider = this.maxDifferenceToAverage * this.maxDifferenceFactor * (double)this.barsWidth;
        this.heightFactor = this.heighestEventCount > (long)(diffToConsider * (double)this.averageNumberOfEvents) ? (double)this.maxHeight / (diffToConsider * (double)this.averageNumberOfEvents) : (double)this.maxHeight / (double)this.heighestEventCount;
    }

    public void recalculateEventHeight() {
        int x = 0;
        while (x < this.readyUpToPosition) {
            this.elementTable[x].intervalHeight = (int)Math.ceil((double)this.elementTable[x].intervalNbEvents * this.heightFactor);
            ++x;
        }
    }

    public void recalculateEventHeightInInterval(int startPosition, int stopPosition) {
        if (startPosition < 0) {
            startPosition = 0;
        }
        if (stopPosition >= this.elementTable.length) {
            stopPosition = this.elementTable.length - 1;
        }
        int x = startPosition;
        while (x < stopPosition) {
            this.elementTable[x].intervalHeight = (int)Math.ceil((double)this.elementTable[x].intervalNbEvents * this.heightFactor);
            ++x;
        }
    }

    public int getCanvasWindowSize() {
        return this.canvasWindowSize;
    }

    public void setCanvasWindowSize(int newSize) {
        this.canvasWindowSize = newSize;
    }

    public long getHeighestEventCount() {
        return this.heighestEventCount;
    }

    public void setHeighestEventCount(long newHeighestEventCount) {
        this.heighestEventCount = newHeighestEventCount;
    }

    public void recalculateHeighestEventCount() {
        int x = 0;
        while (x < this.readyUpToPosition) {
            if (this.elementTable[x].intervalNbEvents > this.heighestEventCount) {
                this.heighestEventCount = this.elementTable[x].intervalNbEvents;
            }
            ++x;
        }
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public double getMaxDifferenceToAverage() {
        return this.maxDifferenceToAverage;
    }

    public void setMaxDifferenceToAverage(double newDiffToAverage) {
        this.maxDifferenceToAverage = newDiffToAverage;
    }

    public double getMaxDifferenceToAverageFactor() {
        return this.maxDifferenceFactor;
    }

    public void setMaxDifferenceToAverageFactor(double newFactor) {
        this.maxDifferenceFactor = newFactor;
    }

    public long getElementsTimeInterval() {
        return this.elementsTimeInterval;
    }

    public void setElementsTimeInterval(long newInterval) {
        this.elementsTimeInterval = newInterval;
    }

    public void recalculateElementsTimeInterval(long startTime, long endTime) {
        long tmpInterval = (long)Math.ceil((double)(endTime - startTime) / (double)this.getNbElement());
        if (tmpInterval <= 0L) {
            tmpInterval = 1L;
        }
        this.elementsTimeInterval = tmpInterval;
    }

    public int getReadyUpToPosition() {
        return this.readyUpToPosition;
    }

    public void setReadyUpToPosition(int newReadyUpToPosition) {
        this.readyUpToPosition = newReadyUpToPosition;
    }

    public int getBarsWidth() {
        return this.barsWidth;
    }

    public void setBarsWidth(int newBarsWidth) {
        this.barsWidth = newBarsWidth;
    }
}

