/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.controlflow.evProcessor;

import org.eclipse.linuxtools.lttng.event.LttngEvent;
import org.eclipse.linuxtools.lttng.state.StateStrings;
import org.eclipse.linuxtools.lttng.state.evProcessor.ILttngEventProcessor;
import org.eclipse.linuxtools.lttng.state.model.LttngProcessState;
import org.eclipse.linuxtools.lttng.state.model.LttngTraceState;
import org.eclipse.linuxtools.lttng.ui.TraceDebug;
import org.eclipse.linuxtools.lttng.ui.model.trange.TimeRangeEventProcess;
import org.eclipse.linuxtools.lttng.ui.views.controlflow.evProcessor.AbsFlowTRangeUpdate;
import org.eclipse.linuxtools.tmf.event.TmfTimeRange;

class FlowBeforeUpdateHandlers {
    FlowBeforeUpdateHandlers() {
    }

    final ILttngEventProcessor getStateModesHandler() {
        AbsFlowTRangeUpdate handler = new AbsFlowTRangeUpdate(){

            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long cpu = trcEvent.getCpuId();
                LttngProcessState stateProcess = (LttngProcessState)traceSt.getRunning_process().get(cpu);
                String traceId = traceSt.getTraceId();
                if (stateProcess != null) {
                    TimeRangeEventProcess localProcess = this.procContainer.findProcess(stateProcess.getPid(), stateProcess.getCpu(), traceId, stateProcess.getCreation_time());
                    if (localProcess == null) {
                        TmfTimeRange timeRange = traceSt.getContext().getTraceTimeWindow();
                        localProcess = this.addLocalProcess(stateProcess, timeRange.getStartTime().getValue(), timeRange.getEndTime().getValue(), traceId);
                    }
                    this.makeDraw(traceSt, trcEvent.getTimestamp().getValue(), stateProcess, localProcess, this.params);
                } else {
                    TraceDebug.debug("Running state process is null! (getStateModesHandler)");
                }
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getBeforeSchedChangeHandler() {
        AbsFlowTRangeUpdate handler = new AbsFlowTRangeUpdate(){

            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long pid_out = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_PREV_PID);
                Long pid_in = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_NEXT_PID);
                LttngProcessState process = (LttngProcessState)traceSt.getRunning_process().get(trcEvent.getCpuId());
                if (process != null) {
                    TmfTimeRange timeRange;
                    TimeRangeEventProcess localProcess;
                    if (!process.getPid().equals(pid_out)) {
                        process = this.lttv_state_find_process(traceSt, trcEvent.getCpuId(), pid_out);
                    }
                    if (process != null) {
                        localProcess = this.procContainer.findProcess(process.getPid(), process.getCpu(), traceSt.getTraceId(), process.getCreation_time());
                        if (localProcess == null) {
                            timeRange = traceSt.getContext().getTraceTimeWindow();
                            localProcess = this.addLocalProcess(process, timeRange.getStartTime().getValue(), timeRange.getEndTime().getValue(), traceSt.getTraceId());
                        }
                        this.makeDraw(traceSt, trcEvent.getTimestamp().getValue(), process, localProcess, this.params);
                    }
                    if ((process = this.lttv_state_find_process(traceSt, trcEvent.getCpuId(), pid_in)) != null) {
                        localProcess = this.procContainer.findProcess(process.getPid(), process.getCpu(), traceSt.getTraceId(), process.getCreation_time());
                        if (localProcess == null) {
                            timeRange = traceSt.getContext().getTraceTimeWindow();
                            localProcess = this.addLocalProcess(process, timeRange.getStartTime().getValue(), timeRange.getEndTime().getValue(), traceSt.getTraceId());
                        }
                        this.makeDraw(traceSt, trcEvent.getTimestamp().getValue(), process, localProcess, this.params);
                    }
                } else {
                    TraceDebug.debug("Running process is null! (getBeforeSchedChangeHandler)");
                }
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getProcessExitHandler() {
        AbsFlowTRangeUpdate handler = new AbsFlowTRangeUpdate(){

            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                LttngProcessState process = (LttngProcessState)traceSt.getRunning_process().get(trcEvent.getCpuId());
                if (process != null) {
                    TimeRangeEventProcess localProcess = this.procContainer.findProcess(process.getPid(), process.getCpu(), traceSt.getTraceId(), process.getCreation_time());
                    if (localProcess == null) {
                        TmfTimeRange timeRange = traceSt.getContext().getTraceTimeWindow();
                        localProcess = this.addLocalProcess(process, timeRange.getStartTime().getValue(), timeRange.getEndTime().getValue(), traceSt.getTraceId());
                    }
                    this.makeDraw(traceSt, trcEvent.getTimestamp().getValue(), process, localProcess, this.params);
                } else {
                    TraceDebug.debug("Running process is null! (getProcessExitHandler)");
                }
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getProcessFreeHandler() {
        AbsFlowTRangeUpdate handler = new AbsFlowTRangeUpdate(){

            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                Long release_pid = this.getAFieldLong(trcEvent, traceSt, StateStrings.Fields.LTT_FIELD_PID);
                if (release_pid != null) {
                    LttngProcessState process = this.lttv_state_find_process(traceSt, ANY_CPU, release_pid);
                    if (process != null) {
                        TimeRangeEventProcess localProcess = this.procContainer.findProcess(process.getPid(), process.getCpu(), traceSt.getTraceId(), process.getCreation_time());
                        if (localProcess == null) {
                            return false;
                        }
                        this.makeDraw(traceSt, trcEvent.getTimestamp().getValue(), process, localProcess, this.params);
                    }
                } else {
                    TraceDebug.debug("Release_pid is null! (getProcessFreeHandler)");
                }
                return false;
            }
        };
        return handler;
    }

    final ILttngEventProcessor getStateDumpEndHandler() {
        AbsFlowTRangeUpdate handler = new AbsFlowTRangeUpdate(){

            public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
                LttngProcessState[] processes = traceSt.getProcesses();
                int pos = 0;
                while (pos < processes.length) {
                    LttngProcessState process = processes[pos];
                    TimeRangeEventProcess localProcess = this.procContainer.findProcess(process.getPid(), process.getCpu(), traceSt.getTraceId(), process.getCreation_time());
                    if (localProcess == null) {
                        TmfTimeRange timeRange = traceSt.getContext().getTraceTimeWindow();
                        localProcess = this.addLocalProcess(process, timeRange.getStartTime().getValue(), timeRange.getEndTime().getValue(), traceSt.getTraceId());
                    }
                    this.makeDraw(traceSt, trcEvent.getTimestamp().getValue(), process, localProcess, this.params);
                    ++pos;
                }
                return false;
            }
        };
        return handler;
    }
}

