/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.AutomakeEditor;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.AutomakeEditorFactory;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.AutomakeErrorHandler;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.AutomakefileContentOutlinePage;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.IMakefile;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.IReconcilingParticipant;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.IWorkingCopyManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class AutomakefileReconcilingStrategy
implements IReconcilingStrategy {
    private int fLastRegionOffset;
    private ITextEditor fEditor;
    private IWorkingCopyManager fManager;
    private IDocumentProvider fDocumentProvider;
    private AutomakefileContentOutlinePage fOutliner;
    private IReconcilingParticipant fMakefileReconcilingParticipant;
    private AutomakeErrorHandler fErrorHandler;
    private IEditorInput input;

    public AutomakefileReconcilingStrategy(AutomakeEditor editor) {
        this.fOutliner = editor.getAutomakeOutlinePage();
        this.fLastRegionOffset = Integer.MAX_VALUE;
        this.fEditor = editor;
        this.input = this.fEditor.getEditorInput();
        this.fManager = AutomakeEditorFactory.getDefault().getWorkingCopyManager();
        this.fDocumentProvider = AutomakeEditorFactory.getDefault().getAutomakefileDocumentProvider();
        this.fErrorHandler = new AutomakeErrorHandler(this.fDocumentProvider.getDocument((Object)this.input));
        if (this.fEditor instanceof IReconcilingParticipant) {
            this.fMakefileReconcilingParticipant = (IReconcilingParticipant)this.fEditor;
        }
    }

    public void setDocument(IDocument document) {
    }

    public void reconcile(IRegion region) {
        if (region.getOffset() <= this.fLastRegionOffset) {
            this.reconcile();
        }
        this.fLastRegionOffset = region.getOffset();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion region) {
    }

    private void reconcile() {
        block6: {
            try {
                IMakefile makefile = this.fManager.getWorkingCopy(this.fEditor.getEditorInput());
                if (makefile == null) break block6;
                String content = this.fDocumentProvider.getDocument((Object)this.input).get();
                StringReader reader = new StringReader(content);
                try {
                    makefile.parse(makefile.getFileURI(), (Reader)reader);
                }
                catch (IOException iOException) {}
                this.fOutliner.update();
                this.fErrorHandler.update(makefile);
            }
            finally {
                if (this.fMakefileReconcilingParticipant != null) {
                    this.fMakefileReconcilingParticipant.reconciled();
                }
            }
        }
    }
}

