/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.core.wizards;

import java.util.List;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.core.templateengine.process.processes.Messages;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.templateengine.ProjectCreatedActions;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.cdt.autotools.core.AutotoolsNewProjectNature;
import org.eclipse.linuxtools.internal.cdt.autotools.core.configure.AutotoolsConfigurationManager;

public class NewAutotoolsProject
extends ProcessRunner {
    protected boolean savedAutoBuildingValue;
    protected ProjectCreatedActions pca = new ProjectCreatedActions();
    protected IManagedBuildInfo info;

    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        String projectName = args[0].getSimpleValue();
        String location = args[1].getSimpleValue();
        String artifactExtension = args[2].getSimpleValue();
        String isCProjectValue = args[3].getSimpleValue();
        boolean isCProject = Boolean.valueOf(isCProjectValue);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        try {
            if (!project.exists()) {
                List configs;
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                this.turnOffAutoBuild(workspace);
                IPath locationPath = null;
                if (location != null && !location.trim().equals("")) {
                    locationPath = Path.fromPortableString((String)location);
                }
                if ((configs = template.getTemplateInfo().getConfigurations()) == null || configs.size() == 0) {
                    throw new ProcessFailureException(String.valueOf(Messages.getString((String)"NewManagedProject.4")) + projectName);
                }
                this.pca.setProject(project);
                this.pca.setProjectLocation(locationPath);
                this.pca.setConfigs(configs.toArray(new IConfiguration[configs.size()]));
                this.pca.setArtifactExtension(artifactExtension);
                this.info = this.pca.createProject(monitor, "org.eclipse.cdt.core.fastIndexer", isCProject);
                AutotoolsNewProjectNature.addAutotoolsNature(project, monitor);
                IConfiguration[] cfgs = this.pca.getConfigs();
                int i = 0;
                while (i < cfgs.length) {
                    IConfiguration cfg = cfgs[i];
                    ICConfigurationDescription cfgd = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)cfg);
                    String id = cfgd.getId();
                    AutotoolsConfigurationManager.getInstance().getConfiguration(project, id, true);
                    ++i;
                }
                AutotoolsConfigurationManager.getInstance().saveConfigs(project);
                this.info.setValid(true);
                ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
                this.restoreAutoBuild(workspace);
            } else {
                AutotoolsNewProjectNature.addAutotoolsNature(project, monitor);
            }
        }
        catch (CoreException e) {
            throw new ProcessFailureException(String.valueOf(Messages.getString((String)"NewManagedProject.3")) + e.getMessage(), (Throwable)e);
        }
        catch (BuildException e) {
            throw new ProcessFailureException(String.valueOf(Messages.getString((String)"NewManagedProject.3")) + e.getMessage(), (Throwable)e);
        }
    }

    protected final void turnOffAutoBuild(IWorkspace workspace) throws CoreException {
        IWorkspaceDescription workspaceDesc = workspace.getDescription();
        this.savedAutoBuildingValue = workspaceDesc.isAutoBuilding();
        workspaceDesc.setAutoBuilding(false);
        workspace.setDescription(workspaceDesc);
    }

    protected final void restoreAutoBuild(IWorkspace workspace) throws CoreException {
        IWorkspaceDescription workspaceDesc = workspace.getDescription();
        workspaceDesc.setAutoBuilding(this.savedAutoBuildingValue);
        workspace.setDescription(workspaceDesc);
    }

    protected void setOptionValue(IConfiguration config, IOption option, String val) throws BuildException {
        if (val != null) {
            if (!option.isExtensionElement()) {
                option.setValue(val);
            } else {
                IOption newOption = config.getToolChain().createOption(option, String.valueOf(option.getId()) + "." + ManagedBuildManager.getRandomNumber(), option.getName(), false);
                newOption.setValue(val);
            }
        }
    }
}

