/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.linuxtools.tmf.ui.TmfUiTracer;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Frame;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Metrics;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IGC;

public abstract class GraphNode {
    protected int startEventOccurrence = 0;
    protected int endEventOccurrence = 0;
    public String prefId = "PREF_SYNC_MESS";
    protected boolean selected = false;
    protected boolean focused = false;
    protected boolean hasChilden = false;
    protected String name = "";
    protected HashMap<String, List<GraphNode>> nodes;
    protected HashMap<String, List<GraphNode>> fnodes;
    protected HashMap<String, List<GraphNode>> bnodes;
    protected HashMap<String, Integer> indexes;
    protected HashMap<String, Boolean> fSort;
    protected HashMap<String, Boolean> bSort;

    public void resetIndex() {
        if (!this.hasChilden) {
            return;
        }
        for (String nodeType : this.indexes.keySet()) {
            this.indexes.put(nodeType, 0);
        }
    }

    public void addNode(GraphNode nodeToAdd) {
        if (!this.hasChilden) {
            this.nodes = new HashMap(2);
            this.fnodes = new HashMap(2);
            this.bnodes = new HashMap(2);
            this.indexes = new HashMap(2);
            this.bSort = new HashMap(2);
            this.fSort = new HashMap(2);
            this.hasChilden = true;
        }
        if (nodeToAdd == null) {
            return;
        }
        if (this.nodes.get(nodeToAdd.getArrayId()) == null) {
            this.nodes.put(nodeToAdd.getArrayId(), new ArrayList(1));
            this.indexes.put(nodeToAdd.getArrayId(), 0);
            this.fnodes.put(nodeToAdd.getArrayId(), new ArrayList(1));
            this.fSort.put(nodeToAdd.getArrayId(), false);
            if (nodeToAdd.getBackComparator() != null) {
                this.bnodes.put(nodeToAdd.getArrayId(), new ArrayList(1));
                this.bSort.put(nodeToAdd.getArrayId(), false);
            }
        }
        List<GraphNode> fNodeList = this.fnodes.get(nodeToAdd.getArrayId());
        List<GraphNode> bNodeList = null;
        if (this.bnodes != null) {
            bNodeList = this.bnodes.get(nodeToAdd.getArrayId());
        }
        if (fNodeList != null && fNodeList.size() > 0) {
            GraphNode node = fNodeList.get(fNodeList.size() - 1);
            Comparator<GraphNode> fcomp = nodeToAdd.getComparator();
            Comparator<GraphNode> bcomp = nodeToAdd.getBackComparator();
            if (fcomp != null && fcomp.compare(node, nodeToAdd) > 0) {
                this.fSort.put(nodeToAdd.getArrayId(), true);
            }
            if (bcomp != null && bcomp.compare(node, nodeToAdd) > 0) {
                this.bSort.put(nodeToAdd.getArrayId(), true);
            }
        }
        if (fNodeList == null) {
            fNodeList = new ArrayList<GraphNode>();
        }
        fNodeList.add(nodeToAdd);
        this.nodes.put(nodeToAdd.getArrayId(), fNodeList);
        this.fnodes.put(nodeToAdd.getArrayId(), fNodeList);
        if (nodeToAdd.getBackComparator() != null) {
            bNodeList.add(nodeToAdd);
            this.bnodes.put(nodeToAdd.getArrayId(), bNodeList);
        }
    }

    public void setName(String nodeName) {
        this.name = nodeName;
    }

    public String getName() {
        return this.name;
    }

    public void setSelected(boolean selection) {
        this.selected = selection;
    }

    public void setFocused(boolean focus) {
        this.focused = focus;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean hasFocus() {
        return this.focused;
    }

    public abstract boolean contains(int var1, int var2);

    public abstract int getX();

    public abstract int getY();

    public abstract int getHeight();

    public abstract int getWidth();

    protected abstract void draw(IGC var1);

    public boolean isVisible(int x, int y, int width, int height) {
        return true;
    }

    public Comparator<GraphNode> getComparator() {
        return null;
    }

    public Comparator<GraphNode> getBackComparator() {
        return null;
    }

    public boolean isSameAs(GraphNode node) {
        return false;
    }

    public abstract String getArrayId();

    public boolean positiveDistanceToPoint(int x, int y) {
        return false;
    }

    public GraphNode getNodeAt(int x, int y) {
        GraphNode toReturn = null;
        if (!this.hasChilden) {
            return null;
        }
        Iterator<String> it = this.nodes.keySet().iterator();
        GraphNode node = null;
        while (it.hasNext()) {
            String nodeType = it.next();
            List<GraphNode> list = this.nodes.get(nodeType);
            int index = this.indexes.get(nodeType);
            node = this.getNodeFromListAt(x, y, list, index);
            if (toReturn == null) {
                toReturn = node;
            }
            if (node == null) continue;
            GraphNode internalNode = node.getNodeAt(x, y);
            if (internalNode != null) {
                return internalNode;
            }
            if (Math.abs(node.getWidth()) >= Math.abs(toReturn.getWidth()) && Math.abs(node.getHeight()) >= Math.abs(toReturn.getHeight())) continue;
            toReturn = node;
        }
        return toReturn;
    }

    public ArrayList<GraphNode> getNodeList(GraphNode from, GraphNode to) {
        ArrayList<GraphNode> result = new ArrayList<GraphNode>();
        if (from != null) {
            result.add(from);
        } else if (to != null) {
            result.add(to);
        }
        if (from == null || to == null) {
            return result;
        }
        if (from == to) {
            return result;
        }
        int startX = Math.min(from.getX(), Math.min(to.getX(), Math.min(from.getX() + from.getWidth(), to.getX() + to.getWidth())));
        int endX = Math.max(from.getX(), Math.max(to.getX(), Math.max(from.getX() + from.getWidth(), to.getX() + to.getWidth())));
        int startY = Math.min(from.getY(), Math.min(to.getY(), Math.min(from.getY() + from.getHeight(), to.getY() + to.getHeight())));
        int endY = Math.max(from.getY(), Math.max(to.getY(), Math.max(from.getY() + from.getHeight(), to.getY() + to.getHeight())));
        if (!this.hasChilden) {
            return result;
        }
        for (String nodeType : this.nodes.keySet()) {
            List<GraphNode> nodesList = this.nodes.get(nodeType);
            if (nodesList == null || nodesList.isEmpty()) {
                return null;
            }
            int i = 0;
            while (i < nodesList.size()) {
                int ny;
                GraphNode node = nodesList.get(i);
                int nw = node.getWidth();
                int nh = node.getHeight();
                int nx = node.getX();
                if (GraphNode.contains(startX, startY, endX - startX, endY - startY, nx + 1, (ny = node.getY()) + 1) && GraphNode.contains(startX, startY, endX - startX, endY - startY, nx + nw - 2, ny + nh - 2)) {
                    result.add(node);
                }
                result.addAll(node.getNodeList(from, to));
                ++i;
            }
        }
        if (to != null && !result.contains(to)) {
            result.add(to);
        }
        return result;
    }

    protected GraphNode getNodeFromListAt(int x, int y, List<GraphNode> list, int fromIndex) {
        if (list == null) {
            return null;
        }
        int i = fromIndex;
        while (i < list.size()) {
            GraphNode node = list.get(i);
            if (node.contains(x, y)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public int getStartOccurrence() {
        return this.startEventOccurrence;
    }

    public int getEndOccurrence() {
        return this.endEventOccurrence;
    }

    public void updateIndex(int x, int y, int width, int height) {
        if (!this.hasChilden) {
            return;
        }
        if (TmfUiTracer.isIndexTraced()) {
            TmfUiTracer.traceIndex("*****************************\n");
            TmfUiTracer.traceIndex("Visible area position in virtual screen (x,y)= " + x + " " + y + "\n\n");
        }
        for (String nodeType : this.nodes.keySet()) {
            int direction = 1;
            int drawIndex = this.indexes.get(nodeType);
            if (this.nodes.get(nodeType) != null && this.nodes.get(nodeType).size() > 1) {
                if (this.nodes.get(nodeType).get(drawIndex).positiveDistanceToPoint(x, y)) {
                    direction = -1;
                }
                if (drawIndex == 0) {
                    direction = 1;
                }
                if (direction == -1 && this.bnodes.get(nodeType) != null) {
                    GraphNode currentNode = this.nodes.get(nodeType).get(drawIndex);
                    drawIndex = Arrays.binarySearch(this.bnodes.get(nodeType).toArray(new GraphNode[0]), this.nodes.get(nodeType).get(drawIndex), currentNode.getBackComparator());
                    this.nodes.put(nodeType, this.bnodes.get(nodeType));
                    if (drawIndex < 0) {
                        drawIndex = 0;
                        direction = 1;
                    } else {
                        this.nodes.put(nodeType, this.bnodes.get(nodeType));
                    }
                }
                GraphNode prev = null;
                int i = drawIndex;
                while (i < this.nodes.get(nodeType).size() && i >= 0) {
                    drawIndex = i;
                    this.indexes.put(nodeType, i);
                    GraphNode currentNode = this.nodes.get(nodeType).get(i);
                    if (prev == null) {
                        prev = currentNode;
                    }
                    Comparator<GraphNode> comp = currentNode.getComparator();
                    HashMap<String, Boolean> sort = this.fSort;
                    if (direction == -1 && currentNode.getBackComparator() != null) {
                        comp = currentNode.getBackComparator();
                        sort = this.bSort;
                    }
                    if (i < this.nodes.get(nodeType).size() - 1) {
                        GraphNode next = this.nodes.get(nodeType).get(i + 1);
                        if (comp != null && comp.compare(currentNode, next) > 0) {
                            sort.put(nodeType, true);
                        }
                    }
                    if (direction == 1) {
                        if (this.nodes.get(nodeType).get(i).positiveDistanceToPoint(x, y)) {
                            break;
                        }
                    } else if (currentNode.getBackComparator() == null) {
                        if (!currentNode.positiveDistanceToPoint(x, y)) {
                            break;
                        }
                    } else if (currentNode.isVisible(x, y, width, height) && !currentNode.positiveDistanceToPoint(x, y)) {
                        if (comp != null && comp.compare(currentNode, prev) <= 0) {
                            break;
                        }
                    } else if (comp != null && comp.compare(currentNode, prev) <= 0) {
                        prev = currentNode;
                    }
                    i += direction;
                }
                this.nodes.put(nodeType, this.fnodes.get(nodeType));
                if (this.bnodes.get(nodeType) != null && direction == -1) {
                    int index = this.indexes.get(nodeType);
                    List<GraphNode> list = this.nodes.get(nodeType);
                    List<GraphNode> backList = this.bnodes.get(nodeType);
                    GraphNode currentNode = backList.get(index);
                    if (index > 0) {
                        index = Arrays.binarySearch(list.toArray(new GraphNode[0]), backList.get(index), currentNode.getComparator());
                        if (index < 0) {
                            index = 0;
                        }
                        this.indexes.put(nodeType, index);
                    }
                }
                i = drawIndex;
                while (i < this.nodes.get(nodeType).size() && i >= 0) {
                    GraphNode toDraw = this.nodes.get(nodeType).get(i);
                    toDraw.updateIndex(x, y, width, height);
                    if (!toDraw.isVisible(x, y, width, height)) break;
                    ++i;
                }
            }
            if (!TmfUiTracer.isIndexTraced()) continue;
            TmfUiTracer.traceIndex("First drawn " + nodeType + " index = " + drawIndex + "\n");
            TmfUiTracer.traceIndex(String.valueOf(nodeType) + " found in " + 0 + " iterations\n");
        }
        if (TmfUiTracer.isIndexTraced()) {
            TmfUiTracer.traceIndex("*****************************\n");
        }
    }

    protected void drawChildenNodes(IGC context) {
        if (!this.hasChilden) {
            return;
        }
        for (String nodeType : this.fSort.keySet()) {
            boolean sort = this.fSort.get(nodeType);
            if (!sort) continue;
            GraphNode[] temp = this.fnodes.get(nodeType).toArray(new GraphNode[0]);
            GraphNode node = this.nodes.get(nodeType).get(0);
            Arrays.sort(temp, node.getComparator());
            this.fSort.put(nodeType, false);
            this.nodes.put(nodeType, Arrays.asList(temp));
            this.fnodes.put(nodeType, Arrays.asList(temp));
            if (!TmfUiTracer.isSortingTraced()) continue;
            TmfUiTracer.traceSorting(String.valueOf(nodeType) + " array sorted\n");
        }
        for (String nodeType : this.bSort.keySet()) {
            boolean sort = this.bSort.get(nodeType);
            if (!sort) continue;
            GraphNode[] temp = this.bnodes.get(nodeType).toArray(new GraphNode[0]);
            GraphNode node = this.nodes.get(nodeType).get(0);
            Arrays.sort(temp, node.getBackComparator());
            this.bSort.put(nodeType, false);
            this.bnodes.put(nodeType, Arrays.asList(temp));
            if (!TmfUiTracer.isSortingTraced()) continue;
            TmfUiTracer.traceSorting(String.valueOf(nodeType) + " back array sorted\n");
        }
        if (TmfUiTracer.isDisplayTraced()) {
            TmfUiTracer.traceDisplay("*****************************\n");
        }
        int arrayStep = 1;
        if ((float)(Metrics.getMessageFontHeigth() + 20) * context.getZoom() < 1.0f) {
            arrayStep = Math.round(1.0f / ((float)(Metrics.getMessageFontHeigth() + 20) * context.getZoom()));
        }
        int count = 0;
        Iterator<String> it3 = this.fSort.keySet().iterator();
        while (it3.hasNext()) {
            count = 0;
            String nodeType = it3.next();
            GraphNode node = this.nodes.get(nodeType).get(0);
            context.setFont(Frame.getUserPref().getFont(node.prefId));
            int index = this.indexes.get(nodeType);
            count = this.drawNodes(context, this.nodes.get(nodeType), index, arrayStep);
            if (!TmfUiTracer.isDisplayTraced()) continue;
            TmfUiTracer.traceDisplay(String.valueOf(count) + " " + nodeType + " drawn, starting from index " + index + "\r\n");
        }
        if (TmfUiTracer.isDisplayTraced()) {
            TmfUiTracer.traceDisplay("*****************************\n");
        }
    }

    protected int drawNodes(IGC context, List<GraphNode> list, int startIndex, int step) {
        if (!this.hasChilden) {
            return 0;
        }
        GraphNode last = null;
        int nodesCount = 0;
        if (list.size() < 0) {
            return 0;
        }
        GraphNode node = list.get(0);
        context.setFont(Frame.getUserPref().getFont(node.prefId));
        Comparator<GraphNode> comparator = node.getComparator();
        int i = startIndex;
        while (i < list.size()) {
            int ch;
            int cw;
            int cy;
            int cx;
            GraphNode toDraw = list.get(i);
            if (i < list.size() - 1) {
                GraphNode next = list.get(i + 1);
                if (comparator != null && comparator.compare(toDraw, next) > 0) {
                    this.fSort.put(next.getArrayId(), true);
                }
            }
            if (!toDraw.isVisible(cx = context.getContentsX(), cy = context.getContentsY(), cw = context.getVisibleWidth(), ch = context.getVisibleHeight()) && toDraw.positiveDistanceToPoint(cx + cw, cy + ch)) break;
            if ((!toDraw.isSameAs(last) || toDraw.isSelected()) && toDraw.isVisible(context.getContentsX(), context.getContentsY(), context.getVisibleWidth(), context.getVisibleHeight())) {
                ++nodesCount;
                toDraw.draw(context);
                if (this.hasFocus()) {
                    toDraw.drawFocus(context);
                }
            }
            last = toDraw;
            i += step;
        }
        return nodesCount;
    }

    public void drawFocus(IGC context) {
        context.drawFocus(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public static boolean contains(int x, int y, int width, int height, int px, int py) {
        int locX = x;
        int locY = y;
        int locWidth = width;
        int locHeight = height;
        if (width < 0) {
            locX += width;
            locWidth = -locWidth;
        }
        if (height < 0) {
            locY += height;
            locHeight = -locHeight;
        }
        return px >= locX && py >= locY && px - locX <= locWidth && py - locY <= locHeight;
    }
}

