/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.massif.charting;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifSnapshot;
import org.eclipse.linuxtools.internal.valgrind.massif.charting.ChartEditorInput;
import org.eclipse.linuxtools.internal.valgrind.massif.charting.ChartLocationsDialog;
import org.eclipse.linuxtools.internal.valgrind.massif.charting.HeapChart;
import org.eclipse.linuxtools.internal.valgrind.massif.charting.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.IAxisSet;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;
import org.swtchart.ITitle;
import org.swtchart.LineStyle;
import org.swtchart.Range;

public class ChartEditor
extends EditorPart {
    protected Chart control;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof ChartEditorInput)) {
            throw new PartInitException(NLS.bind((String)Messages.getString("ChartEditor.Editor_input_must_be"), (Object)ChartEditorInput.class.getName()));
        }
        this.setInput(input);
        this.setSite((IWorkbenchPartSite)site);
        this.setPartName(NLS.bind((String)Messages.getString("ChartEditor.Heap_Chart"), (Object)input.getName()));
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        final ChartEditorInput input = (ChartEditorInput)this.getEditorInput();
        final HeapChart heapChart = input.getChart();
        this.control = new Chart(parent, 4);
        heapChart.setChartControl((Composite)this.control);
        Color LIGHTYELLOW = new Color((Device)Display.getDefault(), 255, 255, 225);
        Color WHITE = new Color((Device)Display.getDefault(), 255, 255, 255);
        Color BLACK = new Color((Device)Display.getDefault(), 0, 0, 0);
        Color RED = new Color((Device)Display.getDefault(), 255, 0, 0);
        Color ORANGE = new Color((Device)Display.getDefault(), 255, 165, 0);
        Color GREEN = new Color((Device)Display.getDefault(), 0, 255, 0);
        Color DARK_BLUE = new Color((Device)Display.getDefault(), 64, 128, 128);
        this.control.setBackground(WHITE);
        this.control.setBackgroundInPlotArea(LIGHTYELLOW);
        FontData fd = JFaceResources.getDialogFont().getFontData()[0];
        fd.setStyle(1);
        Font font = new Font((Device)Display.getDefault(), fd);
        fd.setHeight(fd.getHeight() + 2);
        Font titleFont = new Font((Device)Display.getDefault(), fd);
        ITitle title = this.control.getTitle();
        title.setFont(titleFont);
        title.setForeground(BLACK);
        title.setText(heapChart.title);
        IAxis xAxis = this.control.getAxisSet().getXAxis(0);
        xAxis.getGrid().setStyle(LineStyle.NONE);
        xAxis.getTick().setForeground(BLACK);
        ITitle xTitle = xAxis.getTitle();
        xTitle.setFont(font);
        xTitle.setForeground(BLACK);
        xTitle.setText(heapChart.xUnits);
        IAxis yAxis = this.control.getAxisSet().getYAxis(0);
        yAxis.getGrid().setStyle(LineStyle.SOLID);
        yAxis.getTick().setForeground(BLACK);
        yAxis.getTick().setTickMarkStepHint(40);
        ITitle yTitle = yAxis.getTitle();
        yTitle.setFont(font);
        yTitle.setText(heapChart.yUnits);
        yTitle.setForeground(BLACK);
        this.control.getLegend().setPosition(1024);
        final ILineSeries lsUseful = (ILineSeries)this.control.getSeriesSet().createSeries(ISeries.SeriesType.LINE, Messages.getString("HeapChart.Useful_Heap"));
        lsUseful.setXSeries(heapChart.time);
        lsUseful.setYSeries(heapChart.dataUseful);
        lsUseful.setSymbolType(ILineSeries.PlotSymbolType.DIAMOND);
        lsUseful.setSymbolColor(RED);
        lsUseful.setLineColor(RED);
        final ILineSeries lsExtra = (ILineSeries)this.control.getSeriesSet().createSeries(ISeries.SeriesType.LINE, Messages.getString("HeapChart.Extra_Heap"));
        lsExtra.setXSeries(heapChart.time);
        lsExtra.setYSeries(heapChart.dataExtra);
        lsExtra.setSymbolType(ILineSeries.PlotSymbolType.DIAMOND);
        lsExtra.setSymbolColor(ORANGE);
        lsExtra.setLineColor(ORANGE);
        if (heapChart.dataStacks != null) {
            ILineSeries lsStack = (ILineSeries)this.control.getSeriesSet().createSeries(ISeries.SeriesType.LINE, Messages.getString("HeapChart.Stacks"));
            lsStack.setXSeries(heapChart.time);
            lsStack.setYSeries(heapChart.dataStacks);
            lsStack.setSymbolType(ILineSeries.PlotSymbolType.DIAMOND);
            lsStack.setSymbolColor(DARK_BLUE);
            lsStack.setLineColor(DARK_BLUE);
        }
        final ILineSeries lsTotal = (ILineSeries)this.control.getSeriesSet().createSeries(ISeries.SeriesType.LINE, Messages.getString("HeapChart.Total_Heap"));
        lsTotal.setXSeries(heapChart.time);
        lsTotal.setYSeries(heapChart.dataTotal);
        lsTotal.setSymbolType(ILineSeries.PlotSymbolType.DIAMOND);
        lsTotal.setSymbolColor(GREEN);
        lsTotal.setLineColor(GREEN);
        this.control.getAxisSet().adjustRange();
        IAxisSet axisSet = this.control.getAxisSet();
        Range xRange = axisSet.getXAxis(0).getRange();
        Range yRange = axisSet.getYAxis(0).getRange();
        double xExtra = 0.05 * (xRange.upper - xRange.lower);
        double yExtra = 0.05 * (yRange.upper - yRange.lower);
        axisSet.getXAxis(0).setRange(new Range(xRange.lower, xRange.upper + xExtra));
        axisSet.getYAxis(0).setRange(new Range(yRange.lower, yRange.upper + yExtra));
        this.control.getPlotArea().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                ChartEditor.this.showView();
                TableViewer viewer = input.getView().getTableViewer();
                input.getView().setTopControl(viewer.getControl());
                Point p = new Point(e.x, e.y);
                int closest = 0;
                double globalMin = Double.MAX_VALUE;
                int i = 0;
                while (i < heapChart.time.length) {
                    double d1 = ChartEditor.this.distance(lsUseful.getPixelCoordinates(i), p);
                    double d2 = ChartEditor.this.distance(lsExtra.getPixelCoordinates(i), p);
                    double d3 = ChartEditor.this.distance(lsTotal.getPixelCoordinates(i), p);
                    double currMin = Math.min(Math.min(d1, d2), d3);
                    if (currMin < globalMin) {
                        closest = i;
                        globalMin = currMin;
                    }
                    ++i;
                }
                MassifSnapshot snapshot = (MassifSnapshot)viewer.getElementAt(closest);
                viewer.setSelection((ISelection)new StructuredSelection((Object)snapshot));
                if (e.count == 2 && snapshot.isDetailed()) {
                    ChartLocationsDialog dialog = new ChartLocationsDialog(Display.getCurrent().getActiveShell());
                    dialog.setInput(snapshot);
                    if (dialog.open() == 0) {
                        dialog.openEditorForResult();
                    }
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    public Chart getControl() {
        return this.control;
    }

    public void setFocus() {
        if (this.control != null) {
            this.control.setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        this.control.dispose();
    }

    public void showView() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    activePage.showView("org.eclipse.linuxtools.valgrind.ui.valgrindview");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private double distance(Point p1, Point p2) {
        return Math.sqrt(Math.pow(p1.x - p2.x, 2.0) + Math.pow(p1.y - p2.y, 2.0));
    }
}

