/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.consolelog.structures;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import org.eclipse.linuxtools.systemtap.ui.consolelog.dialogs.ErrorMessage;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.DMPacket;

public class DMResponse
extends DMPacket {
    public static final int packetsize = 24;
    public static final int STDOUT = 1;
    public static final int STDERR = 2;
    public static final int SUBSCRIPTION_MGR = 3;
    public static final int DATA_MGR = 4;
    public static final int MAILBOX = 5;
    private int returnCode;
    private int source;
    private boolean valid;
    private byte[] bacopy;

    public DMResponse(byte[] ba) {
        if (ba.length != 24) {
            this.valid = false;
            return;
        }
        this.bacopy = ba;
        ByteArrayInputStream bais = new ByteArrayInputStream(ba);
        DataInputStream dis = new DataInputStream(bais);
        int headerID = 0;
        try {
            headerID = dis.readInt();
            this.source = dis.readInt();
            this.scriptID = dis.readInt();
            this.clientID = dis.readInt();
            this.returnCode = dis.readInt();
            this.size = dis.readInt();
        }
        catch (EOFException eofe) {
            this.valid = false;
            new ErrorMessage("Response packet error!", "See stderr for more details").open();
            System.err.println("response packet Error: " + eofe.getMessage());
        }
        catch (IOException ioe) {
            this.valid = false;
            new ErrorMessage("Response packet error!", "See stderr for more details").open();
            System.err.println("response packet Error: " + ioe.getMessage());
        }
        this.valid = headerID == -1582119980;
    }

    public int getsource() {
        return this.source;
    }

    public int getreturnCode() {
        return this.returnCode;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String toString() {
        return "ID String:\t-1582119980\nSource:\t" + this.source + "\nScript #:\t" + this.scriptID + "\nClient ID:\t" + this.clientID + "\nData Size:\t" + this.size + "\nReturn Code:\t" + this.returnCode + "\n";
    }

    public byte[] tobytes() {
        return this.bacopy;
    }
}

