/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.util;

import org.eclipse.help.IIndex;
import org.eclipse.help.IIndexEntry;
import org.eclipse.help.IIndexSee;
import org.eclipse.help.IIndexSubpath;
import org.eclipse.help.IUAElement;
import org.eclipse.help.internal.UAElement;

public class IndexUtils {
    public static IIndexEntry[] findSeeTargets(IUAElement index, IIndexSee see, int depth) {
        IUAElement[] children;
        if (index == null && see instanceof UAElement) {
            UAElement ancestor = ((UAElement)see).getParentElement();
            while (!(ancestor instanceof IIndex)) {
                if (ancestor == null) {
                    return new IIndexEntry[0];
                }
                ancestor = ancestor.getParentElement();
            }
            index = ancestor;
        }
        String[] path = IndexUtils.getPath(see);
        IUAElement[] iUAElementArray = children = index.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexEntry indexEntry;
            String entryKeyword;
            IUAElement element = iUAElementArray[n2];
            if (element instanceof IIndexEntry && path[depth].equals(entryKeyword = (indexEntry = (IIndexEntry)element).getKeyword())) {
                if (path.length == depth + 1) {
                    return new IIndexEntry[]{indexEntry};
                }
                IIndexEntry[] targets = IndexUtils.findSeeTargets((IUAElement)indexEntry, see, depth + 1);
                IIndexEntry[] result = new IIndexEntry[targets.length + 1];
                result[0] = indexEntry;
                System.arraycopy(targets, 0, result, 1, targets.length);
                return result;
            }
            ++n2;
        }
        return new IIndexEntry[0];
    }

    public static String[] getPath(IIndexSee see) {
        IIndexSubpath[] subpaths = see.getSubpathElements();
        String[] result = new String[1 + subpaths.length];
        result[0] = see.getKeyword();
        int i = 0;
        while (i < subpaths.length) {
            result[i + 1] = subpaths[i].getKeyword();
            ++i;
        }
        return result;
    }
}

