/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.Command;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.IRelayCommand;

public class ViewerCommand
implements IRelayCommand {
    public static final int SIZE = 16;
    private final long fDataSize;
    private final Command fCmd;
    private final int fCmdVersion;

    public ViewerCommand(Command viewerConnect, long size, int version) {
        this.fCmd = viewerConnect;
        this.fDataSize = size;
        this.fCmdVersion = version;
    }

    public long getDataSize() {
        return this.fDataSize;
    }

    public Command getCmd() {
        return this.fCmd;
    }

    public int getCmdVersion() {
        return this.fCmdVersion;
    }

    @Override
    public byte[] serialize() {
        byte[] data = new byte[16];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.order(ByteOrder.BIG_ENDIAN);
        bb.putLong(this.getDataSize());
        bb.putInt(this.getCmd().getCommand());
        bb.putInt(this.fCmdVersion);
        return data;
    }
}

