/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import org.eclipse.cdt.ui.dialogs.IInputStatusValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InputStatusDialog
extends StatusDialog {
    private String title;
    private String message;
    private String value = "";
    private IInputStatusValidator validator;
    private Text text;

    public InputStatusDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputStatusValidator validator) {
        super(parentShell);
        this.title = dialogTitle;
        this.message = dialogMessage == null ? "" : dialogMessage;
        this.value = initialValue == null ? "" : initialValue;
        this.validator = validator;
    }

    protected void buttonPressed(int buttonId) {
        this.value = buttonId == 0 ? this.text.getText() : null;
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 64);
        label.setText(this.message);
        GridData data = new GridData(1796);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        this.text = new Text(composite, this.getInputTextStyle());
        this.text.setLayoutData((Object)new GridData(768));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputStatusDialog.this.validateInput();
            }
        });
        this.text.setFocus();
        if (this.value != null) {
            this.text.setText(this.value);
            this.text.selectAll();
        }
        InputStatusDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Text getText() {
        return this.text;
    }

    protected IInputStatusValidator getValidator() {
        return this.validator;
    }

    public String getValue() {
        return this.value;
    }

    protected void validateInput() {
        IStatus status = Status.OK_STATUS;
        if (this.validator != null) {
            status = this.validator.isValid(this.text.getText());
        }
        this.updateStatus(status);
    }

    protected int getInputTextStyle() {
        return 2052;
    }
}

