/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.externalization;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.core.ITransferList;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.externalization.SaxTaskListElementBuilder;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.xml.sax.Attributes;

public class SaxQueryBuilder
extends SaxTaskListElementBuilder<RepositoryQuery> {
    private RepositoryQuery query;
    private final RepositoryModel repositoryModel;
    private final IRepositoryManager repositoryManager;

    public SaxQueryBuilder(RepositoryModel repositoryModel, IRepositoryManager repositoryManager) {
        this.repositoryModel = repositoryModel;
        this.repositoryManager = repositoryManager;
    }

    @Override
    public void beginItem(Attributes elementAttributes) {
        try {
            String repositoryUrl = StringUtils.defaultString((String)elementAttributes.getValue("RepositoryUrl"));
            String connectorKind = StringUtils.defaultString((String)elementAttributes.getValue("ConnectorKind"));
            if (this.repositoryManager.getRepositoryConnector(connectorKind) == null) {
                this.addError((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", String.format("Unable to read query, missing connector with kind \"%s\"", connectorKind)));
                return;
            }
            this.query = this.readDefaultQuery(connectorKind, repositoryUrl);
            this.readQueryAttributes(elementAttributes);
        }
        catch (Exception e) {
            this.addError((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", String.format("Exception reading query: %s", e.getMessage()), (Throwable)e));
        }
    }

    private RepositoryQuery readDefaultQuery(String connectorKind, String repositoryUrl) {
        TaskRepository taskRepository = this.repositoryModel.getTaskRepository(connectorKind, repositoryUrl);
        RepositoryQuery query = (RepositoryQuery)this.repositoryModel.createRepositoryQuery(taskRepository);
        return query;
    }

    private void readQueryAttributes(Attributes elementAttributes) {
        String label;
        String handle = elementAttributes.getValue("Handle");
        if (StringUtils.isNotEmpty((CharSequence)handle)) {
            this.query.setHandleIdentifier(handle);
        }
        if (StringUtils.isEmpty((CharSequence)(label = elementAttributes.getValue("Name")))) {
            label = StringUtils.defaultString((String)elementAttributes.getValue("Label"));
        }
        this.query.setSummary(label);
        String queryString = StringUtils.defaultString((String)elementAttributes.getValue("QueryString"));
        if (StringUtils.isEmpty((CharSequence)queryString)) {
            queryString = StringUtils.defaultString((String)elementAttributes.getValue("Query"));
        }
        this.query.setUrl(queryString);
        String lastRefresh = elementAttributes.getValue("LastRefreshTimeStamp");
        if (StringUtils.isNotEmpty((CharSequence)lastRefresh)) {
            this.query.setLastSynchronizedStamp(lastRefresh);
        }
    }

    @Override
    protected void applyAttribute(String attributeKey, String attributeValue) {
        this.getItem().setAttribute(attributeKey, attributeValue);
    }

    @Override
    public RepositoryQuery getItem() {
        return this.query;
    }

    @Override
    public void addToTaskList(ITransferList taskList) {
        taskList.addQuery(this.query);
    }
}

