/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;

public final class StringUtils {
    private static final Pattern RRGGBB = Pattern.compile("^#[0-9a-f]{6}", 2);
    private static final Pattern RRGGBBAA = Pattern.compile("^#[0-9a-f]{8}", 2);
    private static final Pattern RGB = Pattern.compile("^#[0-9a-f]{3}", 2);
    private static final Pattern RGBA = Pattern.compile("^#[0-9a-f]{4}", 2);
    private static volatile @Nullable Pattern CONTAINS_RTL;
    private static final List<String> LIST_WITH_EMPTY_STRING;

    static {
        LIST_WITH_EMPTY_STRING = List.of("");
    }

    public static int strcmp(String a, String b) {
        int result = a.compareTo(b);
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    public static int strArrCmp(@Nullable List<String> a, @Nullable List<String> b) {
        int len2;
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        int len1 = a.size();
        if (len1 == (len2 = b.size())) {
            int i = 0;
            while (i < len1) {
                int res = StringUtils.strcmp(a.get(i), b.get(i));
                if (res != 0) {
                    return res;
                }
                ++i;
            }
            return 0;
        }
        return len1 - len2;
    }

    public static boolean isValidHexColor(CharSequence hex) {
        if (hex.isEmpty()) {
            return false;
        }
        if (RRGGBB.matcher(hex).matches()) {
            return true;
        }
        if (RRGGBBAA.matcher(hex).matches()) {
            return true;
        }
        if (RGB.matcher(hex).matches()) {
            return true;
        }
        return RGBA.matcher(hex).matches();
    }

    private static Pattern makeContainsRtl() {
        return Pattern.compile("(?:[\\u05BE\\u05C0\\u05C3\\u05C6\\u05D0-\\u05F4\\u0608\\u060B\\u060D\\u061B-\\u064A\\u066D-\\u066F\\u0671-\\u06D5\\u06E5\\u06E6\\u06EE\\u06EF\\u06FA-\\u0710\\u0712-\\u072F\\u074D-\\u07A5\\u07B1-\\u07EA\\u07F4\\u07F5\\u07FA\\u07FE-\\u0815\\u081A\\u0824\\u0828\\u0830-\\u0858\\u085E-\\u088E\\u08A0-\\u08C9\\u200F\\uFB1D\\uFB1F-\\uFB28\\uFB2A-\\uFD3D\\uFD50-\\uFDC7\\uFDF0-\\uFDFC\\uFE70-\\uFEFC]|\\uD802[\\uDC00-\\uDD1B\\uDD20-\\uDE00\\uDE10-\\uDE35\\uDE40-\\uDEE4\\uDEEB-\\uDF35\\uDF40-\\uDFFF]|\\uD803[\\uDC00-\\uDD23\\uDE80-\\uDEA9\\uDEAD-\\uDF45\\uDF51-\\uDF81\\uDF86-\\uDFF6]|\\uD83A[\\uDC00-\\uDCCF\\uDD00-\\uDD43\\uDD4B-\\uDFFF]|\\uD83B[\\uDC00-\\uDEBB])");
    }

    public static boolean containsRTL(String str) {
        Pattern p = CONTAINS_RTL;
        if (p == null) {
            p = CONTAINS_RTL = StringUtils.makeContainsRtl();
        }
        return p.matcher(str).find();
    }

    public static boolean isNullOrEmpty(@Nullable String txt) {
        return txt == null || txt.isEmpty();
    }

    public static String nullToEmpty(@Nullable String txt) {
        return txt == null ? "" : txt;
    }

    public static String[] splitToArray(String line, char separator) {
        return StringUtils.splitToArray(line, separator, -1);
    }

    public static String[] splitToArray(String line, char separator, int limit) {
        String[] tmp2;
        if (line.isEmpty()) {
            return new String[]{""};
        }
        String[] tmp = new String[8];
        int count = 0;
        int start = 0;
        int end = line.indexOf(separator, 0);
        while (end >= 0) {
            if (count == tmp.length) {
                tmp2 = new String[tmp.length + (tmp.length >> 1)];
                System.arraycopy(tmp, 0, tmp2, 0, count);
                tmp = tmp2;
            }
            tmp[count] = line.substring(start, end);
            start = end + 1;
            if (++count == limit) break;
            end = line.indexOf(separator, start);
        }
        if (count == tmp.length) {
            tmp2 = new String[tmp.length + 1];
            System.arraycopy(tmp, 0, tmp2, 0, count);
            tmp = tmp2;
        }
        tmp[count] = line.substring(start);
        if (++count == tmp.length) {
            return tmp;
        }
        String[] result = new String[count];
        System.arraycopy(tmp, 0, result, 0, count);
        return result;
    }

    public static List<String> splitToList(String line, char separator) {
        if (line.isEmpty()) {
            return LIST_WITH_EMPTY_STRING;
        }
        ArrayList<String> result = new ArrayList<String>(8);
        int start = 0;
        int end = line.indexOf(separator, 0);
        while (end >= 0) {
            result.add(line.substring(start, end));
            start = end + 1;
            end = line.indexOf(separator, start);
        }
        result.add(line.substring(start));
        return result;
    }

    public static String substringBefore(String searchIn, char searchFor, String defaultValue) {
        int foundAt = searchIn.indexOf(searchFor);
        return foundAt == -1 ? defaultValue : searchIn.substring(0, foundAt);
    }

    public static String toString(@Nullable Object object, Consumer<StringBuilder> fieldsBuilder) {
        if (object == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder(object.getClass().getSimpleName());
        sb.append('{');
        fieldsBuilder.accept(sb);
        sb.append('}');
        return sb.toString();
    }

    private StringUtils() {
    }
}

