/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.core.natures.PluginProject;

public class PDEJavaHelper {
    public static boolean isDiscouraged(String fullyQualifiedName, IJavaProject project, BundleDescription desc) {
        ExportPackageDescription[] exports;
        int dot;
        try {
            HashMap<String, IPackageFragment> map;
            IType type = project.findType(fullyQualifiedName.replace('$', '.'));
            if (type != null && type.exists() && (map = PDEJavaHelper.getPackageFragmentsHash(project, Collections.emptyList(), false)).containsValue(type.getPackageFragment())) {
                return false;
            }
        }
        catch (JavaModelException type) {
            // empty catch block
        }
        fullyQualifiedName = (dot = fullyQualifiedName.lastIndexOf(46)) != -1 ? fullyQualifiedName.substring(0, dot) : ".";
        State state = desc.getContainingState();
        StateHelper helper = state.getStateHelper();
        ExportPackageDescription[] exportPackageDescriptionArray = exports = helper.getVisiblePackages(desc);
        int n = exports.length;
        int n2 = 0;
        while (n2 < n) {
            ExportPackageDescription export = exportPackageDescriptionArray[n2];
            BundleDescription exporter = export.getExporter();
            if (exporter != null && fullyQualifiedName.equals(export.getName()) && helper.getAccessCode(desc, export) == 2) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isOnClasspath(String fullyQualifiedName, IJavaProject project) {
        if (fullyQualifiedName.indexOf(36) != -1) {
            fullyQualifiedName = fullyQualifiedName.replace('$', '.');
        }
        try {
            IType type = project.findType(fullyQualifiedName);
            return type != null && type.exists();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public static IJavaSearchScope getSearchScope(IJavaProject project) {
        return SearchEngine.createJavaSearchScope((IJavaElement[])PDEJavaHelper.getNonJRERoots(project));
    }

    public static IJavaSearchScope getSearchScope(IProject project) {
        return PDEJavaHelper.getSearchScope(JavaCore.create((IProject)project));
    }

    public static IPackageFragmentRoot[] getNonJRERoots(IJavaProject project) {
        ArrayList<IPackageFragmentRoot> result = new ArrayList<IPackageFragmentRoot>();
        try {
            IPackageFragmentRoot[] roots = project.getAllPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (!PDEJavaHelper.isJRELibrary(roots[i])) {
                    result.add(roots[i]);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return result.toArray(new IPackageFragmentRoot[result.size()]);
    }

    public static boolean isJRELibrary(IPackageFragmentRoot root) {
        try {
            IPath path = root.getRawClasspathEntry().getPath();
            if (path.equals((Object)IPath.fromOSString((String)JavaRuntime.JRE_CONTAINER)) || path.equals((Object)IPath.fromOSString((String)"JRE_LIB"))) {
                return true;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }

    public static IPackageFragment getPackageFragment(String packageName, String pluginID, IProject project) {
        if (project == null) {
            return PDEJavaHelper.getExternalPackageFragment(packageName, pluginID);
        }
        IJavaProject jp = JavaCore.create((IProject)project);
        if (jp != null) {
            try {
                IPackageFragmentRoot[] roots;
                IPackageFragmentRoot[] iPackageFragmentRootArray = roots = jp.getAllPackageFragmentRoots();
                int n = roots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    IPackageFragment frag = root.getPackageFragment(packageName);
                    if (frag.exists()) {
                        return frag;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return null;
    }

    private static IPackageFragment getExternalPackageFragment(String packageName, String pluginID) {
        IModel base;
        block21: {
            ImportPackageSpecification[] packages;
            IPluginModelBase plugin;
            block20: {
                if (pluginID == null) {
                    return null;
                }
                base = null;
                plugin = PluginRegistry.findModel(pluginID);
                if (plugin != null) break block20;
                return null;
            }
            ImportPackageSpecification[] importPackageSpecificationArray = packages = plugin.getBundleDescription().getImportPackages();
            int n = packages.length;
            int n2 = 0;
            while (n2 < n) {
                ImportPackageSpecification spec = importPackageSpecificationArray[n2];
                if (spec.getName().equals(packageName)) {
                    ExportPackageDescription desc = (ExportPackageDescription)spec.getSupplier();
                    if (desc == null) break;
                    base = PluginRegistry.findModel(desc.getExporter().getSymbolicName());
                    break;
                }
                ++n2;
            }
            if (base != null) break block21;
            return null;
        }
        try {
            IProject proj;
            IJavaProject jp;
            IResource res = base.getUnderlyingResource();
            if (res != null && (jp = JavaCore.create((IProject)res.getProject())) != null) {
                try {
                    IPackageFragmentRoot[] roots;
                    IPackageFragmentRoot[] iPackageFragmentRootArray = roots = jp.getAllPackageFragmentRoots();
                    int n = roots.length;
                    int desc = 0;
                    while (desc < n) {
                        IPackageFragmentRoot root = iPackageFragmentRootArray[desc];
                        IPackageFragment frag = root.getPackageFragment(packageName);
                        if (frag.exists()) {
                            return frag;
                        }
                        ++desc;
                    }
                }
                catch (JavaModelException roots) {
                    // empty catch block
                }
            }
            if ((proj = PDECore.getWorkspace().getRoot().getProject("External Plug-in Libraries")) == null) {
                return PDEJavaHelper.searchWorkspaceForPackage(packageName, (IPluginModelBase)base);
            }
            IJavaProject jp2 = JavaCore.create((IProject)proj);
            IPath path = IPath.fromOSString((String)base.getInstallLocation());
            if (!path.toFile().isDirectory()) {
                IPackageFragment frag;
                IPackageFragmentRoot root = jp2.findPackageFragmentRoot(path);
                if (root != null && (frag = root.getPackageFragment(packageName)).exists()) {
                    return frag;
                }
            } else {
                IPluginLibrary[] libs = base.getPluginBase().getLibraries();
                Map<IPath, IPackageFragmentRoot> rootsByPath = null;
                IPluginLibrary[] iPluginLibraryArray = libs;
                int n = libs.length;
                int n3 = 0;
                while (n3 < n) {
                    IPluginLibrary lib = iPluginLibraryArray[n3];
                    if (!"resource".equals(lib.getType())) {
                        IPackageFragment frag;
                        IPackageFragmentRoot root;
                        String libName = ClasspathUtilCore.expandLibraryName(lib.getName());
                        if (rootsByPath == null) {
                            rootsByPath = PDEJavaHelper.getRootsByPath(jp2);
                        }
                        if ((root = rootsByPath.get(path.append(libName))) != null && (frag = root.getPackageFragment(packageName)).exists()) {
                            return frag;
                        }
                    }
                    ++n3;
                }
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return PDEJavaHelper.searchWorkspaceForPackage(packageName, base);
    }

    private static Map<IPath, IPackageFragmentRoot> getRootsByPath(IJavaProject jp) throws JavaModelException {
        HashMap<IPath, IPackageFragmentRoot> rootsByPath = new HashMap<IPath, IPackageFragmentRoot>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = jp.getAllPackageFragmentRoots();
        int n = iPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot classpathRoot = iPackageFragmentRootArray[n2];
            IPath classRootPath = classpathRoot.getPath();
            if (classRootPath != null) {
                rootsByPath.put(classRootPath, classpathRoot);
            }
            ++n2;
        }
        return rootsByPath;
    }

    private static IPackageFragment searchWorkspaceForPackage(String packageName, IPluginModelBase base) {
        IProject[] projects;
        IPluginLibrary[] libs = base.getPluginBase().getLibraries();
        ArrayList<IPath> libPaths = new ArrayList<IPath>();
        IPath path = IPath.fromOSString((String)base.getInstallLocation());
        if (libs.length == 0) {
            libPaths.add(path);
        }
        IPluginLibrary[] iPluginLibraryArray = libs;
        int n = libs.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginLibrary lib = iPluginLibraryArray[n2];
            if (!"resource".equals(lib.getType())) {
                String libName = ClasspathUtilCore.expandLibraryName(lib.getName());
                libPaths.add(path.append(libName));
            }
            ++n2;
        }
        IProject[] iProjectArray = projects = PDECore.getWorkspace().getRoot().getProjects();
        int n3 = projects.length;
        n = 0;
        while (n < n3) {
            IProject project = iProjectArray[n];
            if (PluginProject.isJavaProject(project)) {
                IJavaProject jp = JavaCore.create((IProject)project);
                try {
                    Map<IPath, IPackageFragmentRoot> rootsByPath = null;
                    for (IPath libPath : libPaths) {
                        IPackageFragment frag;
                        IPackageFragmentRoot root;
                        if (rootsByPath == null) {
                            rootsByPath = PDEJavaHelper.getRootsByPath(jp);
                        }
                        if ((root = rootsByPath.get(libPath)) == null || !(frag = root.getPackageFragment(packageName)).exists()) continue;
                        return frag;
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            ++n;
        }
        return null;
    }

    public static IPackageFragment[] getPackageFragments(IJavaProject jProject, Collection<String> existingPackages, boolean allowJava) {
        HashMap<String, IPackageFragment> map = PDEJavaHelper.getPackageFragmentsHash2(jProject, existingPackages, allowJava);
        return map.values().toArray(new IPackageFragment[map.size()]);
    }

    public static HashMap<String, IPackageFragment> getPackageFragmentsHash(IJavaProject jProject, Collection<String> existingPackages, boolean allowJava) {
        LinkedHashMap<String, IPackageFragment> map = new LinkedHashMap<String, IPackageFragment>();
        try {
            IPackageFragmentRoot[] roots;
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots = PDEJavaHelper.getRoots(jProject);
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement[] children;
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                IJavaElement[] iJavaElementArray = children = root.getChildren();
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    IJavaElement element = iJavaElementArray[n4];
                    IPackageFragment fragment = (IPackageFragment)element;
                    String name = fragment.getElementName();
                    if (name.length() == 0) {
                        name = ".";
                    }
                    if (!(!fragment.hasChildren() && fragment.getNonJavaResources().length <= 0 || existingPackages.contains(name) || name.equals("java") && name.startsWith("java.") && !allowJava)) {
                        map.put(fragment.getElementName(), fragment);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return map;
    }

    public static HashMap<String, IPackageFragment> getPackageFragmentsHash2(IJavaProject jProject, Collection<String> existingPackages, boolean allowJava) {
        LinkedHashMap<String, IPackageFragment> map = new LinkedHashMap<String, IPackageFragment>();
        try {
            IPackageFragmentRoot[] roots;
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots = PDEJavaHelper.getRoots(jProject);
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement[] children;
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                IJavaElement[] iJavaElementArray = children = root.getChildren();
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    IJavaElement element = iJavaElementArray[n4];
                    IPackageFragment fragment = (IPackageFragment)element;
                    String name = fragment.getElementName();
                    if (name.length() == 0) {
                        name = ".";
                    }
                    if (!(!fragment.hasChildren() && fragment.getNonJavaResources().length <= 0 || existingPackages.contains(name) || name.equals("java") && name.startsWith("java.") && !allowJava)) {
                        map.put(String.valueOf(fragment.getPath().makeRelative()) + "_" + fragment.getElementName(), fragment);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return map;
    }

    private static IPackageFragmentRoot[] getRoots(IJavaProject jProject) {
        ArrayList<IPackageFragmentRoot> result = new ArrayList<IPackageFragmentRoot>();
        try {
            IPackageFragmentRoot[] roots = jProject.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (roots[i].getKind() == 1 || jProject.getProject().equals((Object)roots[i].getCorrespondingResource()) || roots[i].isArchive() && !roots[i].isExternal()) {
                    result.add(roots[i]);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return result.toArray(new IPackageFragmentRoot[result.size()]);
    }

    public static String getJavaSourceLevel(IProject project) {
        return PDEJavaHelper.getJavaLevel(project, "org.eclipse.jdt.core.compiler.source");
    }

    public static String getJavaComplianceLevel(IProject project) {
        return PDEJavaHelper.getJavaLevel(project, "org.eclipse.jdt.core.compiler.compliance");
    }

    public static String getJavaLevel(IProject project, String optionName) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        String value = null;
        if (javaProject != null && javaProject.exists() && (value = javaProject.getOption(optionName, true)) != null) {
            return value;
        }
        value = new PDEPreferencesManager("org.eclipse.jdt.core").getString(optionName);
        if (value != null) {
            return value;
        }
        value = JavaCore.getOption((String)optionName);
        if (value != null) {
            return value;
        }
        return "1.3";
    }
}

