/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.util.List;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceInfo;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeCatalogItem;
import org.eclipse.epp.internal.mpc.ui.catalog.UserActionCatalogItem;
import org.eclipse.epp.internal.mpc.ui.wizards.AbstractUserActionItem;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceDiscoveryResources;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplacePage;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.SelectionModel;
import org.eclipse.epp.mpc.ui.Operation;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.Icon;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;

public class InstallUpdatesNotificationItem
extends AbstractUserActionItem {
    private final MarketplacePage marketplacePage;
    private boolean mpcSelfUpdate;
    private boolean generalUpdate;

    public InstallUpdatesNotificationItem(Composite parent, MarketplaceDiscoveryResources resources, UserActionCatalogItem connector, MarketplacePage page) {
        super(parent, resources, connector, page.getViewer());
        this.marketplacePage = page;
    }

    private List<MarketplaceNodeCatalogItem> getAvailableUpdates() {
        return (List)((UserActionCatalogItem)this.connector).getData();
    }

    @Override
    protected void createContent() {
        this.mpcSelfUpdate = this.computeIsMPCSelfUpdate();
        this.generalUpdate = this.computeIsGeneralUpdate();
        super.createContent();
    }

    private boolean computeIsMPCSelfUpdate() {
        List<MarketplaceNodeCatalogItem> availableUpdates = this.getAvailableUpdates();
        for (MarketplaceNodeCatalogItem item : availableUpdates) {
            if (!MarketplaceInfo.isMPCNode(item.getData())) continue;
            return true;
        }
        return false;
    }

    private boolean computeIsGeneralUpdate() {
        List<MarketplaceNodeCatalogItem> availableUpdates = this.getAvailableUpdates();
        return availableUpdates.size() > 1 || !this.mpcSelfUpdate;
    }

    public boolean isMpcSelfUpdate() {
        return this.mpcSelfUpdate;
    }

    public boolean isGeneralUpdate() {
        return this.generalUpdate;
    }

    @Override
    protected boolean alignIconWithName() {
        return true;
    }

    @Override
    protected Icon getIcon() {
        String path = "registry:ACTION_ICON_UPDATE";
        return InstallUpdatesNotificationItem.createIcon(path);
    }

    @Override
    protected String getDescriptionText() {
        return this.isMpcSelfUpdate() ? Messages.InstallUpdatesNotificationItem_MPCUpdateDescription : Messages.InstallUpdatesNotificationItem_GeneralUpdateDescription;
    }

    @Override
    protected String getSublineText() {
        return this.isMpcSelfUpdate() && this.isGeneralUpdate() ? Messages.InstallUpdatesNotificationItem_OtherUpdatesDescription : null;
    }

    @Override
    protected String getNameLabelText() {
        return this.isMpcSelfUpdate() ? Messages.InstallUpdatesNotificationItem_MPCUpdateHeader : Messages.InstallUpdatesNotificationItem_GeneralUpdateHeader;
    }

    @Override
    protected void createButtons(Composite parent) {
        this.createButton(parent, Messages.InstallUpdatesNotificationItem_ShowUpdatesAction, null, 0);
        this.createButton(parent, Messages.InstallUpdatesNotificationItem_UpdateNowAction, null, 1);
    }

    @Override
    protected void buttonPressed(int id) {
        switch (id) {
            case 0: {
                this.marketplacePage.setActiveTab(MarketplaceViewer.ContentType.INSTALLED);
                break;
            }
            case 1: {
                this.triggerUpdate();
            }
        }
    }

    private void triggerUpdate() {
        MarketplaceViewer viewer = this.marketplacePage.getViewer();
        SelectionModel selectionModel = viewer.getSelectionModel();
        for (MarketplaceNodeCatalogItem nodeItem : this.getAvailableUpdates()) {
            if (selectionModel.getSelectedOperation(nodeItem) != Operation.NONE) continue;
            selectionModel.select((CatalogItem)nodeItem, Operation.UPDATE);
        }
        viewer.setSelection((IStructuredSelection)new StructuredSelection(viewer.getCheckedItems()));
        if (!viewer.getSelection().isEmpty()) {
            this.marketplacePage.showNextPage();
        }
    }
}

