/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.ui.internal.propertypage.verifier;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.ui.Messages;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.ResourceMappingFilterExtensionRegistry;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.verifier.AbstractDeploymentAssemblyVerifier;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.verifier.DeploymentAssemblyVerifierData;
import org.eclipse.wst.common.componentcore.ui.propertypage.AddModuleDependenciesPropertiesPage;

public class DefaultDeploymentAssemblyVerifier
extends AbstractDeploymentAssemblyVerifier {
    @Override
    public IStatus verify(DeploymentAssemblyVerifierData data) {
        IStatus status = this.validateResourceMappings(data, null);
        return this.validateMissingReferences(data, status);
    }

    protected IStatus validateResourceMappings(DeploymentAssemblyVerifierData data, IStatus existingStatus) {
        IStatus status = existingStatus != null ? existingStatus : Status.OK_STATUS;
        ArrayList<AddModuleDependenciesPropertiesPage.ComponentResourceProxy> mappings = data.getResourceMappings();
        if (mappings == null) {
            return status;
        }
        int severity = 2;
        String msg = null;
        IProject project = data.getComponent().getProject();
        for (AddModuleDependenciesPropertiesPage.ComponentResourceProxy mapping : mappings) {
            if (ResourceMappingFilterExtensionRegistry.shouldFilter(mapping.source) || project.exists(mapping.source)) continue;
            msg = NLS.bind((String)Messages.ErrorEntryNotFound, (Object)mapping.source);
            status = this.appendStatusMessage(status, msg, severity);
        }
        return status;
    }

    protected IStatus validateMissingReferences(DeploymentAssemblyVerifierData data, IStatus existingStatus) {
        IStatus status = existingStatus != null ? existingStatus : Status.OK_STATUS;
        ArrayList<IVirtualReference> references = data.getCurrentReferences();
        if (references == null) {
            return status;
        }
        int severity = 2;
        String msg = null;
        for (IVirtualReference reference : references) {
            IVirtualComponent vc;
            IPath p;
            if (reference.getReferencedComponent().exists()) continue;
            String name = reference.getReferencedComponent().isBinary() ? ((p = (IPath)(vc = reference.getReferencedComponent()).getAdapter(IPath.class)) == null ? vc.getName() : p.toString()) : reference.getReferencedComponent().getProject().getName();
            msg = NLS.bind((String)Messages.ErrorEntryNotFound, (Object)name);
            status = this.appendStatusMessage(status, msg, severity);
        }
        return status;
    }

    private IStatus appendStatusMessage(IStatus existingStatus, String message, int severity) {
        MultiStatus multiStatus;
        Status newStatus = new Status(severity, "org.eclipse.wst.common.modulecore.ui", message);
        int newSeverity = severity;
        if (existingStatus.getSeverity() > severity) {
            newSeverity = existingStatus.getSeverity();
        }
        if (existingStatus instanceof MultiStatus) {
            multiStatus = (MultiStatus)existingStatus;
            multiStatus.merge((IStatus)newStatus);
        } else {
            if (!existingStatus.isMultiStatus() && existingStatus.isOK()) {
                return newStatus;
            }
            IStatus[] children = new IStatus[]{existingStatus, newStatus};
            multiStatus = new MultiStatus("org.eclipse.wst.common.modulecore.ui", newSeverity, children, null, null);
        }
        return multiStatus;
    }
}

