/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.data;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.mylyn.internal.tasks.core.XmlReaderUtil;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataState;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataStateReader;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataStateWriter;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TaskDataExternalizer {
    private final IRepositoryManager taskRepositoryManager;

    public TaskDataExternalizer(IRepositoryManager taskRepositoryManager) {
        this.taskRepositoryManager = taskRepositoryManager;
    }

    private void migrate(TaskDataState taskDataState) throws IOException {
        if (this.taskRepositoryManager == null) {
            return;
        }
        String connectorKind = taskDataState.getConnectorKind();
        AbstractRepositoryConnector connector = this.taskRepositoryManager.getRepositoryConnector(connectorKind);
        if (connector == null) {
            throw new IOException("No repository connector for kind \"" + connectorKind + "\" found");
        }
        String repositoryUrl = taskDataState.getRepositoryUrl();
        TaskRepository taskRepository = this.taskRepositoryManager.getRepository(connectorKind, repositoryUrl);
        if (taskRepository == null) {
            throw new IOException("Repository \"" + repositoryUrl + "\" not found for kind \"" + connectorKind + "\"");
        }
        AbstractTaskDataHandler taskDataHandler = connector.getTaskDataHandler();
        if (taskDataHandler != null) {
            this.migrate(taskDataState.getLastReadData(), taskRepository, taskDataHandler);
            this.migrate(taskDataState.getRepositoryData(), taskRepository, taskDataHandler);
            this.migrate(taskDataState.getEditsData(), taskRepository, taskDataHandler);
        }
    }

    private void migrate(final TaskData taskData, final TaskRepository taskRepository, final AbstractTaskDataHandler taskDataHandler) {
        if (taskData != null) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    taskDataHandler.migrateTaskData(taskRepository, taskData);
                }
            });
        }
    }

    public TaskDataState readState(InputStream in) throws IOException, SAXException {
        XMLReader parser = XmlReaderUtil.createXmlReader();
        TaskDataStateReader handler = new TaskDataStateReader(this.taskRepositoryManager);
        parser.setContentHandler(handler);
        parser.parse(new InputSource(in));
        TaskDataState taskDataState = handler.getTaskDataState();
        if (taskDataState != null) {
            this.migrate(taskDataState);
        }
        return taskDataState;
    }

    public void writeState(OutputStream out, ITaskDataWorkingCopy state) throws IOException {
        this.writeState(out, state, false);
    }

    private void writeState(OutputStream out, ITaskDataWorkingCopy state, boolean xml11) throws IOException {
        try {
            SAXTransformerFactory transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
            TransformerHandler handler = transformerFactory.newTransformerHandler();
            Transformer serializer = handler.getTransformer();
            if (xml11) {
                serializer.setOutputProperty("version", "1.1");
            }
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.setOutputProperty("indent", "yes");
            ByteArrayOutputStream temp = new ByteArrayOutputStream();
            handler.setResult(new StreamResult(temp));
            TaskDataStateWriter writer = new TaskDataStateWriter(handler);
            writer.write(state);
            out.write(temp.toByteArray());
        }
        catch (TransformerException e) {
            throw new IOException("Error writing task data" + e.getMessageAndLocation());
        }
        catch (SAXException e) {
            if (!xml11 && e.getMessage() != null && (e.getMessage().contains("invalid XML character") || e.getMessage().contains(" \"&#"))) {
                this.writeState(out, state, true);
            }
            throw new IOException("Error writing task data" + e.getMessage());
        }
    }

    public static class Xml11InputStream
    extends FilterInputStream {
        byte[] header = "<?xml version=\"1.1\" encoding=\"UTF-8\"?>".getBytes("US-ASCII");
        int pointer;

        public Xml11InputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        public synchronized void reset() throws IOException {
            throw new IOException();
        }

        @Override
        public synchronized void mark(int readlimit) {
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.pointer < this.header.length) {
                int read = 0;
                while (this.pointer < this.header.length && read < len) {
                    b[off + read] = this.header[this.pointer];
                    this.readByte();
                    ++read;
                    ++this.pointer;
                }
                return read;
            }
            return super.read(b, off, len);
        }

        private void readByte() throws IOException, EOFException {
            if (this.in.read() == -1) {
                throw new EOFException();
            }
        }

        @Override
        public int read() throws IOException {
            if (this.pointer < this.header.length) {
                this.readByte();
                return this.header[this.pointer++];
            }
            return super.read();
        }

        @Override
        public long skip(long n) throws IOException {
            if (this.pointer < this.header.length) {
                long skip = Math.min((long)(this.header.length - this.pointer), n);
                skip = super.skip(skip);
                this.pointer = (int)((long)this.pointer + skip);
                return skip;
            }
            return super.skip(n);
        }
    }
}

