/*
 * Decompiled with CFR 0.152.
 */
package com.overzealous.remark.convert;

import com.overzealous.remark.Options;
import com.overzealous.remark.convert.AbstractNodeHandler;
import com.overzealous.remark.convert.DocumentConverter;
import com.overzealous.remark.convert.NodeHandler;
import com.overzealous.remark.util.BlockWriter;
import com.overzealous.remark.util.StringUtils;
import org.jsoup.nodes.Element;

public class Codeblock
extends AbstractNodeHandler {
    @Override
    public void handleNode(NodeHandler parent, Element node, DocumentConverter converter) {
        Options.FencedCodeBlocks fenced = converter.options.getFencedCodeBlocks();
        if (fenced.isEnabled()) {
            String fence = StringUtils.multiply(fenced.getSeparatorCharacter(), converter.options.fencedCodeBlocksWidth);
            BlockWriter out = converter.output;
            converter.output.startBlock();
            out.println(fence);
            out.write(converter.cleaner.cleanCode(node));
            out.println();
            out.print(fence);
            converter.output.endBlock();
        } else {
            converter.output.startBlock();
            BlockWriter out = new BlockWriter(converter.output).setPrependNewlineString("    ");
            out.write(converter.cleaner.cleanCode(node));
            converter.output.endBlock();
        }
    }
}

