/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.services.extensions.IDocumentColorParticipant;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lsp4j.ColorInformation;
import org.eclipse.lsp4j.ColorPresentation;
import org.eclipse.lsp4j.ColorPresentationParams;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

class XMLDocumentColor {
    private static final Logger LOGGER = Logger.getLogger(XMLDocumentColor.class.getName());
    private final XMLExtensionsRegistry extensionsRegistry;

    public XMLDocumentColor(XMLExtensionsRegistry extensionsRegistry) {
        this.extensionsRegistry = extensionsRegistry;
    }

    public List<ColorInformation> findDocumentColors(DOMDocument xmlDocument, CancelChecker cancelChecker) {
        cancelChecker.checkCanceled();
        ArrayList<ColorInformation> colors = new ArrayList<ColorInformation>();
        for (IDocumentColorParticipant participant : this.extensionsRegistry.getDocumentColorParticipants()) {
            try {
                participant.doDocumentColor(xmlDocument, colors, cancelChecker);
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while processing document color for the participant '" + participant.getClass().getName() + "'.", e);
            }
        }
        cancelChecker.checkCanceled();
        return colors;
    }

    public List<ColorPresentation> getColorPresentations(DOMDocument xmlDocument, ColorPresentationParams params, CancelChecker cancelChecker) {
        cancelChecker.checkCanceled();
        ArrayList<ColorPresentation> presentations = new ArrayList<ColorPresentation>();
        for (IDocumentColorParticipant participant : this.extensionsRegistry.getDocumentColorParticipants()) {
            try {
                participant.doColorPresentations(xmlDocument, params, presentations, cancelChecker);
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while processing color presentation for the participant '" + participant.getClass().getName() + "'.", e);
            }
        }
        cancelChecker.checkCanceled();
        return presentations;
    }
}

