/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.commands;

import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAdapter;
import org.eclipse.wst.xsd.ui.internal.common.commands.BaseCommand;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDVariety;

public class SetBaseTypeCommand
extends BaseCommand {
    XSDConcreteComponent concreteComponent;
    XSDTypeDefinition baseType;
    XSDBaseAdapter adapter;

    public SetBaseTypeCommand(XSDConcreteComponent concreteComponent, XSDTypeDefinition baseType) {
        super(Messages._UI_ACTION_SET_BASE_TYPE);
        this.concreteComponent = concreteComponent;
        this.baseType = baseType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        try {
            this.beginRecording(this.concreteComponent.getElement());
            if (this.concreteComponent instanceof XSDComplexTypeDefinition) {
                XSDComplexTypeContent contentType;
                XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)this.concreteComponent;
                XSDComplexTypeContent xSDComplexTypeContent = contentType = this.baseType instanceof XSDComplexTypeDefinition ? ((XSDComplexTypeDefinition)this.baseType).getContentType() : null;
                if (this.baseType instanceof XSDSimpleTypeDefinition || contentType != null && contentType instanceof XSDSimpleTypeDefinition) {
                    if (!(complexType.getContent() instanceof XSDSimpleTypeDefinition)) {
                        XSDSimpleTypeDefinition simpleContent = XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
                        complexType.setContent((XSDComplexTypeContent)simpleContent);
                    }
                } else if (this.baseType instanceof XSDComplexTypeDefinition && !(complexType.getContent() instanceof XSDComplexTypeDefinition)) {
                    XSDComplexTypeDefinition complexContent = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
                    complexType.setContent(complexContent.getContent());
                }
                complexType.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
                complexType.setBaseTypeDefinition(this.baseType);
                complexType.updateElement(true);
                this.formatChild(complexType.getElement());
            } else if (this.concreteComponent instanceof XSDSimpleTypeDefinition) {
                XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)this.concreteComponent;
                if (this.baseType instanceof XSDSimpleTypeDefinition) {
                    XSDVariety variety = simpleType.getVariety();
                    if (variety.getValue() == 0) {
                        simpleType.setBaseTypeDefinition((XSDSimpleTypeDefinition)this.baseType);
                    } else if (variety.getValue() == 2) {
                        simpleType.getMemberTypeDefinitions().add((Object)this.baseType);
                    } else if (variety.getValue() == 1) {
                        simpleType.setItemTypeDefinition((XSDSimpleTypeDefinition)this.baseType);
                    }
                }
            }
            Object var4_9 = null;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.endRecording();
            throw throwable;
        }
        this.endRecording();
    }
}

