/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.mylyn.context.core.IDegreeOfInterest;
import org.eclipse.mylyn.context.core.IInteractionContextScaling;
import org.eclipse.mylyn.internal.context.core.DegreeOfInterest;
import org.eclipse.mylyn.monitor.core.InteractionEvent;

public class CompositeDegreeOfInterest
implements IDegreeOfInterest {
    private final Set<IDegreeOfInterest> composed = new HashSet<IDegreeOfInterest>();
    protected IInteractionContextScaling contextScaling;

    public CompositeDegreeOfInterest(IInteractionContextScaling contextScaling) {
        this.contextScaling = contextScaling;
    }

    public void addEvent(InteractionEvent event) {
        for (IDegreeOfInterest info : this.composed) {
            ((DegreeOfInterest)info).addEvent(event);
        }
    }

    @Override
    public List<InteractionEvent> getEvents() {
        HashSet<InteractionEvent> events = new HashSet<InteractionEvent>();
        for (IDegreeOfInterest info : this.composed) {
            events.addAll(info.getEvents());
        }
        return new ArrayList<InteractionEvent>(events);
    }

    @Override
    public float getValue() {
        float value = 0.0f;
        for (IDegreeOfInterest info : this.composed) {
            value += info.getValue();
        }
        return value;
    }

    @Override
    public float getDecayValue() {
        float value = 0.0f;
        for (IDegreeOfInterest info : this.composed) {
            value += info.getDecayValue();
        }
        return value;
    }

    @Override
    public float getEncodedValue() {
        float value = 0.0f;
        for (IDegreeOfInterest info : this.composed) {
            value += info.getEncodedValue();
        }
        return value;
    }

    @Override
    public boolean isInteresting() {
        boolean isInteresting = false;
        for (IDegreeOfInterest info : this.composed) {
            if (!info.isInteresting()) continue;
            isInteresting = true;
        }
        return isInteresting;
    }

    @Override
    public boolean isPropagated() {
        if (this.composed.isEmpty()) {
            return false;
        }
        boolean allPropagated = true;
        for (IDegreeOfInterest info : this.composed) {
            if (info.isPropagated()) continue;
            allPropagated = false;
        }
        return allPropagated;
    }

    @Override
    public boolean isPredicted() {
        if (this.composed.isEmpty()) {
            return false;
        }
        boolean allPredicted = true;
        for (IDegreeOfInterest info : this.composed) {
            if (info.isPredicted()) continue;
            allPredicted = false;
        }
        return allPredicted;
    }

    @Override
    public boolean isLandmark() {
        return this.getValue() >= this.contextScaling.getLandmark();
    }

    public Set<IDegreeOfInterest> getComposedDegreesOfInterest() {
        return this.composed;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("composite(");
        for (IDegreeOfInterest info : this.composed) {
            result.append(info.toString());
        }
        result.append(")");
        return result.toString();
    }
}

