/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.xotcl.core.tests.parser;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.internal.parser.TclSourceParser;

public class XOTclParserUtilTests
extends TestCase {
    public void testParseUtil001() throws Throwable {
        String content = "namespace eval c  {\n}\nnamespace eval a {\n\tnamespace eval b {\n\t\tproc ::c::d { } {\n\t\t}\n\t}\n}\n";
        ModuleDeclaration module = this.parser(content);
        ASTNode[] nodes = this.findNodeByName(module, "::c::d");
        XOTclParserUtilTests.assertEquals((int)1, (int)nodes.length);
        ASTNode node = nodes[0];
        TypeDeclaration type = TclParseUtil.findTclTypeDeclarationFrom((ModuleDeclaration)module, (ASTNode)node);
        XOTclParserUtilTests.assertNotNull((Object)type);
        XOTclParserUtilTests.assertEquals((String)"c", (String)type.getName());
        List levelsTo = TclParseUtil.findLevelsTo((ModuleDeclaration)module, (ASTNode)type);
        XOTclParserUtilTests.assertEquals((int)2, (int)levelsTo.size());
    }

    public void testParseUtil002() throws Throwable {
        String content = "namespace eval c  {\n}\nnamespace eval a {\n\tnamespace eval b {\n\t\tproc ::c::d { } {\n\t\t}\n\t}\n}\n";
        ModuleDeclaration module = this.parser(content);
        ASTNode[] nodes = this.findNodeByName(module, "::c::d");
        XOTclParserUtilTests.assertEquals((int)1, (int)nodes.length);
        ASTNode node = nodes[0];
        TypeDeclaration type = TclParseUtil.findTclTypeDeclarationFrom((ModuleDeclaration)module, (ASTNode)node);
        XOTclParserUtilTests.assertNotNull((Object)type);
        XOTclParserUtilTests.assertEquals((String)"c", (String)type.getName());
        List levelsTo = TclParseUtil.findLevelsTo((ModuleDeclaration)module, (ASTNode)type);
        XOTclParserUtilTests.assertEquals((int)2, (int)levelsTo.size());
    }

    public void testParseUtil003() throws Throwable {
        String content = "namespace eval c  {\n\tnamespace eval d {\n\t}\n}\nnamespace eval a {\n\tnamespace eval b {\n\t\tproc ::c::d::q { } {\n\t\t}\n\t}\n}\n";
        ModuleDeclaration module = this.parser(content);
        ASTNode[] nodes = this.findNodeByName(module, "::c::d::q");
        XOTclParserUtilTests.assertEquals((int)1, (int)nodes.length);
        ASTNode node = nodes[0];
        TypeDeclaration type = TclParseUtil.findTclTypeDeclarationFrom((ModuleDeclaration)module, (ASTNode)node);
        XOTclParserUtilTests.assertNotNull((Object)type);
        XOTclParserUtilTests.assertEquals((String)"d", (String)type.getName());
        List levelsTo = TclParseUtil.findLevelsTo((ModuleDeclaration)module, (ASTNode)type);
        XOTclParserUtilTests.assertEquals((int)3, (int)levelsTo.size());
    }

    public void testParseUtil004() throws Throwable {
        String content = "namespace eval c  {\n\tnamespace eval d {\n\t}\n}\nnamespace eval a {\n\tnamespace eval b {\n\t\tproc ::c::d::q { } {\n\t\t}\n\t}\n}\n";
        ModuleDeclaration module = this.parser(content);
        ASTNode[] nodes = this.findNodeByName(module, "::c::d::q");
        XOTclParserUtilTests.assertEquals((int)1, (int)nodes.length);
        ASTNode node = nodes[0];
        TypeDeclaration type = TclParseUtil.findTclTypeDeclarationFrom((ModuleDeclaration)module, (ASTNode)node);
        XOTclParserUtilTests.assertNotNull((Object)type);
        XOTclParserUtilTests.assertEquals((String)"d", (String)type.getName());
        List levelsTo = TclParseUtil.findLevelsTo((ModuleDeclaration)module, (ASTNode)type);
        XOTclParserUtilTests.assertEquals((int)3, (int)levelsTo.size());
    }

    public void testParseUtil005() throws Throwable {
        String content = "namespace eval c  {\n\tnamespace eval d {\n\t}\n}\nnamespace eval a {\n\tnamespace eval c {\n\t}\n\tnamespace eval b {\n\t\tproc ::c::d::q { } {\n\t\t}\n\t}\n}\n";
        ModuleDeclaration module = this.parser(content);
        ASTNode[] nodes = this.findNodeByName(module, "::c::d::q");
        XOTclParserUtilTests.assertEquals((int)1, (int)nodes.length);
        ASTNode node = nodes[0];
        TypeDeclaration type = TclParseUtil.findTclTypeDeclarationFrom((ModuleDeclaration)module, (ASTNode)node);
        XOTclParserUtilTests.assertNotNull((Object)type);
        XOTclParserUtilTests.assertEquals((String)"d", (String)type.getName());
        List levelsTo = TclParseUtil.findLevelsTo((ModuleDeclaration)module, (ASTNode)type);
        XOTclParserUtilTests.assertEquals((int)3, (int)levelsTo.size());
    }

    public void testParseUtil006() throws Throwable {
        String content = "namespace eval c  {\n\tnamespace eval d {\n\t}\n}\nnamespace eval a {\n\tnamespace eval c {\n\t\tnamespace eval d {\n\t\t}\n\t}\n\tnamespace eval b {\n\t\tproc ::c::d::q { } {\n\t\t}\n\t}\n}\n";
        ModuleDeclaration module = this.parser(content);
        ASTNode[] nodes = this.findNodeByName(module, "::c::d::q");
        XOTclParserUtilTests.assertEquals((int)1, (int)nodes.length);
        ASTNode node = nodes[0];
        TypeDeclaration type = TclParseUtil.findTclTypeDeclarationFrom((ModuleDeclaration)module, (ASTNode)node);
        XOTclParserUtilTests.assertNotNull((Object)type);
        XOTclParserUtilTests.assertEquals((String)"d", (String)type.getName());
        List levelsTo = TclParseUtil.findLevelsTo((ModuleDeclaration)module, (ASTNode)type);
        XOTclParserUtilTests.assertEquals((int)3, (int)levelsTo.size());
    }

    public void testParseUtil007() throws Throwable {
        String content = "namespace eval c::d  {\n}\nnamespace eval a {\n\tnamespace eval b {\n\t\tproc ::c::d::q { } {\n\t\t}\n\t}\n}\n";
        ModuleDeclaration module = this.parser(content);
        ASTNode[] nodes = this.findNodeByName(module, "::c::d::q");
        XOTclParserUtilTests.assertEquals((int)1, (int)nodes.length);
        ASTNode node = nodes[0];
        TypeDeclaration type = TclParseUtil.findTclTypeDeclarationFrom((ModuleDeclaration)module, (ASTNode)node);
        XOTclParserUtilTests.assertNotNull((Object)type);
        XOTclParserUtilTests.assertEquals((String)"c::d", (String)type.getName());
        List levelsTo = TclParseUtil.findLevelsTo((ModuleDeclaration)module, (ASTNode)type);
        XOTclParserUtilTests.assertEquals((int)2, (int)levelsTo.size());
    }

    public void testParseUtil008() throws Throwable {
        String content = "namespace eval c::d  {\n}\nnamespace eval a {\n\tnamespace eval b {\n\t\tnamespace eval c::d {\n\t\t}\n\t\tproc c::d::q { } {\n\t\t}\n\t}\n}\n";
        ModuleDeclaration module = this.parser(content);
        ASTNode[] nodes = this.findNodeByName(module, "c::d::q");
        XOTclParserUtilTests.assertEquals((int)1, (int)nodes.length);
        ASTNode node = nodes[0];
        TypeDeclaration type = TclParseUtil.findTclTypeDeclarationFrom((ModuleDeclaration)module, (ASTNode)node);
        XOTclParserUtilTests.assertNotNull((Object)type);
        XOTclParserUtilTests.assertEquals((String)"c::d", (String)type.getName());
        List levelsTo = TclParseUtil.findLevelsTo((ModuleDeclaration)module, (ASTNode)type);
        XOTclParserUtilTests.assertEquals((int)4, (int)levelsTo.size());
    }

    public void testParseUtil009() throws Throwable {
        String content = "namespace eval c::d  {\n}\nnamespace eval a {\n\tnamespace eval c::d {\n\t}\n\tnamespace eval b {\n\t\tnamespace eval c::d {\n\t\t}\n\t\tproc c::d::q { } {\n\t\t}\n\t}\n}\n";
        ModuleDeclaration module = this.parser(content);
        ASTNode[] nodes = this.findNodeByName(module, "c::d::q");
        XOTclParserUtilTests.assertEquals((int)1, (int)nodes.length);
        ASTNode node = nodes[0];
        TypeDeclaration type = TclParseUtil.findTclTypeDeclarationFrom((ModuleDeclaration)module, (ASTNode)node);
        XOTclParserUtilTests.assertNotNull((Object)type);
        XOTclParserUtilTests.assertEquals((String)"c::d", (String)type.getName());
        List levelsTo = TclParseUtil.findLevelsTo((ModuleDeclaration)module, (ASTNode)type);
        XOTclParserUtilTests.assertEquals((int)4, (int)levelsTo.size());
    }

    public void testParseUtil010() throws Throwable {
        String content = "namespace eval c::d  {\n}\nnamespace eval a {\n\tnamespace eval c {\n\t\tnamespace eval d {\n\t\t}\n\t}\tnamespace eval c::d {\n\t}\n\tnamespace eval b {\n\t\tnamespace eval c::d {\n\t\t}\n\t\tproc c::d::q { } {\n\t\t}\n\t}\n}\n";
        ModuleDeclaration module = this.parser(content);
        ASTNode[] nodes = this.findNodeByName(module, "c::d::q");
        XOTclParserUtilTests.assertEquals((int)1, (int)nodes.length);
        ASTNode node = nodes[0];
        TypeDeclaration type = TclParseUtil.findTclTypeDeclarationFrom((ModuleDeclaration)module, (ASTNode)node);
        XOTclParserUtilTests.assertNotNull((Object)type);
        XOTclParserUtilTests.assertEquals((String)"c::d", (String)type.getName());
        List levelsTo = TclParseUtil.findLevelsTo((ModuleDeclaration)module, (ASTNode)type);
        XOTclParserUtilTests.assertEquals((int)4, (int)levelsTo.size());
    }

    public void testParseUtil011() throws Throwable {
        String content = "namespace eval c::d  {\n}\nnamespace eval a {\n\tnamespace eval c {\n\t\tnamespace eval d {\n\t\t}\n\t}\tnamespace eval c::d {\n\t}\n\tnamespace eval b {\n\t\tnamespace eval c::d {\n\t\t}\n\t\tproc ::c::d::q { } {\n\t\t}\n\t}\n}\n";
        ModuleDeclaration module = this.parser(content);
        ASTNode[] nodes = this.findNodeByName(module, "::c::d::q");
        XOTclParserUtilTests.assertEquals((int)1, (int)nodes.length);
        ASTNode node = nodes[0];
        TypeDeclaration type = TclParseUtil.findTclTypeDeclarationFrom((ModuleDeclaration)module, (ASTNode)node);
        XOTclParserUtilTests.assertNotNull((Object)type);
        XOTclParserUtilTests.assertEquals((String)"c::d", (String)type.getName());
        List levelsTo = TclParseUtil.findLevelsTo((ModuleDeclaration)module, (ASTNode)type);
        XOTclParserUtilTests.assertEquals((int)2, (int)levelsTo.size());
    }

    public void testParseUtil012() throws Throwable {
        String content = "namespace eval c::d  {\n}\nnamespace eval a {\n\tnamespace eval c {\n\t\tnamespace eval d {\n\t\t}\n\t}\tnamespace eval c::d {\n\t}\n\tnamespace eval b {\n\t\tnamespace eval c::d {\n\t\t}\n\t\tproc ::a::c::d::q { } {\n\t\t}\n\t}\n}\n";
        ModuleDeclaration module = this.parser(content);
        ASTNode[] nodes = this.findNodeByName(module, "::a::c::d::q");
        XOTclParserUtilTests.assertEquals((int)1, (int)nodes.length);
        ASTNode node = nodes[0];
        TypeDeclaration type = TclParseUtil.findTclTypeDeclarationFrom((ModuleDeclaration)module, (ASTNode)node);
        XOTclParserUtilTests.assertNotNull((Object)type);
        XOTclParserUtilTests.assertEquals((String)"d", (String)type.getName());
        List levelsTo = TclParseUtil.findLevelsTo((ModuleDeclaration)module, (ASTNode)type);
        XOTclParserUtilTests.assertEquals((int)4, (int)levelsTo.size());
    }

    public void testParseUtil013() throws Throwable {
        String content = "namespace eval c::d  {\n}\nnamespace eval a {\n\tnamespace eval c {\n\t\tnamespace eval d {\n\t\t}\n\t}\tnamespace eval c::d {\n\t}\n\tnamespace eval b {\n\t\tnamespace eval c::d {\n\t\t}\n\t\tproc ::a::b::c::d::q { } {\n\t\t}\n\t}\n}\n";
        ModuleDeclaration module = this.parser(content);
        ASTNode[] nodes = this.findNodeByName(module, "::a::b::c::d::q");
        XOTclParserUtilTests.assertEquals((int)1, (int)nodes.length);
        ASTNode node = nodes[0];
        TypeDeclaration type = TclParseUtil.findTclTypeDeclarationFrom((ModuleDeclaration)module, (ASTNode)node);
        XOTclParserUtilTests.assertNotNull((Object)type);
        XOTclParserUtilTests.assertEquals((String)"c::d", (String)type.getName());
        List levelsTo = TclParseUtil.findLevelsTo((ModuleDeclaration)module, (ASTNode)type);
        XOTclParserUtilTests.assertEquals((int)4, (int)levelsTo.size());
    }

    public void testParseUtil014() throws Throwable {
        String content = "namespace eval c::d  {\n\tnamespace eval a {\n\t\tnamespace eval gamma::delta {\n\t\t}\n\t}\n}\nnamespace eval a {\n\t\tproc ::c::d::a::gamma::delta::q { } {\n\t\t}\n\t}\n}\n";
        ModuleDeclaration module = this.parser(content);
        ASTNode[] nodes = this.findNodeByName(module, "::c::d::a::gamma::delta::q");
        XOTclParserUtilTests.assertEquals((int)1, (int)nodes.length);
        ASTNode node = nodes[0];
        TypeDeclaration type = TclParseUtil.findTclTypeDeclarationFrom((ModuleDeclaration)module, (ASTNode)node);
        XOTclParserUtilTests.assertNotNull((Object)type);
        XOTclParserUtilTests.assertEquals((String)"gamma::delta", (String)type.getName());
        List levelsTo = TclParseUtil.findLevelsTo((ModuleDeclaration)module, (ASTNode)type);
        XOTclParserUtilTests.assertEquals((int)4, (int)levelsTo.size());
    }

    private ASTNode[] findNodeByName(ModuleDeclaration module, final String name) throws Exception {
        final ArrayList results = new ArrayList();
        module.traverse(new ASTVisitor(){

            public boolean endvisit(TypeDeclaration s) throws Exception {
                if (s.getName().equals(name)) {
                    return results.add(s);
                }
                return super.endvisit(s);
            }

            public boolean visit(MethodDeclaration s) throws Exception {
                if (s.getName().equals(name)) {
                    return results.add(s);
                }
                return super.visit(s);
            }
        });
        return results.toArray(new ASTNode[results.size()]);
    }

    private ModuleDeclaration parser(String content) {
        TclSourceParser parser = new TclSourceParser();
        ModuleDeclaration module = parser.parse("file".toCharArray(), content.toCharArray(), null);
        XOTclParserUtilTests.assertNotNull((Object)module);
        return module;
    }
}

