/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.ui.externalchecker;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.validators.core.IValidator;
import org.eclipse.dltk.validators.core.ValidatorRuntime;
import org.eclipse.dltk.validators.internal.core.externalchecker.ExternalChecker;
import org.eclipse.dltk.validators.internal.core.externalchecker.ExternalCheckerProblem;
import org.eclipse.dltk.validators.internal.core.externalchecker.ExternalCheckerWildcardManager;
import org.eclipse.dltk.validators.internal.core.externalchecker.Rule;
import org.eclipse.dltk.validators.internal.core.externalchecker.WildcardException;
import org.eclipse.dltk.validators.internal.core.externalchecker.WildcardMatcher;
import org.eclipse.dltk.validators.internal.ui.externalchecker.ExternalCheckerSyntaxHyperlink;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public class ExternalCheckerConsoleTracker
implements IPatternMatchListener {
    protected TextConsole console;
    private List rules = new ArrayList();

    public ExternalCheckerConsoleTracker() {
        IValidator[] validators = ValidatorRuntime.getActiveValidators();
        int i = 0;
        while (i < validators.length) {
            if (validators[i] instanceof ExternalChecker) {
                ExternalChecker checker = (ExternalChecker)validators[i];
                int j = 0;
                while (j < checker.getNRules()) {
                    this.rules.add(checker.getRule(j));
                    ++j;
                }
            }
            ++i;
        }
    }

    public void connect(TextConsole console) {
        this.console = console;
    }

    public void disconnect() {
        this.console = null;
    }

    protected TextConsole getConsole() {
        return this.console;
    }

    public int getCompilerFlags() {
        return 0;
    }

    public String getLineQualifier() {
        return null;
    }

    public void matchFound(PatternMatchEvent event) {
        try {
            IOConsole cons = (IOConsole)event.getSource();
            IDocument doc = cons.getDocument();
            int offset = event.getOffset();
            int length = event.getLength();
            String text = doc.get(offset, length);
            List wlist = ExternalCheckerWildcardManager.loadCustomWildcards();
            WildcardMatcher wmatcher = new WildcardMatcher(wlist);
            int i = 0;
            while (i < this.rules.size()) {
                block5: {
                    Rule rule = (Rule)this.rules.get(i);
                    try {
                        ExternalCheckerProblem problem = wmatcher.match(rule, text);
                        if (problem == null) break block5;
                        ExternalCheckerSyntaxHyperlink link = new ExternalCheckerSyntaxHyperlink(this.console, problem);
                        this.console.addHyperlink((IHyperlink)link, offset, text.length());
                        break;
                    }
                    catch (WildcardException wildcardException) {}
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public String getPattern() {
        return ".+";
    }
}

