/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.wizards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.ui.util.SWTUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ModelElementLabelProvider;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.dltk.ui.environment.IEnvironmentUI;
import org.eclipse.dltk.ui.text.templates.ICodeTemplateArea;
import org.eclipse.dltk.ui.text.templates.SourceModuleTemplateContext;
import org.eclipse.dltk.ui.util.CodeGeneration;
import org.eclipse.dltk.ui.wizards.Messages;
import org.eclipse.dltk.ui.wizards.NewContainerWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;

public abstract class NewSourceModulePage
extends NewContainerWizardPage {
    private static final String REMOTE_FOLDER = "NewSourceModulePage.remoteFolder";
    private static final String FILE = "NewSourceModulePage.file";
    private IStatus sourceMoudleStatus;
    private IStatus remoteFolderStatus = null;
    private IScriptFolder currentScriptFolder;
    private StringDialogField fileDialogField;
    private StringButtonDialogField remoteFolderDialogField;
    private Button createLink;
    private Label remoteFolderLabel;
    private Composite remoteFolderLabelContainer;
    private static final String NO_TEMPLATE = "";
    private Template[] fTemplates;
    private ComboDialogField fTemplateDialogField = null;

    private IStatus fileChanged() {
        StatusInfo status = new StatusInfo();
        if (this.getFileText().length() == 0) {
            status.setError(Messages.NewSourceModulePage_pathCannotBeEmpty);
        } else {
            ISourceModule module;
            if (!Path.EMPTY.isValidSegment(this.getFileText())) {
                status.setError(Messages.NewSourceModulePage_InvalidFileName);
            }
            if (this.currentScriptFolder != null && (module = this.currentScriptFolder.getSourceModule(this.getFileName())).exists()) {
                status.setError(Messages.NewSourceModulePage_fileAlreadyExists);
            }
        }
        return status;
    }

    private IStatus remoteFolderChanged() {
        StatusInfo status = new StatusInfo();
        if (this.remoteFolderDialogField != null && this.remoteFolderDialogField.isEnabled()) {
            String remoteFolder = this.remoteFolderDialogField.getText();
            if (remoteFolder.length() == 0) {
                status.setError(Messages.NewSourceModulePage_remoteFolderCannotBeEmpty);
            } else {
                IFileHandle file;
                IEnvironment environment = this.getLinkedEnvironment();
                if (!(environment == null || (file = environment.getFile((IPath)new Path(remoteFolder))) != null && file.isDirectory())) {
                    status.setError(Messages.NewSourceModulePage_remoteFolderNotExist);
                }
            }
        }
        return status;
    }

    public void init(IStructuredSelection selection) {
        if (this.isLinkingSupported() && this.remoteFolderDialogField == null) {
            this.createRemoteFolderField();
        }
        if (this.getTemplateArea() != null) {
            this.createTemplateField();
        }
        IModelElement element = this.getInitialScriptElement(selection);
        this.initContainerPage(element);
        this.updateTemplates();
        this.remoteFolderStatus = this.remoteFolderChanged();
        this.updateStatus(new IStatus[]{this.containerStatus, this.remoteFolderStatus, this.fileChanged()});
    }

    protected void createRemoteFolderControls(Composite parent, int nColumns) {
        this.remoteFolderLabelContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.remoteFolderLabelContainer.setLayout((Layout)layout);
        this.remoteFolderLabelContainer.setLayoutData((Object)StringDialogField.gridDataForLabel(1));
        this.remoteFolderLabel = this.remoteFolderDialogField.getLabelControl(this.remoteFolderLabelContainer);
        this.remoteFolderLabel.setLayoutData((Object)StringDialogField.gridDataForLabel(1));
        this.createLink = new Button(this.remoteFolderLabelContainer, 32);
        this.createLink.setText(Messages.NewSourceModulePage_LinkToFolder);
        this.createLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewSourceModulePage.this.remoteFolderDialogField.setEnabled(NewSourceModulePage.this.createLink.getSelection());
                NewSourceModulePage.this.remoteFolderStatus = NewSourceModulePage.this.remoteFolderChanged();
                NewSourceModulePage.this.handleFieldChanged(NewSourceModulePage.REMOTE_FOLDER);
            }
        });
        this.createLink.setLayoutData((Object)StringDialogField.gridDataForLabel(1));
        Text text = this.remoteFolderDialogField.getTextControl(parent);
        text.setLayoutData((Object)StringDialogField.gridDataForText(nColumns - 2));
        Button button = this.remoteFolderDialogField.getChangeControl(parent);
        button.setLayoutData((Object)StringButtonDialogField.gridDataForButton(button, 1));
        this.updateRemoteFolderLableEnablement();
    }

    protected void createFileControls(Composite parent, int nColumns) {
        this.fileDialogField.doFillIntoGrid(parent, nColumns - 1);
        Text text = this.fileDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)text);
        DialogField.createEmptySpace(parent);
    }

    protected void createTemplateControls(Composite parent, int nColumns) {
        this.fTemplateDialogField.doFillIntoGrid(parent, nColumns - 1);
        LayoutUtil.setWidthHint((Control)this.fTemplateDialogField.getComboControl(null), this.getMaxFieldWidth());
        Button configureTemplates = new Button(parent, 8);
        GridData configureData = new GridData(4, 0, false, false);
        configureData.widthHint = SWTUtil.getButtonWidthHint(configureTemplates);
        configureTemplates.setLayoutData((Object)configureData);
        configureTemplates.setText(Messages.NewSourceModulePage_ConfigureTemplates);
        configureTemplates.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String templateName = null;
                Template template = NewSourceModulePage.this.getSelectedTemplate();
                if (template != null) {
                    templateName = template.getName();
                }
                HashMap<String, String> data = null;
                if (templateName != null) {
                    data = new HashMap<String, String>();
                    data.put("CodeTemplatePreferencePage.select_template", templateName);
                }
                String prefPageId = NewSourceModulePage.this.getTemplateArea().getTemplatePreferencePageId();
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)NewSourceModulePage.this.getShell(), (String)prefPageId, (String[])new String[]{prefPageId}, data);
                if (dialog.open() == 0) {
                    NewSourceModulePage.this.updateTemplates();
                }
            }
        });
    }

    protected void updateTemplates() {
        if (this.fTemplateDialogField != null) {
            Template template;
            Template selected = this.getSelectedTemplate();
            String name = selected != null ? selected.getName() : this.getLastUsedTemplateName();
            this.fTemplates = this.getApplicableTemplates();
            int idx = 0;
            String[] names = new String[this.fTemplates.length + 1];
            int i = 0;
            while (i < this.fTemplates.length) {
                names[i + 1] = this.fTemplates[i].getName();
                if (name != null && name.equals(names[i + 1])) {
                    idx = i + 1;
                }
                ++i;
            }
            if (idx == 0 && (template = this.getDefaultTemplate()) != null) {
                int i2 = 0;
                while (i2 < this.fTemplates.length) {
                    if (template == this.fTemplates[i2]) {
                        idx = i2 + 1;
                        break;
                    }
                    ++i2;
                }
            }
            names[0] = Messages.NewSourceModulePage_noTemplate;
            this.fTemplateDialogField.setItems(names);
            this.fTemplateDialogField.selectItem(idx);
        }
    }

    protected Template getDefaultTemplate() {
        ICodeTemplateArea templateArea;
        String defaultTemplateId = this.getDefaultCodeTemplateId();
        if (defaultTemplateId != null && (templateArea = this.getTemplateArea()) != null) {
            TemplateStore store = templateArea.getTemplateAccess().getTemplateStore();
            return store.findTemplateById(defaultTemplateId);
        }
        return null;
    }

    protected Template[] getApplicableTemplates() {
        ArrayList<Template> result = new ArrayList<Template>();
        ICodeTemplateArea templateArea = this.getTemplateArea();
        if (templateArea != null) {
            TemplateStore store = templateArea.getTemplateAccess().getTemplateStore();
            String[] contextTypeIds = this.getCodeTemplateContextTypeIds();
            int i = 0;
            while (i < contextTypeIds.length) {
                Template[] templates = store.getTemplates(contextTypeIds[i]);
                Arrays.sort(templates, new Comparator(){

                    public int compare(Object arg0, Object arg1) {
                        Template t0 = (Template)arg0;
                        Template t1 = (Template)arg1;
                        return t0.getName().compareToIgnoreCase(t1.getName());
                    }
                });
                int j = 0;
                while (j < templates.length) {
                    result.add(templates[j]);
                    ++j;
                }
                ++i;
            }
        }
        return result.toArray(new Template[result.size()]);
    }

    protected String getLastUsedTemplateKey() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + "_LAST_USED_TEMPLATE";
    }

    protected String getLastUsedTemplateName() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        return dialogSettings != null ? dialogSettings.get(this.getLastUsedTemplateKey()) : null;
    }

    protected void saveLastUsedTemplateName(String name) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null) {
            dialogSettings.put(this.getLastUsedTemplateKey(), name);
        }
    }

    protected Template getSelectedTemplate() {
        int index;
        if (this.fTemplateDialogField != null && (index = this.fTemplateDialogField.getSelectionIndex() - 1) >= 0 && index < this.fTemplates.length) {
            return this.fTemplates[index];
        }
        return null;
    }

    public NewSourceModulePage() {
        super("wizardPage");
        this.setTitle(this.getPageTitle());
        this.setDescription(this.getPageDescription());
        this.sourceMoudleStatus = new StatusInfo();
        this.fileDialogField = new StringDialogField();
        this.fileDialogField.setLabelText(Messages.NewSourceModulePage_file);
        this.fileDialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                NewSourceModulePage.this.sourceMoudleStatus = NewSourceModulePage.this.fileChanged();
                NewSourceModulePage.this.handleFieldChanged(NewSourceModulePage.FILE);
            }
        });
    }

    protected void createRemoteFolderField() {
        this.remoteFolderDialogField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                IEnvironmentUI ui;
                String folder;
                IEnvironment environment = NewSourceModulePage.this.getLinkedEnvironment();
                if (environment == null) {
                    environment = NewSourceModulePage.this.getEnvironment();
                }
                if (environment != null && (folder = (ui = (IEnvironmentUI)environment.getAdapter(IEnvironmentUI.class)).selectFolder(NewSourceModulePage.this.getShell(), NewSourceModulePage.this.remoteFolderDialogField.getText())) != null) {
                    NewSourceModulePage.this.remoteFolderDialogField.setText(folder);
                }
            }
        });
        this.remoteFolderDialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                NewSourceModulePage.this.remoteFolderStatus = NewSourceModulePage.this.remoteFolderChanged();
                NewSourceModulePage.this.handleFieldChanged(NewSourceModulePage.REMOTE_FOLDER);
            }
        });
        this.remoteFolderDialogField.setButtonLabel(Messages.NewSourceModulePage_remoteFolder_BrowseButton);
        this.remoteFolderDialogField.setLabelText(Messages.NewSourceModulePage_remoteFolder_label);
    }

    protected void createTemplateField() {
        this.fTemplateDialogField = new ComboDialogField(8);
        this.fTemplateDialogField.setLabelText(Messages.NewSourceModulePage_Template);
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName == "NewContainerWizardPage.container") {
            IProjectFragment fragment = this.getProjectFragment();
            this.currentScriptFolder = fragment != null ? fragment.getScriptFolder(NO_TEMPLATE) : null;
            this.sourceMoudleStatus = this.fileChanged();
            this.remoteFolderStatus = this.remoteFolderChanged();
        }
        this.updateStatus(new IStatus[]{this.containerStatus, this.remoteFolderStatus, this.sourceMoudleStatus});
    }

    public ISourceModule createFile(IProgressMonitor monitor) throws CoreException {
        IEnvironment environment;
        IResource resource;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String fileName = this.getFileName();
        ISourceModule module = this.currentScriptFolder.getSourceModule(fileName);
        if (this.isLinkingSupported() && this.isLinkingEnabled() && (resource = this.currentScriptFolder.getResource()) != null && (resource.getType() & 6) != 0 && this.remoteFolderDialogField.isEnabled() && (environment = this.getEnvironment()) != null) {
            IFileHandle folder = environment.getFile((IPath)new Path(this.remoteFolderDialogField.getText()));
            IFileHandle handle = folder.getChild(fileName);
            boolean fileExists = handle.exists();
            if (!fileExists) {
                try {
                    handle.openOutputStream(monitor).close();
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.ui", e.getMessage(), (Throwable)e));
                }
            }
            IFile file = ((IContainer)resource).getFile((IPath)new Path(fileName));
            file.createLink(handle.toURI(), 0, monitor);
            if (fileExists) {
                return module;
            }
        }
        this.currentScriptFolder.createSourceModule(fileName, this.getFileContent(module), true, monitor);
        return module;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 0, true, false);
        composite.setLayoutData((Object)layoutData);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.createContentControls(composite, 3);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    protected void createContentControls(Composite composite, int nColumns) {
        this.createContainerControls(composite, nColumns);
        if (this.remoteFolderDialogField != null) {
            this.createRemoteFolderControls(composite, nColumns);
        }
        this.createFileControls(composite, nColumns);
        if (this.fTemplateDialogField != null) {
            this.createTemplateControls(composite, nColumns);
        }
    }

    protected String getFileText() {
        return this.fileDialogField.getText();
    }

    protected String getFileName() {
        String fileText = this.getFileText();
        String[] extensions = this.getFileExtensions();
        int i = 0;
        while (i < extensions.length) {
            String extension = extensions[i];
            if (extension.length() > 0 && fileText.endsWith("." + extension)) {
                return fileText;
            }
            ++i;
        }
        return String.valueOf(fileText) + "." + extensions[0];
    }

    protected String[] getFileExtensions() {
        String requiredNature = this.getRequiredNature();
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((String)requiredNature);
        String contentType = toolkit.getLanguageContentType();
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType type = manager.getContentType(contentType);
        if (type != null) {
            return type.getFileSpecs(8);
        }
        return new String[]{NO_TEMPLATE};
    }

    protected IScriptFolder chooseScriptFolder() {
        Object element;
        ElementListSelectionDialog dialog;
        block5: {
            ModelElementLabelProvider labelProvider = new ModelElementLabelProvider(ModelElementLabelProvider.SHOW_DEFAULT);
            dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
            dialog.setIgnoreCase(false);
            dialog.setTitle(Messages.NewSourceModulePage_selectScriptFolder);
            dialog.setMessage(Messages.NewSourceModulePage_selectScriptFolder);
            dialog.setEmptyListMessage(Messages.NewSourceModulePage_noFoldersAvailable);
            IProjectFragment projectFragment = this.getProjectFragment();
            if (projectFragment != null) {
                try {
                    dialog.setElements((Object[])projectFragment.getChildren());
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block5;
                    e.printStackTrace();
                }
            }
        }
        dialog.setHelpAvailable(false);
        if (this.currentScriptFolder != null) {
            dialog.setInitialSelections(new Object[]{this.currentScriptFolder});
        }
        if (dialog.open() == 0 && (element = dialog.getFirstResult()) instanceof IScriptFolder) {
            return (IScriptFolder)element;
        }
        return null;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    protected void setFocus() {
        this.fileDialogField.setFocus();
    }

    protected abstract String getPageTitle();

    protected abstract String getPageDescription();

    protected ICodeTemplateArea getTemplateArea() {
        return null;
    }

    protected String[] getCodeTemplateContextTypeIds() {
        return null;
    }

    protected String getDefaultCodeTemplateId() {
        return null;
    }

    protected String getFileContent(ISourceModule module) throws CoreException {
        ICodeTemplateArea templateArea = this.getTemplateArea();
        if (templateArea != null) {
            Template template = this.getSelectedTemplate();
            this.saveLastUsedTemplateName(template != null ? template.getName() : NO_TEMPLATE);
            if (template != null) {
                TemplateContextType contextType = templateArea.getTemplateAccess().getContextTypeRegistry().getContextType(template.getContextTypeId());
                SourceModuleTemplateContext context = new SourceModuleTemplateContext(contextType, CodeGeneration.getLineDelimiterUsed((IModelElement)module));
                context.setSourceModuleVariables(module);
                String[] fullLine = new String[]{};
                String result = CodeGeneration.evaluateTemplate(context, template, fullLine);
                return result != null ? result : NO_TEMPLATE;
            }
        }
        return this.getFileContent();
    }

    protected String getFileContent() {
        return NO_TEMPLATE;
    }

    protected boolean isLinkingSupported() {
        return false;
    }

    protected boolean isLinkingEnabled() {
        return true;
    }

    public void setScriptFolder(IScriptFolder root, boolean canBeModified) {
        super.setScriptFolder(root, canBeModified);
        if (this.remoteFolderDialogField != null) {
            List remotePaths;
            IProjectFragment fragment;
            this.updateRemoteFolderLableEnablement();
            if (this.remoteFolderDialogField.getText().length() == 0 && (fragment = this.getProjectFragment()) != null && (remotePaths = this.collectLinkedPaths(fragment.getScriptProject().getProject())) != null) {
                IPath base = null;
                for (IPath path : remotePaths) {
                    if (base == null || path.isPrefixOf(base)) {
                        base = path;
                        continue;
                    }
                    int segments = path.matchingFirstSegments(base);
                    if (segments < 2) continue;
                    base = base.uptoSegment(segments);
                }
                if (base != null && base.segmentCount() >= 1) {
                    this.remoteFolderDialogField.setText(base.toString());
                }
            }
        }
    }

    private void updateRemoteFolderLableEnablement() {
        if (this.getLinkedEnvironment() != null) {
            if (this.remoteFolderLabel != null) {
                ((GridData)this.remoteFolderLabel.getLayoutData()).exclude = false;
                this.remoteFolderLabel.setVisible(true);
            }
            if (this.createLink != null) {
                ((GridData)this.createLink.getLayoutData()).exclude = true;
                this.createLink.setVisible(false);
            }
            this.remoteFolderDialogField.setEnabled(true);
        } else {
            if (this.remoteFolderLabel != null) {
                ((GridData)this.remoteFolderLabel.getLayoutData()).exclude = true;
                this.remoteFolderLabel.setVisible(false);
            }
            if (this.createLink != null) {
                ((GridData)this.createLink.getLayoutData()).exclude = false;
                this.createLink.setVisible(true);
                this.remoteFolderDialogField.setEnabled(this.createLink.getSelection());
            }
        }
        if (this.remoteFolderLabelContainer != null) {
            this.remoteFolderLabelContainer.layout();
        }
        this.remoteFolderStatus = this.remoteFolderChanged();
    }

    protected IEnvironment getLinkedEnvironment() {
        IProjectFragment fragment = this.getProjectFragment();
        if (fragment != null) {
            return this.getLinkedEnvironment(fragment.getScriptProject().getProject());
        }
        return null;
    }

    protected IEnvironment getLinkedEnvironment(IProject project) {
        String envId;
        if (project != null && (envId = EnvironmentManager.getEnvironmentId((IProject)project, (boolean)false)) != null) {
            return EnvironmentManager.getEnvironmentById((String)envId);
        }
        return null;
    }

    protected IEnvironment getEnvironment() {
        IProjectFragment fragment = this.getProjectFragment();
        if (fragment != null) {
            return EnvironmentManager.getEnvironment((IProject)fragment.getScriptProject().getProject());
        }
        return null;
    }

    protected List collectLinkedPaths(IProject project) {
        IEnvironment environment;
        block5: {
            environment = EnvironmentManager.getEnvironment((IProject)project);
            if (environment != null) break block5;
            return null;
        }
        try {
            HashSet<IPath> result = new HashSet<IPath>();
            IResource[] children = project.members();
            int i = 0;
            while (i < children.length) {
                IFileHandle file;
                IResource child = children[i];
                if (child.isLinked() && (file = environment.getFile(child.getLocationURI())) != null && environment.equals(file.getEnvironment())) {
                    IPath path = file.getPath();
                    result.add(file.isFile() ? path.removeLastSegments(1) : path);
                }
                ++i;
            }
            return !result.isEmpty() ? new ArrayList(result) : null;
        }
        catch (CoreException e) {
            DLTKUIPlugin.log(e);
            return null;
        }
    }
}

