/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.tcl.internal.ui.TclImages;
import org.eclipse.dltk.tcl.internal.ui.wizards.TclProjectWizardFirstPage;
import org.eclipse.dltk.tcl.internal.ui.wizards.TclProjectWizardSecondPage;
import org.eclipse.dltk.tcl.internal.ui.wizards.TclWizardMessages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.wizards.IProjectWizardLastPage;
import org.eclipse.dltk.ui.wizards.NewElementWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class TclProjectCreationWizard
extends NewElementWizard
implements INewWizard,
IExecutableExtension {
    public static final String ID_WIZARD = "org.eclipse.dltk.tcl.internal.ui.wizards.TclProjectWizard";
    protected TclProjectWizardFirstPage fFirstPage;
    protected TclProjectWizardSecondPage fSecondPage;
    private IConfigurationElement fConfigElement;

    public TclProjectCreationWizard() {
        this.setDefaultPageImageDescriptor(TclImages.DESC_WIZBAN_PROJECT_CREATION);
        this.setDialogSettings(DLTKUIPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(TclWizardMessages.ProjectCreationWizard_title);
    }

    public void addPages() {
        super.addPages();
        this.fFirstPage = new TclProjectWizardFirstPage();
        this.addPage((IWizardPage)this.fFirstPage);
        this.fSecondPage = new TclProjectWizardSecondPage(this.fFirstPage);
        this.addPage((IWizardPage)this.fSecondPage);
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.getLastPage().performFinish(monitor);
    }

    public boolean performFinish() {
        boolean res = super.performFinish();
        if (res) {
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
            this.selectAndReveal((IResource)this.getLastPage().getScriptProject().getProject());
        }
        return res;
    }

    private IProjectWizardLastPage getLastPage() {
        return this.fSecondPage;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    public boolean performCancel() {
        this.getLastPage().performCancel();
        return super.performCancel();
    }

    public IModelElement getCreatedElement() {
        return DLTKCore.create((IProject)this.fFirstPage.getProjectHandle());
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        while (nextPage != null && !this.isEnabledPage(nextPage)) {
            nextPage = super.getNextPage(nextPage);
        }
        return nextPage;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage prevPage = super.getPreviousPage(page);
        while (prevPage != null && !this.isEnabledPage(prevPage)) {
            prevPage = super.getPreviousPage(prevPage);
        }
        return prevPage;
    }

    public boolean canFinish() {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            IWizardPage page = pages[i];
            if (this.isEnabledPage(page) && !page.isPageComplete()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isEnabledPage(IWizardPage page) {
        return true;
    }
}

