/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.templates;

import java.io.IOException;
import org.eclipse.dltk.tcl.internal.ui.TclUI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;

public class TclTemplateAccess {
    private static final String CUSTOM_TEMPLATES_KEY = "org.eclipse.tcl.Templates";
    private static TclTemplateAccess instance;
    private TemplateStore fStore;
    private ContributionContextTypeRegistry fRegistry;

    public static TclTemplateAccess getInstance() {
        if (instance == null) {
            instance = new TclTemplateAccess();
        }
        return instance;
    }

    public TemplateStore getTemplateStore() {
        if (this.fStore == null) {
            this.fStore = new ContributionTemplateStore(this.getContextTypeRegistry(), this.getPreferenceStore(), CUSTOM_TEMPLATES_KEY);
            try {
                this.fStore.load();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return this.fStore;
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = new ContributionContextTypeRegistry();
            this.fRegistry.addContextType("tclUniversalTemplateContextType");
        }
        return this.fRegistry;
    }

    protected IPreferenceStore getPreferenceStore() {
        return TclUI.getDefault().getPreferenceStore();
    }
}

