/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.dltk.ui.actions;

import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.search.DLTKSearchQuery;
import org.eclipse.dltk.internal.ui.search.DLTKSearchScopeFactory;
import org.eclipse.dltk.ui.search.ElementQuerySpecification;
import org.eclipse.dltk.ui.search.QuerySpecification;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.internal.context.ui.ContextWorkingSetManager;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class FindReferencesInContextAction
extends Action
implements IWorkbenchWindowActionDelegate {
    public void run(IAction action) {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor != null && editor instanceof ScriptEditor) {
            try {
                IModelElement[] resolved = SelectionConverter.codeResolve((IEditorPart)((ScriptEditor)editor));
                if (resolved != null && resolved.length == 1 && resolved[0] != null) {
                    IDLTKSearchScope scope;
                    DLTKSearchQuery query;
                    IModelElement element = resolved[0];
                    ContextWorkingSetManager updater = ContextWorkingSetManager.getDefault();
                    if (updater != null && updater.getWorkingSet() != null && (query = new DLTKSearchQuery((QuerySpecification)new ElementQuerySpecification(element, 1, scope = DLTKSearchScopeFactory.getInstance().createSearchScope(updater.getWorkingSet(), false, null), "Mylyn Current Task Context"))) != null) {
                        NewSearchUI.activateSearchResultView();
                        if (query.canRunInBackground()) {
                            NewSearchUI.runQueryInBackground((ISearchQuery)query);
                        } else {
                            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                            NewSearchUI.runQueryInForeground((IRunnableContext)progressService, (ISearchQuery)query);
                        }
                    }
                }
            }
            catch (ModelException modelException) {}
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

