/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.Messages;
import org.eclipse.dltk.launching.ScriptRuntime;

public class InterpreterSearcher {
    private Set searchedFiles = new HashSet();
    private List found = new ArrayList();
    private List types = new ArrayList();
    private String natureId;
    private Set ignore;
    static /* synthetic */ Class class$0;

    protected void searchFast(IProgressMonitor monitor, IEnvironment environment, int deep) {
        IExecutionEnvironment exeEnv;
        if (monitor.isCanceled()) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.core.environment.IExecutionEnvironment");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((exeEnv = (IExecutionEnvironment)environment.getAdapter((Class)clazz)) == null) {
            return;
        }
        Map env = exeEnv.getEnvironmentVariables(true);
        String path = null;
        Iterator it = env.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (name.compareToIgnoreCase("path") != 0) continue;
            path = (String)env.get(name);
        }
        if (path == null) {
            return;
        }
        String separator = environment.getPathsSeparator();
        ArrayList<IPath> folders = new ArrayList<IPath>();
        String[] res = path.split(separator);
        int i = 0;
        while (i < res.length) {
            folders.add(Path.fromOSString((String)res[i]));
            ++i;
        }
        Iterator iter = folders.iterator();
        while (iter.hasNext()) {
            IFileHandle f;
            IPath folder = (IPath)iter.next();
            if (folder == null || !(f = environment.getFile(folder)).isDirectory()) continue;
            this.search(f, monitor, deep);
        }
    }

    protected void search(IFileHandle directory, IProgressMonitor monitor, int deep) {
        if (deep == 0) {
            return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        if (this.searchedFiles.contains(directory)) {
            return;
        }
        IFileHandle[] files = directory.getChildren();
        if (files == null) {
            return;
        }
        ArrayList<IFileHandle> subDirs = new ArrayList<IFileHandle>();
        int i = 0;
        while (i < files.length) {
            if (monitor.isCanceled()) {
                return;
            }
            IFileHandle file = files[i];
            monitor.subTask(MessageFormat.format(Messages.InterpreterSearcher_foundSearching, Integer.toString(this.found.size()), file.getCanonicalPath()));
            if (!file.isDirectory() || !file.isSymlink()) {
                IInterpreterInstallType[] installTypes = ScriptRuntime.getInterpreterInstallTypes(this.natureId);
                if (!this.ignore.contains(file)) {
                    boolean validLocation = false;
                    int j = 0;
                    while (j < installTypes.length) {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        IInterpreterInstallType installType = installTypes[j];
                        IStatus status = installType.validatePossiblyName(file);
                        if (status.isOK()) {
                            this.found.add(file);
                            this.types.add(installType);
                            validLocation = true;
                            break;
                        }
                        ++j;
                    }
                    if (file.isDirectory() && !validLocation) {
                        subDirs.add(file);
                    }
                }
            }
            ++i;
        }
        while (!subDirs.isEmpty()) {
            IFileHandle subDir = (IFileHandle)subDirs.remove(0);
            this.search(subDir, monitor, deep - 1);
        }
        this.searchedFiles.add(directory);
    }

    public void search(IEnvironment environment, String natureId, Set ignore, int deep, IProgressMonitor monitor) {
        if (natureId == null) {
            throw new IllegalArgumentException();
        }
        this.found.clear();
        this.types.clear();
        this.searchedFiles.clear();
        this.natureId = natureId;
        this.ignore = ignore == null ? Collections.EMPTY_SET : ignore;
        this.searchFast((IProgressMonitor)(monitor == null ? new NullProgressMonitor() : monitor), environment, deep);
    }

    public boolean hasResults() {
        return !this.found.isEmpty();
    }

    public IFileHandle[] getFoundFiles() {
        return this.found.toArray(new IFileHandle[this.found.size()]);
    }

    public IInterpreterInstallType[] getFoundInstallTypes() {
        return this.types.toArray(new IInterpreterInstallType[this.types.size()]);
    }
}

